/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSymbolPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLSymbolEditor;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTableModel;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SWRLTable
extends SymbolTable
implements Disposable {
    public SWRLTable(SWRLTableModel tableModel, OWLModel owlModel) {
        super(tableModel, owlModel, true, new SWRLSymbolPanel(owlModel, true, true));
        TableColumn nameColumn = this.getColumnModel().getColumn(0);
        TableColumn expressionColumn = this.getColumnModel().getColumn(1);
        nameColumn.setPreferredWidth(150);
        expressionColumn.setPreferredWidth(700);
        this.setDefaultRenderer(SWRLImp.class, (TableCellRenderer)((Object)new ResourceRenderer()));
    }

    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel model, SymbolErrorDisplay errorDisplay) {
        return new SWRLSymbolEditor(model, errorDisplay);
    }

    public void dispose() {
        SWRLTableModel tableModel = (SWRLTableModel)this.getSymbolTableModel();
        tableModel.dispose();
    }

    protected String editMultiLine(RDFResource input) {
        return null;
    }

    protected Icon getDefaultCellEditorIcon(RDFResource RDFResource2) {
        return SWRLIcons.getImpIcon();
    }

    protected Collection getNavigationMenuItems(RDFResource RDFResource2) {
        SWRLImp imp = (SWRLImp)RDFResource2;
        Set set = imp.getReferencedInstances();
        ArrayList<RDFResource> result = new ArrayList<RDFResource>();
        for (RDFResource resource : set) {
            if (resource instanceof SWRLIndividual) continue;
            result.add(resource);
        }
        return result;
    }

    public SWRLImp getSelectedImp() {
        int row = this.getSelectedRow();
        if (row >= 0 && row < this.getModel().getRowCount()) {
            return (SWRLImp)this.getSymbolTableModel().getRDFResource(row);
        }
        return null;
    }

    protected String getToolTipText(RDFResource rdfResource) {
        if (rdfResource instanceof SWRLImp) {
            OWLDatatypeProperty commentSlot = this.getOWLModel().getRDFSCommentProperty();
            Object value = rdfResource.getPropertyValue(commentSlot);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof RDFSLiteral) {
                return ((RDFSLiteral)value).toString();
            }
            return null;
        }
        return null;
    }

    public void replaceImp(SWRLImp oldImp, SWRLImp newImp) {
        SWRLTableModel tableModel = (SWRLTableModel)this.getSymbolTableModel();
        int index = tableModel.indexOf(oldImp);
        if (tableModel.indexOf(newImp) >= 0) {
            tableModel.setRowOf(newImp, index);
            this.setSelectedRow(index);
        }
        oldImp.deleteImp();
    }

    public void setSelectedRow(RDFResource RDFResource2) {
        SWRLTableModel tableModel = (SWRLTableModel)this.getSymbolTableModel();
        int index = tableModel.indexOf((SWRLImp)RDFResource2);
        this.setSelectedRow(index);
    }
}

