/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.clsdesc.DisjointClassesTableModel;

public class DisjointClassesTableModelTestCase
extends AbstractJenaTestCase {
    public void testSubclassesDisjoint() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("Cls");
        superCls.setSubclassesDisjoint(true);
        OWLNamedClass a = this.owlModel.createOWLNamedSubclass("A", superCls);
        OWLNamedClass b = this.owlModel.createOWLNamedSubclass("B", superCls);
        OWLNamedClass c = this.owlModel.createOWLNamedSubclass("C", superCls);
        OWLNamedClass z = this.owlModel.createOWLNamedClass("Z");
        a.addDisjointClass(z);
        DisjointClassesTableModelTestCase.assertSize(3, a.getDisjointClasses());
        DisjointClassesTableModel tableModel = new DisjointClassesTableModel();
        tableModel.setCls(a);
        DisjointClassesTableModelTestCase.assertEquals((int)3, (int)tableModel.getRowCount());
        DisjointClassesTableModelTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(b));
        DisjointClassesTableModelTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(c));
        DisjointClassesTableModelTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(z));
    }

    public void testImportedClasses() throws Exception {
        this.loadRemoteOntology("importTravel.owl");
        OWLNamedClass adventureClass = this.owlModel.getOWLNamedClass("travel:Adventure");
        DisjointClassesTableModel tableModel = new DisjointClassesTableModel();
        tableModel.setCls(adventureClass);
        DisjointClassesTableModelTestCase.assertEquals((int)3, (int)tableModel.getRowCount());
        RDFSClass disjointClass = tableModel.getClass(0);
        DisjointClassesTableModelTestCase.assertFalse((boolean)tableModel.isDeleteEnabledFor(disjointClass));
        DisjointClassesTableModelTestCase.assertFalse((boolean)tableModel.isRemoveEnabledFor(disjointClass));
        DisjointClassesTableModelTestCase.assertFalse((boolean)tableModel.isCellEditable(0, 0));
    }

    public void testEditImportedClasses() throws Exception {
        this.loadRemoteOntology("importTravel.owl");
        OWLNamedClass activityClass = this.owlModel.getOWLNamedClass("travel:Activity");
        OWLNamedClass contactClass = this.owlModel.getOWLNamedClass("travel:Contact");
        DisjointClassesTableModelTestCase.assertNotNull((Object)activityClass);
        DisjointClassesTableModelTestCase.assertNotNull((Object)contactClass);
        DisjointClassesTableModelTestCase.assertSize(0, contactClass.getDisjointClasses());
        DisjointClassesTableModel tableModel = new DisjointClassesTableModel();
        tableModel.setCls(contactClass);
        DisjointClassesTableModelTestCase.assertEquals((int)0, (int)tableModel.getRowCount());
        contactClass.addDisjointClass(activityClass);
        DisjointClassesTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        DisjointClassesTableModelTestCase.assertEquals((Object)activityClass, (Object)tableModel.getClass(0));
        DisjointClassesTableModelTestCase.assertTrue((boolean)tableModel.isRemoveEnabledFor(activityClass));
    }

    public void testAddExpression() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        DisjointClassesTableModelTestCase.assertSize(0, c.getDisjointClasses());
        DisjointClassesTableModel tableModel = new DisjointClassesTableModel();
        tableModel.setCls(c);
        tableModel.addEmptyRow(0);
        tableModel.setValueAt("not Class", 0, 0);
        DisjointClassesTableModelTestCase.assertSize(1, c.getDisjointClasses());
        RDFSClass disjoint = (RDFSClass)c.getDisjointClasses().iterator().next();
        DisjointClassesTableModelTestCase.assertTrue((boolean)(disjoint instanceof OWLComplementClass));
        DisjointClassesTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        DisjointClassesTableModelTestCase.assertEquals((Object)disjoint, (Object)tableModel.getRDFResource(0));
    }
}

