/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metrics.lang;

import edu.stanford.smi.protegex.owl.ui.metrics.lang.ExpressivityIcons;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class DLNamePanel
extends JPanel {
    private List icons = new ArrayList();
    private int maxHeight = 0;
    private int maxWidth = 0;
    private Dimension prefSize;
    private static final int TRACKING_ADJUSTMENT = -7;

    public DLNamePanel(List langFeatures) {
        Iterator it = langFeatures.iterator();
        while (it.hasNext()) {
            ImageIcon curIcon = ExpressivityIcons.getIcon((String)it.next());
            if (curIcon == null) continue;
            this.icons.add(curIcon);
            if (curIcon.getIconHeight() > this.maxHeight) {
                this.maxHeight = curIcon.getIconHeight();
            }
            this.maxWidth += curIcon.getIconWidth() + -7;
        }
        this.prefSize = new Dimension(this.maxWidth, this.maxHeight);
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        for (ImageIcon curIcon : this.icons) {
            int y = this.maxHeight - curIcon.getIconHeight();
            g2.drawImage(curIcon.getImage(), x, y, null);
            x += curIcon.getIconWidth() + -7;
        }
    }
}

