/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.FileGraph;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestFileGraph
extends GraphTestBase {
    public TestFileGraph(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(TestFileGraph.class);
        testSuite.addTest((Test)new Case("x /R y", "xxxA", ".rdf"));
        testSuite.addTest((Test)new Case("x /R y", "xxxB", ".n3"));
        testSuite.addTest((Test)new Case("x /R y", "xxxC", ".nt"));
        testSuite.addTest((Test)new Case("x /R y; p /R q", "xxxD", ".rdf"));
        testSuite.addTest((Test)new Case("x /R y; p /R q", "xxxE", ".n3"));
        testSuite.addTest((Test)new Case("x /R y; p /R q", "xxxF", ".nt"));
        testSuite.addTest((Test)new Case("http://domain/S ftp:ftp/P O", "xxxG", ".rdf"));
        testSuite.addTest((Test)new Case("http://domain/S ftp:ftp/P O", "xxxH", ".nt"));
        testSuite.addTest((Test)new Case("http://domain/S ftp:ftp/P O", "xxxI", ".n3"));
        return testSuite;
    }

    public void testPlausibleGraphname() {
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("agnessi.rdf"));
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("parabola.nt"));
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("hyperbola.n3"));
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("chris.dollin.n3"));
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("hedgehog.spine.end.rdf"));
    }

    public void testisPlausibleUppercaseGraphname() {
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("LOUDER.RDF"));
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("BRIDGE.NT"));
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("NOTN2.N3"));
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("chris.dollin.N3"));
        TestFileGraph.assertTrue((boolean)FileGraph.isPlausibleGraphName("hedgehog.spine.end.RDF"));
    }

    public void testImPlausibleGraphName() {
        TestFileGraph.assertFalse((boolean)FileGraph.isPlausibleGraphName("undecorated"));
        TestFileGraph.assertFalse((boolean)FileGraph.isPlausibleGraphName("danger.exe"));
        TestFileGraph.assertFalse((boolean)FileGraph.isPlausibleGraphName("pretty.jpg"));
        TestFileGraph.assertFalse((boolean)FileGraph.isPlausibleGraphName("FileGraph.java"));
        TestFileGraph.assertFalse((boolean)FileGraph.isPlausibleGraphName("infix.rdf.c"));
    }

    public void testTransactionCommit() {
        Graph graph = TestFileGraph.graphWith("initial hasValue 42; also hasURI hello");
        Graph graph2 = TestFileGraph.graphWith("extra hasValue 17; also hasURI world");
        File file = FileUtils.tempFileName("fileGraph", ".n3");
        FileGraph fileGraph = new FileGraph(file, true, true);
        fileGraph.getBulkUpdateHandler().add(graph);
        fileGraph.getTransactionHandler().begin();
        fileGraph.getBulkUpdateHandler().add(graph2);
        fileGraph.getTransactionHandler().commit();
        Graph graph3 = TestFileGraph.graphWith("");
        graph3.getBulkUpdateHandler().add(graph);
        graph3.getBulkUpdateHandler().add(graph2);
        TestFileGraph.assertIsomorphic(graph3, fileGraph);
        Model model = ModelFactory.createDefaultModel();
        model.read("file:///" + file, "N3");
        TestFileGraph.assertIsomorphic(graph3, model.getGraph());
    }

    public void testTransactionAbort() {
        Graph graph = TestFileGraph.graphWith("initial hasValue 42; also hasURI hello");
        Graph graph2 = TestFileGraph.graphWith("extra hasValue 17; also hasURI world");
        File file = FileUtils.tempFileName("fileGraph", ".n3");
        FileGraph fileGraph = new FileGraph(file, true, true);
        fileGraph.getBulkUpdateHandler().add(graph);
        fileGraph.getTransactionHandler().begin();
        fileGraph.getBulkUpdateHandler().add(graph2);
        fileGraph.getTransactionHandler().abort();
        TestFileGraph.assertIsomorphic(graph, fileGraph);
    }

    public void testTransactionCommitThenAbort() {
        Graph graph = TestFileGraph.graphWith("A pings B; B pings C");
        Graph graph2 = TestFileGraph.graphWith("C pingedBy B; fileGraph rdf:type Graph");
        File file = FileUtils.tempFileName("fileGraph", ".n3");
        FileGraph fileGraph = new FileGraph(file, true, true);
        fileGraph.getTransactionHandler().begin();
        fileGraph.getBulkUpdateHandler().add(graph);
        fileGraph.getTransactionHandler().commit();
        fileGraph.getTransactionHandler().begin();
        fileGraph.getBulkUpdateHandler().add(graph2);
        fileGraph.getTransactionHandler().abort();
        TestFileGraph.assertIsomorphic(graph, fileGraph);
        Model model = ModelFactory.createDefaultModel();
        model.read("file:///" + file, "N3");
        TestFileGraph.assertIsomorphic(graph, model.getGraph());
    }

    private static class Case
    extends TestFileGraph {
        String content;
        String prefix;
        String suffix;

        Case(String string, String string2, String string3) {
            super("Case: " + string + " in " + string2 + "*" + string3);
            this.content = string;
            this.prefix = string2;
            this.suffix = string3;
        }

        public void runTest() {
            File file = FileUtils.tempFileName(this.prefix, this.suffix);
            Graph graph = Case.graphWith(this.content);
            FileGraph fileGraph = new FileGraph(file, true, true);
            fileGraph.getBulkUpdateHandler().add(graph);
            fileGraph.close();
            FileGraph fileGraph2 = new FileGraph(file, false, true);
            Case.assertIsomorphic(graph, fileGraph2);
            fileGraph2.close();
        }
    }
}

