/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.GraphMemBulkUpdateHandler;
import com.hp.hpl.jena.mem.GraphMemQueryHandler;
import com.hp.hpl.jena.mem.GraphTripleStore;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class GraphMem
extends GraphMemBase
implements Graph {
    protected TripleStore store = new GraphTripleStore(this);

    public GraphMem() {
        this(ReificationStyle.Minimal);
    }

    public GraphMem(ReificationStyle reificationStyle) {
        super(reificationStyle);
    }

    protected void destroy() {
        this.store.close();
    }

    public void performAdd(Triple triple) {
        if (!this.getReifier().handledAdd(triple)) {
            this.store.add(triple);
        }
    }

    public void performDelete(Triple triple) {
        if (!this.getReifier().handledRemove(triple)) {
            this.store.delete(triple);
        }
    }

    public int graphBaseSize() {
        return this.store.size();
    }

    public QueryHandler queryHandler() {
        if (this.queryHandler == null) {
            this.queryHandler = new GraphMemQueryHandler(this);
        }
        return this.queryHandler;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new GraphMemBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        return this.store.find(tripleMatch.asTriple());
    }

    public boolean graphBaseContains(Triple triple) {
        return triple.isConcrete() ? this.store.contains(triple) : super.graphBaseContains(triple);
    }

    public void clear() {
        this.store.clear();
    }
}

