/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.event;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.event.OntEventHandler;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OntEventsVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OntEventManager
extends StatementListener {
    private static Object[][] s_rdfTypeInit = new Object[][]{{OntEventsVocab.classDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.CLASS();
        }
    }}, {OntEventsVocab.datarangeDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.DATARANGE();
        }
    }}, {OntEventsVocab.propertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.PROPERTY();
        }
    }}, {OntEventsVocab.objectPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.OBJECT_PROPERTY();
        }
    }}, {OntEventsVocab.datatypePropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.DATATYPE_PROPERTY();
        }
    }}, {OntEventsVocab.transitivePropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.TRANSITIVE_PROPERTY();
        }
    }}, {OntEventsVocab.symmetricPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.SYMMETRIC_PROPERTY();
        }
    }}, {OntEventsVocab.functionalPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.FUNCTIONAL_PROPERTY();
        }
    }}, {OntEventsVocab.inverseFunctionalPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.INVERSE_FUNCTIONAL_PROPERTY();
        }
    }}, {OntEventsVocab.annotationPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.ANNOTATION_PROPERTY();
        }
    }}, {OntEventsVocab.ontologyPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.ONTOLOGY_PROPERTY();
        }
    }}, {OntEventsVocab.restrictionDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.RESTRICTION();
        }
    }}, {OntEventsVocab.allDifferentDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.ALL_DIFFERENT();
        }
    }}, {OntEventsVocab.ontologyDeclaration, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.ONTOLOGY();
        }
    }}};
    private static Object[][] s_predicateInit = new Object[][]{{OntEventsVocab.intersectionOf, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.INTERSECTION_OF();
        }
    }}, {OntEventsVocab.equivalentClass, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.EQUIVALENT_CLASS();
        }
    }}, {OntEventsVocab.disjointWith, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.DISJOINT_WITH();
        }
    }}, {OntEventsVocab.equivalentProperty, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.EQUIVALENT_PROPERTY();
        }
    }}, {OntEventsVocab.sameAs, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.SAME_AS();
        }
    }}, {OntEventsVocab.differentFrom, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.DIFFERENT_FROM();
        }
    }}, {OntEventsVocab.distinctMembers, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.DISTINCT_MEMBERS();
        }
    }}, {OntEventsVocab.unionOf, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.UNION_OF();
        }
    }}, {OntEventsVocab.intersectionOf, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.INTERSECTION_OF();
        }
    }}, {OntEventsVocab.complementOf, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.COMPLEMENT_OF();
        }
    }}, {OntEventsVocab.oneOf, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.ONE_OF();
        }
    }}, {OntEventsVocab.onProperty, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.ON_PROPERTY();
        }
    }}, {OntEventsVocab.allValuesFrom, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.ALL_VALUES_FROM();
        }
    }}, {OntEventsVocab.hasValue, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.HAS_VALUE();
        }
    }}, {OntEventsVocab.someValuesFrom, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.SOME_VALUES_FROM();
        }
    }}, {OntEventsVocab.minCardinality, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.MIN_CARDINALITY();
        }
    }}, {OntEventsVocab.maxCardinality, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.MAX_CARDINALITY();
        }
    }}, {OntEventsVocab.cardinalityQ, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.CARDINALITY_Q();
        }
    }}, {OntEventsVocab.minCardinalityQ, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.MIN_CARDINALITY_Q();
        }
    }}, {OntEventsVocab.maxCardinalityQ, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.MAX_CARDINALITY_Q();
        }
    }}, {OntEventsVocab.cardinality, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.CARDINALITY();
        }
    }}, {OntEventsVocab.inverseOf, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.INVERSE_OF();
        }
    }}, {OntEventsVocab.imports, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.IMPORTS();
        }
    }}, {OntEventsVocab.versionInfo, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.VERSION_INFO();
        }
    }}, {OntEventsVocab.priorVersion, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.PRIOR_VERSION();
        }
    }}, {OntEventsVocab.backwardCompatibleWith, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.BACKWARD_COMPATIBLE_WITH();
        }
    }}, {OntEventsVocab.incompatibleWith, new ProfileAccessor(){

        public Resource get(Profile profile) {
            return profile.INCOMPATIBLE_WITH();
        }
    }}};
    private Map m_handlers = new HashMap();
    private Map m_rdfTypeToEventType = new HashMap();
    private Map m_predicateToEventType = new HashMap();
    private OntEventHandler m_defaultHandler = null;

    public OntEventManager(OntModel ontModel) {
        Profile profile = ontModel.getProfile();
        this.initialiseTable(this.m_rdfTypeToEventType, profile, s_rdfTypeInit);
        this.initialiseTable(this.m_predicateToEventType, profile, s_predicateInit);
    }

    public void addedStatement(Statement statement) {
        this.processStatement(statement, true);
    }

    public void removedStatement(Statement statement) {
        this.processStatement(statement, false);
    }

    public void raise(Resource resource, boolean bl, Model model, RDFNode rDFNode, RDFNode rDFNode2, RDFNode rDFNode3) {
        OntEventHandler ontEventHandler = this.getHandler(resource);
        if (ontEventHandler != null) {
            ontEventHandler.action(resource, bl, model, rDFNode, rDFNode2, rDFNode3);
        } else if (this.m_defaultHandler != null) {
            this.m_defaultHandler.action(resource, bl, model, rDFNode, rDFNode2, rDFNode3);
        }
    }

    public void addDefaultHandler(OntEventHandler ontEventHandler) {
        this.m_defaultHandler = ontEventHandler;
    }

    public void addHandler(Resource resource, OntEventHandler ontEventHandler) {
        this.m_handlers.put(resource, ontEventHandler);
    }

    public void addHandlers(Object[][] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Resource resource = (Resource)objectArray[n][0];
            OntEventHandler ontEventHandler = (OntEventHandler)objectArray[n][1];
            this.addHandler(resource, ontEventHandler);
        }
    }

    public OntEventHandler getHandler(Resource resource) {
        return (OntEventHandler)this.m_handlers.get(resource);
    }

    public OntEventHandler getDefaultHandler() {
        return this.m_defaultHandler;
    }

    public void removeHandler(Resource resource) {
        this.m_handlers.remove(resource);
    }

    public boolean hasHandler(Resource resource) {
        return this.m_handlers.containsKey(resource);
    }

    public Iterator listRegisteredEvents() {
        return this.m_handlers.keySet().iterator();
    }

    private void initialiseTable(Map map, Profile profile, Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Resource resource = (Resource)objectArray[i][0];
            Resource resource2 = ((ProfileAccessor)objectArray[i][1]).get(profile);
            if (resource2 == null) continue;
            map.put(resource2, resource);
        }
    }

    private void processStatement(Statement statement, boolean bl) {
        if (statement.getPredicate().equals(RDF.type)) {
            Resource resource = statement.getResource();
            Resource resource2 = (Resource)this.m_rdfTypeToEventType.get(resource);
            if (resource2 != null) {
                this.raise(resource2, bl, statement.getModel(), statement.getSubject(), null, null);
            } else {
                this.raise(OntEventsVocab.individualDeclaration, bl, statement.getModel(), statement.getSubject(), resource, null);
            }
        } else {
            Property property = statement.getPredicate();
            Resource resource = (Resource)this.m_predicateToEventType.get(property);
            if (resource != null) {
                this.raise(resource, bl, statement.getModel(), statement.getSubject(), statement.getObject(), null);
            } else {
                this.raise(OntEventsVocab.userData, bl, statement.getModel(), statement.getSubject(), property, statement.getObject());
            }
        }
    }

    private static interface ProfileAccessor {
        public Resource get(Profile var1);
    }
}

