/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class OntClassImpl
extends OntResourceImpl
implements OntClass {
    private static final String[] IGNORE_NAMESPACES = new String[]{"http://www.w3.org/2002/07/owl#", "http://www.daml.org/2001/03/daml+oil#", RDF.getURI(), RDFS.getURI(), "urn:x-hp-jena:rubrik/"};
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new OntClassImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to OntClass: it does not have rdf:type owl:Class or equivalent");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            Profile profile;
            Profile profile2 = profile = enhGraph instanceof OntModel ? ((OntModel)((Object)enhGraph)).getProfile() : null;
            return profile != null && profile.isSupported(node, enhGraph, class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
        }
    };
    protected BindingQueryPlan m_domainQuery;
    protected BindingQueryPlan m_restrictionPropQuery = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public OntClassImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
        Query query = new Query();
        query.addMatch(Query.X, this.getProfile().DOMAIN().asNode(), this.asNode());
        this.m_domainQuery = this.getModel().queryHandler().prepareBindings(query, new Node[]{Query.X});
        if (this.getProfile().ON_PROPERTY() != null) {
            query = new Query();
            query.addMatch(this.asNode(), this.getProfile().SUB_CLASS_OF().asNode(), Query.X);
            query.addMatch(Query.X, this.getProfile().ON_PROPERTY().asNode(), Query.Y);
            this.m_restrictionPropQuery = this.getModel().queryHandler().prepareBindings(query, new Node[]{Query.Y});
        }
    }

    public void setSuperClass(Resource resource) {
        this.setPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public void addSuperClass(Resource resource) {
        this.addPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public OntClass getSuperClass() {
        return (OntClass)this.objectAs(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class);
    }

    public ExtendedIterator listSuperClasses() {
        return this.listSuperClasses(false);
    }

    public ExtendedIterator listSuperClasses(boolean bl) {
        return UniqueExtendedIterator.create(this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class, this.getProfile().SUB_CLASS_OF(), bl, false).filterDrop(new OntResourceImpl.SingleEqualityFilter(this, this)));
    }

    public boolean hasSuperClass(Resource resource) {
        return this.hasSuperClass(resource, false);
    }

    public boolean hasSuperClass() {
        return this.getSuperClass() != null;
    }

    public boolean hasSuperClass(Resource resource, boolean bl) {
        OntModel ontModel;
        if (!bl) {
            return this.hasPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
        }
        InfGraph infGraph = null;
        if (this.getGraph() instanceof InfGraph) {
            infGraph = (InfGraph)((Object)this.getGraph());
        } else if (this.getGraph() instanceof OntModel && (ontModel = (OntModel)((Object)this.getGraph())).getGraph() instanceof InfGraph) {
            infGraph = (InfGraph)ontModel.getGraph();
        }
        if (infGraph != null && infGraph.getReasoner().supportsProperty(ReasonerVocabulary.directSubClassOf)) {
            return this.hasPropertyValue(ReasonerVocabulary.directSubClassOf, "direct sub-class", resource);
        }
        return this.hasSuperClassDirect(resource);
    }

    public void removeSuperClass(Resource resource) {
        this.removePropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public void setSubClass(Resource resource) {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        StmtIterator stmtIterator = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);
        while (stmtIterator.hasNext()) {
            stmtIterator.removeNext();
        }
        ((OntClass)resource.as(OntClass.class)).addSuperClass(this);
    }

    public void addSubClass(Resource resource) {
        ((OntClass)resource.as(OntClass.class)).addSuperClass(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OntClass getSubClass() {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        StmtIterator stmtIterator = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);
        try {
            if (stmtIterator.hasNext()) {
                OntClass ontClass = (OntClass)stmtIterator.nextStatement().getSubject().as(OntClass.class);
                return ontClass;
            }
            OntClass ontClass = null;
            return ontClass;
        }
        finally {
            stmtIterator.close();
        }
    }

    public ExtendedIterator listSubClasses() {
        return this.listSubClasses(false);
    }

    public ExtendedIterator listSubClasses(boolean bl) {
        return UniqueExtendedIterator.create(this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class, this.getProfile().SUB_CLASS_OF(), bl, true).filterDrop(new OntResourceImpl.SingleEqualityFilter(this, this)));
    }

    public boolean hasSubClass(Resource resource) {
        return this.hasSubClass(resource, false);
    }

    public boolean hasSubClass() {
        return this.getSubClass() != null;
    }

    public boolean hasSubClass(Resource resource, boolean bl) {
        if (this.getModel() instanceof OntModel && (resource.getModel() == null || !(resource.getModel() instanceof OntModel))) {
            resource = (Resource)resource.inModel(this.getModel());
        }
        return ((OntClass)resource.as(OntClass.class)).hasSuperClass(this, bl);
    }

    public void removeSubClass(Resource resource) {
        ((OntClass)resource.as(OntClass.class)).removeSuperClass(this);
    }

    public void setEquivalentClass(Resource resource) {
        this.setPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void addEquivalentClass(Resource resource) {
        this.addPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public OntClass getEquivalentClass() {
        return (OntClass)this.objectAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", OntClass.class);
    }

    public ExtendedIterator listEquivalentClasses() {
        return UniqueExtendedIterator.create(this.listAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", OntClass.class));
    }

    public boolean hasEquivalentClass(Resource resource) {
        return this.hasPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void removeEquivalentClass(Resource resource) {
        this.removePropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void setDisjointWith(Resource resource) {
        this.setPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public void addDisjointWith(Resource resource) {
        this.addPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public OntClass getDisjointWith() {
        return (OntClass)this.objectAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", OntClass.class);
    }

    public ExtendedIterator listDisjointWith() {
        return UniqueExtendedIterator.create(this.listAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", OntClass.class));
    }

    public boolean isDisjointWith(Resource resource) {
        return this.hasPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public void removeDisjointWith(Resource resource) {
        this.removePropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public ExtendedIterator listDeclaredProperties() {
        return this.listDeclaredProperties(false);
    }

    public ExtendedIterator listDeclaredProperties(boolean bl) {
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        Object object = this.listAllProperties();
        while (object.hasNext()) {
            hashSet.add(((Statement)object.next()).getSubject().as(class$com$hp$hpl$jena$rdf$model$Property == null ? OntClassImpl.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property));
        }
        object = new ArrayList();
        object.addAll(hashSet);
        for (int i = object.size() - 1; i >= 0; --i) {
            Property property = (Property)object.get(i);
            if (this.hasDeclaredProperty(property, bl)) continue;
            object.remove(i);
        }
        return WrappedIterator.create(object.iterator()).mapWith(new OntResourceImpl.AsMapper(OntProperty.class));
    }

    public boolean hasDeclaredProperty(Property property, boolean bl) {
        return this.testDomain(property, bl);
    }

    public ExtendedIterator listInstances() {
        return UniqueExtendedIterator.create(this.getModel().listStatements(null, RDF.type, this).mapWith(new OntResourceImpl.SubjectAsMapper(Individual.class)));
    }

    public Individual createIndividual() {
        return ((OntModel)this.getModel()).createIndividual(this);
    }

    public Individual createIndividual(String string) {
        return ((OntModel)this.getModel()).createIndividual(string, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHierarchyRoot() {
        if (this.equals(this.getProfile().NOTHING())) {
            return false;
        }
        ExtendedIterator extendedIterator = null;
        try {
            extendedIterator = this.listSuperClasses(true);
            while (extendedIterator.hasNext()) {
                Resource resource = (Resource)extendedIterator.next();
                if (((Object)resource).equals(this.getProfile().THING()) || ((Object)resource).equals(RDFS.Resource) || ((Object)resource).equals(this)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            extendedIterator.close();
        }
        return true;
    }

    public EnumeratedClass asEnumeratedClass() {
        return (EnumeratedClass)this.as(EnumeratedClass.class);
    }

    public UnionClass asUnionClass() {
        return (UnionClass)this.as(UnionClass.class);
    }

    public IntersectionClass asIntersectionClass() {
        return (IntersectionClass)this.as(IntersectionClass.class);
    }

    public ComplementClass asComplementClass() {
        return (ComplementClass)this.as(ComplementClass.class);
    }

    public Restriction asRestriction() {
        return (Restriction)this.as(Restriction.class);
    }

    public boolean isEnumeratedClass() {
        this.checkProfile(this.getProfile().ONE_OF(), "ONE_OF");
        return this.hasProperty(this.getProfile().ONE_OF());
    }

    public boolean isUnionClass() {
        this.checkProfile(this.getProfile().UNION_OF(), "UNION_OF");
        return this.hasProperty(this.getProfile().UNION_OF());
    }

    public boolean isIntersectionClass() {
        this.checkProfile(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return this.hasProperty(this.getProfile().INTERSECTION_OF());
    }

    public boolean isComplementClass() {
        this.checkProfile(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return this.hasProperty(this.getProfile().COMPLEMENT_OF());
    }

    public boolean isRestriction() {
        this.checkProfile(this.getProfile().RESTRICTION(), "RESTRICTION");
        return this.hasProperty(this.getProfile().ON_PROPERTY()) || this.hasProperty(RDF.type, this.getProfile().RESTRICTION());
    }

    public EnumeratedClass convertToEnumeratedClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", rDFList);
        return (EnumeratedClass)this.as(EnumeratedClass.class);
    }

    public IntersectionClass convertToIntersectionClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF", rDFList);
        return (IntersectionClass)this.as(IntersectionClass.class);
    }

    public UnionClass convertToUnionClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().UNION_OF(), "UNION_OF", rDFList);
        return (UnionClass)this.as(UnionClass.class);
    }

    public ComplementClass convertToComplementClass(Resource resource) {
        this.setPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", resource);
        return (ComplementClass)this.as(ComplementClass.class);
    }

    public Restriction convertToRestriction(Property property) {
        if (!this.hasRDFType(this.getProfile().RESTRICTION(), "RESTRICTION", false)) {
            this.setRDFType(this.getProfile().RESTRICTION());
        }
        this.setPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", property);
        return (Restriction)this.as(Restriction.class);
    }

    private void collectProperty(Property property, Set set, OntModel ontModel) {
        set.add(ontModel.getProperty(property.getURI()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasSuperClassDirect(Resource resource) {
        ExtendedIterator extendedIterator = this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "subClassOf", OntClass.class, this.getProfile().SUB_CLASS_OF(), true, false);
        try {
            while (extendedIterator.hasNext()) {
                if (!((Object)resource).equals(extendedIterator.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            extendedIterator.close();
        }
        return false;
    }

    protected boolean testDomain(Property property, boolean bl) {
        int n;
        String string = property.getNameSpace();
        for (n = 0; n < IGNORE_NAMESPACES.length; ++n) {
            if (!string.equals(IGNORE_NAMESPACES[n])) continue;
            return false;
        }
        n = 1;
        boolean bl2 = false;
        StmtIterator stmtIterator = this.getModel().listStatements((Resource)property, this.getProfile().DOMAIN(), (RDFNode)null);
        while (stmtIterator.hasNext()) {
            Resource resource = stmtIterator.nextStatement().getResource();
            if (((Object)resource).equals(this.getProfile().THING()) || ((Object)resource).equals(RDFS.Resource)) continue;
            n = 0;
            if (((Object)resource).equals(this)) {
                bl2 = true;
                continue;
            }
            if (this.canProveSuperClass(resource)) continue;
            return false;
        }
        if (bl) {
            return bl2 || n != 0 && this.isHierarchyRoot();
        }
        return true;
    }

    protected ExtendedIterator listAllProperties() {
        Model model;
        OntModel ontModel = (OntModel)this.getModel();
        Profile profile = ontModel.getProfile();
        ExtendedIterator extendedIterator = ontModel.listStatements(null, RDF.type, this.getProfile().PROPERTY());
        if (ontModel.getReasoner() != null && ((model = ontModel.getReasoner().getReasonerCapabilities()).contains(null, ReasonerVocabulary.supportsP, OWL.ObjectProperty) || model.contains(null, ReasonerVocabulary.supportsP, DAML_OIL.ObjectProperty))) {
            return extendedIterator;
        }
        if (profile.OBJECT_PROPERTY() != null) {
            extendedIterator = extendedIterator.andThen(ontModel.listStatements(null, RDF.type, profile.OBJECT_PROPERTY()));
        }
        if (profile.DATATYPE_PROPERTY() != null) {
            extendedIterator = extendedIterator.andThen(ontModel.listStatements(null, RDF.type, profile.DATATYPE_PROPERTY()));
        }
        if (profile.FUNCTIONAL_PROPERTY() != null) {
            extendedIterator = extendedIterator.andThen(ontModel.listStatements(null, RDF.type, profile.FUNCTIONAL_PROPERTY()));
        }
        if (profile.INVERSE_FUNCTIONAL_PROPERTY() != null) {
            extendedIterator = extendedIterator.andThen(ontModel.listStatements(null, RDF.type, profile.INVERSE_FUNCTIONAL_PROPERTY()));
        }
        if (profile.SYMMETRIC_PROPERTY() != null) {
            extendedIterator = extendedIterator.andThen(ontModel.listStatements(null, RDF.type, profile.SYMMETRIC_PROPERTY()));
        }
        if (profile.TRANSITIVE_PROPERTY() != null) {
            extendedIterator = extendedIterator.andThen(ontModel.listStatements(null, RDF.type, profile.TRANSITIVE_PROPERTY()));
        }
        if (profile.ANNOTATION_PROPERTY() != null) {
            extendedIterator = extendedIterator.andThen(ontModel.listStatements(null, RDF.type, profile.ANNOTATION_PROPERTY()));
        }
        return extendedIterator;
    }

    protected boolean canProveSuperClass(Resource resource) {
        OntModel ontModel = (OntModel)this.getModel();
        if (ontModel.getReasoner() != null && ontModel.getReasoner().getReasonerCapabilities().contains(null, ReasonerVocabulary.supportsP, RDFS.subClassOf)) {
            return this.hasSuperClass(resource);
        }
        HashSet<OntClass> hashSet = new HashSet<OntClass>();
        ArrayList<OntClassImpl> arrayList = new ArrayList<OntClassImpl>();
        arrayList.add(this);
        while (!arrayList.isEmpty()) {
            OntClass ontClass = (OntClass)arrayList.remove(0);
            if (hashSet.contains(ontClass)) continue;
            hashSet.add(ontClass);
            if (ontClass.equals(resource)) {
                return true;
            }
            ExtendedIterator extendedIterator = ontClass.listSuperClasses();
            while (extendedIterator.hasNext()) {
                arrayList.add((OntClassImpl)extendedIterator.next());
            }
        }
        return false;
    }
}

