/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGWrappedException;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;

public class TestBugReports
extends TestCase {
    public static String NS = "http://example.org/test#";
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;

    public TestBugReports(String string) {
        super(string);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void test_dn_0() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM_RULES_INF, null);
        ontModel.read("file:doc/inference/data/owlDemoSchema.xml", null);
        int n = 0;
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
            ++n;
        }
        TestBugReports.assertEquals((String)"Expecting 6 individuals", (int)6, (int)n);
    }

    public void test_dn_01() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM_RULE_INF, null);
        ontModel.read("file:testing/ontology/bugs/test_hk_07B.owl");
        OntProperty ontProperty = ontModel.getOntProperty("file:testing/ontology/bugs/test_hk_07B.owl#PropB");
        int n = 0;
        Object object = ontProperty.listDomain();
        while (object.hasNext()) {
            ++n;
            object.next();
        }
        TestBugReports.assertEquals((int)3, (int)n);
        object = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM_RULE_INF, null);
        object.read("file:testing/ontology/bugs/test_hk_07B.owl");
        OntProperty ontProperty2 = object.getOntProperty("file:testing/ontology/bugs/test_hk_07B.owl#PropB");
        n = 0;
        ExtendedIterator extendedIterator = ontProperty2.listDomain();
        while (extendedIterator.hasNext()) {
            ++n;
            extendedIterator.next();
        }
        TestBugReports.assertEquals((int)3, (int)n);
    }

    public void test_dn_02() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read("file:testing/ontology/testImport3/a.owl");
        TestBugReports.assertEquals((String)"Graph count..", (int)2, (int)ontModel.getSubGraphs().size());
        ExtendedIterator extendedIterator = ontModel.listImportedModels();
        while (extendedIterator.hasNext()) {
            ontModel.removeSubModel((Model)extendedIterator.next());
        }
        TestBugReports.assertEquals((String)"Graph count..", (int)0, (int)ontModel.getSubGraphs().size());
    }

    public void test_mra_01() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null, null);
        String string = "http://somewhere/myDictionaries/1.0#";
        String string2 = "http://www.daml.org/2001/03/daml+oil#";
        ontModel.setNsPrefix("DAML", string2);
        String string3 = string + "C1";
        OntClass ontClass = ontModel.createClass(string3);
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty(string + "P1");
        datatypeProperty.setDomain(ontClass);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ontModel.write(byteArrayOutputStream, "RDF/XML-ABBREV", string);
    }

    public void test_hk_01() {
        String string = "http://jena.hpl.hp.com/test#";
        String string2 = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">  <owl:Ontology rdf:about=\"\">    <owl:imports rdf:resource=\"http://www.w3.org/2002/07/owl\" />  </owl:Ontology></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        ontModel.read(new ByteArrayInputStream(string2.getBytes()), string);
        Resource resource = ontModel.getResource(OWL.Class.getURI());
        OntClass ontClass = (OntClass)resource.as(OntClass.class);
        TestBugReports.assertNotNull((String)"OntClass c should not be null", (Object)ontClass);
    }

    public void test_hk_02() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.createAllDifferent();
        TestBugReports.assertTrue((boolean)ontModel.listAllDifferent().hasNext());
        AllDifferent allDifferent = (AllDifferent)ontModel.listAllDifferent().next();
        TestBugReports.assertFalse((boolean)allDifferent.listDistinctMembers().hasNext());
    }

    public void test_hk_03() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.aldi.de#property");
        ontModel.createMinCardinalityRestriction(null, objectProperty, 42);
    }

    public void test_hk_04() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.getDocumentManager().addAltEntry("http://jena.hpl.hp.com/testing/ontology/relativenames", "file:testing/ontology/relativenames.rdf");
        ontModel.read("http://jena.hpl.hp.com/testing/ontology/relativenames");
        TestBugReports.assertTrue((String)"#A should be a class", (boolean)ontModel.getResource("http://jena.hpl.hp.com/testing/ontology/relativenames#A").canAs(OntClass.class));
        TestBugReports.assertFalse((String)"file: #A should not be a class", (boolean)ontModel.getResource("file:testing/ontology/relativenames.rdf#A").canAs(OntClass.class));
    }

    public void test_hk_05() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        String string = "http://foo.bar/fu#";
        OntClass ontClass = ontModel.createClass(string + "A");
        OntClass ontClass2 = ontModel.createClass(string + "B");
        int n = this.getStatementCount(ontModel);
        RDFList rDFList = ontModel.createList(new RDFNode[]{ontClass, ontClass2});
        IntersectionClass intersectionClass = ontModel.createIntersectionClass(null, rDFList);
        intersectionClass.remove();
        TestBugReports.assertEquals((String)"Before and after statement counts are different", (int)n, (int)this.getStatementCount(ontModel));
    }

    public void test_hk_06() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read("file:testing/ontology/bugs/test_hk_06/a.owl");
        String string = "http://jena.hpl.hp.com/2003/03/testont/a#";
        String string2 = "http://jena.hpl.hp.com/2003/03/testont/b#";
        OntClass ontClass = ontModel.getOntClass(string + "A");
        TestBugReports.assertTrue((String)"class A should be in the base model", (boolean)ontModel.isInBaseModel(ontClass));
        OntClass ontClass2 = ontModel.getOntClass(string2 + "B");
        TestBugReports.assertFalse((String)"class B should not be in the base model", (boolean)ontModel.isInBaseModel(ontClass2));
        TestBugReports.assertTrue((String)"A rdf:type owl:Class should be in the base model", (boolean)ontModel.isInBaseModel(ontModel.createStatement((Resource)ontClass, RDF.type, OWL.Class)));
        TestBugReports.assertFalse((String)"B rdf:type owl:Class should not be in the base model", (boolean)ontModel.isInBaseModel(ontModel.createStatement((Resource)ontClass2, RDF.type, OWL.Class)));
    }

    public void test_hk_importCache() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        ontModelSpec.setReasoner(null);
        OntDocumentManager ontDocumentManager = OntDocumentManager.getInstance();
        ontDocumentManager.reset();
        ontDocumentManager.setCacheModels(false);
        ontDocumentManager.addAltEntry("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "file:testing/ontology/bugs/test_hk_import/Import-normalizerBug.owl");
        ontDocumentManager.addAltEntry("http://protege.stanford.edu/plugins/owl/testdata/normalizerBug.owl", "file:testing/ontology/bugs/test_hk_import/normalizerBug.owl");
        ontModelSpec.setDocumentManager(ontDocumentManager);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "RDF/XML-ABBREV");
        Graph graph = (Graph)ontModel.getSubGraphs().iterator().next();
        int n = this.getTripleCount(graph);
        OntClass ontClass = ontModel.getOntClass("http://protege.stanford.edu/plugins/owl/testdata/normalizerBug.owl#SuperClass");
        graph.add(new Triple(ontClass.getNode(), RDF.type.getNode(), OWL.DeprecatedClass.getNode()));
        TestBugReports.assertEquals((int)(n + 1), (int)this.getTripleCount(graph));
        SimpleGraphMaker simpleGraphMaker = (SimpleGraphMaker)((ModelMakerImpl)ontModelSpec.getImportModelMaker()).getGraphMaker();
        ArrayList arrayList = new ArrayList();
        Object object = simpleGraphMaker.listGraphs();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            simpleGraphMaker.removeGraph((String)object.next());
        }
        ontDocumentManager.clearCache();
        object = ModelFactory.createOntologyModel(ontModelSpec, null);
        object.read("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "RDF/XML-ABBREV");
        Graph graph2 = (Graph)object.getSubGraphs().iterator().next();
        TestBugReports.assertFalse((object == ontModel ? 1 : 0) != 0);
        TestBugReports.assertFalse((graph2 == graph ? 1 : 0) != 0);
        int n2 = this.getTripleCount(graph2);
        TestBugReports.assertEquals((int)n, (int)n2);
    }

    private int getTripleCount(Graph graph) {
        int n = 0;
        ExtendedIterator extendedIterator = graph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
            ++n;
        }
        return n;
    }

    public void test_fc_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ObjectProperty objectProperty = ontModel.createObjectProperty(NS + "p");
        Restriction restriction = ontModel.createRestriction(objectProperty);
        HasValueRestriction hasValueRestriction = restriction.convertToHasValueRestriction(ontModel.createLiteral(1L));
        RDFNode rDFNode = hasValueRestriction.getHasValue();
        TestBugReports.assertFalse((String)"Should not be able to convert literal to individual", (boolean)rDFNode.canAs(Individual.class));
    }

    public void test_ck_01() {
        GraphMem graphMem = new GraphMem(){
            TransactionHandler m_t;
            {
                this.m_t = new MockTransactionHandler();
            }

            public TransactionHandler getTransactionHandler() {
                return this.m_t;
            }
        };
        Model model = ModelFactory.createModelForGraph(graphMem);
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM, model);
        TestBugReports.assertFalse((String)"Transaction not started yet", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.begin();
        TestBugReports.assertTrue((String)"Transaction started", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.abort();
        TestBugReports.assertFalse((String)"Transaction aborted", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        TestBugReports.assertTrue((String)"Transaction aborted", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_aborted);
        ontModel.begin();
        TestBugReports.assertTrue((String)"Transaction started", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        ontModel.commit();
        TestBugReports.assertFalse((String)"Transaction committed", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_inTransaction);
        TestBugReports.assertTrue((String)"Transaction committed", (boolean)((MockTransactionHandler)ontModel.getGraph().getTransactionHandler()).m_committed);
    }

    public void test_ck_02() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ObjectProperty objectProperty = ontModel.createObjectProperty("p");
        OntClass ontClass = ontModel.createClass("A");
        OntModel ontModel2 = ModelFactory.createOntologyModel();
        Individual individual = ontModel2.createIndividual("uri1", ontClass);
        Individual individual2 = ontModel2.createIndividual("uri2", ontClass);
        ontModel2.createStatement((Resource)individual, (Property)objectProperty, individual2);
    }

    public void test_ck_03() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null);
        OntModel ontModel2 = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF, null);
        Individual individual = ontModel.createIndividual("http://mytest#i1", ontModel.getProfile().CLASS());
        OntProperty ontProperty = ontModel.createOntProperty("http://mytest#");
        Individual individual2 = ontModel.createIndividual("http://mytest#i2", ontModel.getProfile().CLASS());
        OntProperty ontProperty2 = ontModel.createOntProperty("http://mytest#prob");
        Statement statement = ontModel.createStatement((Resource)individual, (Property)ontProperty, individual2);
        ontModel.add(statement);
        statement.createReifiedStatement().addProperty((Property)ontProperty2, 0.9);
        TestBugReports.assertTrue((String)"st should be reified", (boolean)statement.isReified());
        Statement statement2 = ontModel2.createStatement((Resource)individual, (Property)ontProperty, individual2);
        ontModel2.add(statement2);
        statement2.createReifiedStatement().addProperty((Property)ontProperty2, 0.3);
        TestBugReports.assertTrue((String)"st2 should be reified", (boolean)statement2.isReified());
        individual.addProperty((Property)ontProperty2, 0.3);
        individual.removeAll(ontProperty2).addProperty((Property)ontProperty2, 0.3);
        Individual individual3 = ontModel2.createIndividual("http://mytest#i1", ontModel.getProfile().CLASS());
        individual.addProperty((Property)ontProperty2, 0.3);
        individual.removeAll(ontProperty2);
        individual3.addProperty((Property)ontProperty2, 0.3);
        individual3.removeAll(ontProperty2);
    }

    public void test_sjooseng_01() {
        String string = "<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#'    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' >    <daml:Class rdf:about='http://localhost:8080/kc2c#C1'>        <daml:subClassOf>            <daml:Restriction>                <daml:onProperty rdf:resource='http://localhost:8080/kc2c#p1'/>                <daml:hasClass>                    <daml:Class>                        <daml:oneOf rdf:parseType=\"daml:collection\">                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i1'/>                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i2'/>                        </daml:oneOf>                    </daml:Class>                </daml:hasClass>            </daml:Restriction>        </daml:subClassOf>    </daml:Class>    <daml:ObjectProperty rdf:about='http://localhost:8080/kc2c#p1'>        <rdfs:label>p1</rdfs:label>    </daml:ObjectProperty></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel("http://www.daml.org/2001/03/daml+oil#");
        ontModel.read(new ByteArrayInputStream(string.getBytes()), "http://localhost:8080/kc2c");
        OntClass ontClass = ontModel.getOntClass("http://localhost:8080/kc2c#C1");
        boolean bl = false;
        ExtendedIterator extendedIterator = ontClass.listSuperClasses(false);
        while (extendedIterator.hasNext()) {
            SomeValuesFromRestriction someValuesFromRestriction;
            OntClass ontClass2;
            Restriction restriction;
            OntClass ontClass3 = (OntClass)extendedIterator.next();
            if (!ontClass3.isRestriction() || !(restriction = ontClass3.asRestriction()).isSomeValuesFromRestriction() || !(ontClass2 = (OntClass)(someValuesFromRestriction = restriction.asSomeValuesFromRestriction()).getSomeValuesFrom()).isEnumeratedClass()) continue;
            EnumeratedClass enumeratedClass = ontClass2.asEnumeratedClass();
            TestBugReports.assertEquals((String)"Enumeration size should be 2", (int)2, (int)enumeratedClass.getOneOf().size());
            bl = true;
        }
        TestBugReports.assertTrue((boolean)bl);
    }

    public void test_afs_01() {
        String string = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <owl:Class rdf:about='http://example.org/foo#A'>   </owl:Class></rdf:RDF>";
        String string2 = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <rdf:Description rdf:about='http://example.org/foo#x'>    <rdf:type rdf:resource='http://example.org/foo#A' />   </rdf:Description></rdf:RDF>";
        Model model = ModelFactory.createDefaultModel();
        model.read(new ByteArrayInputStream(string.getBytes()), "http://example.org/foo");
        Model model2 = ModelFactory.createDefaultModel();
        model2.read(new ByteArrayInputStream(string2.getBytes()), "http://example.org/foo");
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        reasoner = reasoner.bindSchema(model);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM_RULE_INF);
        ontModelSpec.setReasoner(reasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, model2);
        ArrayList arrayList = new ArrayList();
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            arrayList.add(extendedIterator.next());
        }
        TestBugReports.assertTrue((String)"x should be an individual", (boolean)arrayList.contains(ontModel.getResource("http://example.org/foo#x")));
    }

    public void test_to_01() {
        String string = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:daml='http://www.daml.org/2001/03/daml+oil#'>  <daml:Class rdf:about='http://example.org/foo#A'>    <daml:intersectionOf rdf:parseType=\"daml:collection\">       <daml:Class rdf:ID=\"B\" />       <daml:Class rdf:ID=\"C\" />    </daml:intersectionOf>  </daml:Class></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM, null);
        ontModel.read(new ByteArrayInputStream(string.getBytes()), "http://example.org/foo");
        OntClass ontClass = ontModel.getOntClass("http://example.org/foo#A");
        TestBugReports.assertNotNull((Object)ontClass);
        IntersectionClass intersectionClass = ontClass.asIntersectionClass();
        TestBugReports.assertNotNull((Object)intersectionClass);
        RDFList rDFList = intersectionClass.getOperands();
        TestBugReports.assertNotNull((Object)rDFList);
        TestBugReports.assertEquals((int)2, (int)rDFList.size());
        TestBugReports.assertTrue((boolean)rDFList.contains(ontModel.getOntClass("http://example.org/foo#B")));
        TestBugReports.assertTrue((boolean)rDFList.contains(ontModel.getOntClass("http://example.org/foo#C")));
    }

    public void test_tl_01() {
        Resource resource;
        String string = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">   <owl:SymmetricProperty rdf:about='http://example.org/foo#p1'>   </owl:SymmetricProperty>   <owl:TransitiveProperty rdf:about='http://example.org/foo#p2'>   </owl:TransitiveProperty>   <owl:InverseFunctionalProperty rdf:about='http://example.org/foo#p3'>   </owl:InverseFunctionalProperty></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        ontModel.read(new ByteArrayInputStream(string.getBytes()), "http://example.org/foo");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ExtendedIterator extendedIterator = ontModel.listOntProperties();
        while (extendedIterator.hasNext()) {
            resource = (Resource)extendedIterator.next();
            bl = bl || resource.getURI().equals("http://example.org/foo#p1");
            bl2 = bl2 || resource.getURI().equals("http://example.org/foo#p2");
            bl3 = bl3 || resource.getURI().equals("http://example.org/foo#p3");
        }
        TestBugReports.assertTrue((String)"p1 not listed", (boolean)bl);
        TestBugReports.assertTrue((String)"p2 not listed", (boolean)bl2);
        TestBugReports.assertTrue((String)"p3 not listed", (boolean)bl3);
        bl = false;
        bl2 = false;
        bl3 = false;
        extendedIterator = ontModel.listObjectProperties();
        while (extendedIterator.hasNext()) {
            resource = (Resource)extendedIterator.next();
            bl = bl || resource.getURI().equals("http://example.org/foo#p1");
            bl2 = bl2 || resource.getURI().equals("http://example.org/foo#p2");
            bl3 = bl3 || resource.getURI().equals("http://example.org/foo#p3");
        }
        TestBugReports.assertTrue((String)"p1 not listed", (boolean)bl);
        TestBugReports.assertTrue((String)"p2 not listed", (boolean)bl2);
        TestBugReports.assertTrue((String)"p3 not listed", (boolean)bl3);
    }

    public void test_der_01() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM_TRANS_INF, null);
        Resource resource = ontModel.createResource("http://example.org#A");
        Resource resource2 = ontModel.createResource("http://example.org#B");
        OntClassImpl ontClassImpl = new OntClassImpl(resource.getNode(), (EnhGraph)((Object)ontModel)){

            protected boolean hasSuperClassDirect(Resource resource) {
                throw new RuntimeException("did not find direct reasoner");
            }
        };
        ontClassImpl.hasSuperClass(resource2, true);
    }

    public void test_if_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.getDocumentManager().addAltEntry("http://www.w3.org/2001/sw/WebOnt/guide-src/wine", "file:testing/ontology/bugs/oldwine.owl");
        ontModel.getDocumentManager().addAltEntry("http://www.w3.org/2001/sw/WebOnt/guide-src/food", "file:testing/ontology/bugs/oldfood.owl");
        ontModel.getDocumentManager().setProcessImports(false);
        ontModel.read("http://www.w3.org/2001/sw/WebOnt/guide-src/wine");
        ontModel.getDocumentManager().setProcessImports(true);
        ontModel.getDocumentManager().loadImport(ontModel, "http://www.w3.org/2001/sw/WebOnt/guide-src/food");
        OntClass ontClass = ontModel.getOntClass("http://www.w3.org/2001/sw/WebOnt/guide-src/wine#Wine");
        int n = 0;
        int n2 = 0;
        int n4 = 0;
        ExtendedIterator extendedIterator = ontClass.listSuperClasses(true);
        while (extendedIterator.hasNext()) {
            OntClass ontClass2 = (OntClass)extendedIterator.next();
            if (!ontClass2.isAnon()) {
                ++n;
                continue;
            }
            if (ontClass2.canAs(class$com$hp$hpl$jena$ontology$Restriction == null ? TestBugReports.class$("com.hp.hpl.jena.ontology.Restriction") : class$com$hp$hpl$jena$ontology$Restriction)) {
                ontClass2.asRestriction();
                ++n2;
                continue;
            }
            ++n4;
        }
        TestBugReports.assertEquals((String)"Should be two named super classes ", (int)2, (int)n);
        TestBugReports.assertEquals((String)"Should be nine named super classes ", (int)9, (int)n2);
        TestBugReports.assertEquals((String)"Should be no named super classes ", (int)0, (int)n4);
    }

    public void test_lt_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty(NS + "p");
        OntClass ontClass = ontModel.createClass(NS + "A");
        Individual individual = ontModel.createIndividual(NS + "i", ontClass);
        individual.addProperty((Property)datatypeProperty, "testData");
        int n = 0;
        NodeIterator nodeIterator = individual.listPropertyValues(datatypeProperty);
        while (nodeIterator.hasNext()) {
            nodeIterator.next();
            ++n;
        }
        TestBugReports.assertEquals((String)"i should have one property", (int)1, (int)n);
    }

    public void test_dk_01() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/bugs/test_dk_01.xml");
        String string = "http://localhost:8080/Repository/QueryAgent/UserOntology/qgen-example-1#";
        String[] stringArray = new String[]{string + "C1", string + "C3", string + "C2"};
        for (int i = 0; i < stringArray.length; ++i) {
            OntClass ontClass = ontModel.getOntClass(stringArray[i]);
            ExtendedIterator extendedIterator = ontClass.listDeclaredProperties();
            while (extendedIterator.hasNext()) {
                extendedIterator.next();
            }
        }
    }

    public void test_ppds_01() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        DAMLClass dAMLClass = dAMLModel.createDAMLClass(NS + "C");
        DAMLInstance dAMLInstance = dAMLModel.createDAMLInstance(dAMLClass, NS + "x");
        DAMLProperty dAMLProperty = dAMLModel.createDAMLProperty(NS + "p");
        dAMLInstance.addProperty((Property)dAMLProperty, "(s (s 0))");
        PropertyAccessor propertyAccessor = dAMLInstance.accessProperty(dAMLProperty);
        TestBugReports.assertNull((String)"Property accessor value should be null", (Object)propertyAccessor.getDAMLValue());
    }

    public void test_anon_0() {
        String string = "http://example.org/foo#";
        String string2 = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:ex='http://example.org/foo#'    xmlns:owl='http://www.w3.org/2002/07/owl#'>   <owl:ObjectProperty rdf:about='http://example.org/foo#p' />   <owl:Class rdf:about='http://example.org/foo#A' />   <ex:A rdf:about='http://example.org/foo#x' />   <owl:Class rdf:about='http://example.org/foo#B'>     <owl:equivalentClass>      <owl:Restriction>        <owl:onProperty rdf:resource='http://example.org/foo#p' />        <owl:hasValue rdf:resource='http://example.org/foo#x' />      </owl:Restriction>     </owl:equivalentClass>   </owl:Class></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read(new ByteArrayInputStream(string2.getBytes()), "http://example.org/foo");
        OntClass ontClass = ontModel.getOntClass(string + "B");
        Restriction restriction = ontClass.getEquivalentClass().asRestriction();
        HasValueRestriction hasValueRestriction = restriction.asHasValueRestriction();
        RDFNode rDFNode = hasValueRestriction.getHasValue();
        TestBugReports.assertTrue((String)"Should be an individual", (boolean)(rDFNode instanceof Individual));
    }

    public void test_zj_0() {
        String string = "file:/C:/orel/orel0_5.owl#";
        String string2 = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:ex='http://example.org/foo#'    xmlns:owl='http://www.w3.org/2002/07/owl#'      xmlns:orel='file:/C:/orel/orel0_5.owl#'      xml:base='file:/C:/orel/orel0_5.owl#'      xmlns='file:/C:/orel/orel0_5.owl#'> <owl:ObjectProperty rdf:ID='hasAgent' /> <owl:ObjectProperty rdf:ID='hasResource' /> <owl:Class rdf:ID='MyPlay'>    <rdfs:subClassOf>      <owl:Restriction>        <owl:onProperty rdf:resource='file:/C:/orel/orel0_5.owl#hasResource'/>        <owl:hasValue>          <orel:Resource rdf:ID='myResource'>            <orel:resourceURI>http://mp3.com/newcd/sample.mp3</orel:resourceURI>          </orel:Resource>        </owl:hasValue>      </owl:Restriction>    </rdfs:subClassOf>    <rdfs:subClassOf rdf:resource='http://www.w3.org/2002/07/owl#Thing'/>    <rdfs:subClassOf>      <owl:Restriction>        <owl:onProperty rdf:resource='file:/C:/orel/orel0_5.owl#hasAgent'/>        <owl:hasValue>          <orel:Agent rdf:ID='myAgent'>            <orel:agentPK>123456789</orel:agentPK>          </orel:Agent>        </owl:hasValue>      </owl:Restriction>    </rdfs:subClassOf>    <rdfs:subClassOf rdf:resource='file:/C:/orel/orel0_5.owl#Play'/>  </owl:Class></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        ontModel.read(new ByteArrayInputStream(string2.getBytes()), "file:/C:/orel/orel0_5.owl");
        OntClass ontClass = ontModel.getOntClass(string + "MyPlay");
        ExtendedIterator extendedIterator = ontClass.listDeclaredProperties();
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
        }
    }

    public void test_ej_01() {
        String string = "http://jena.hpl.hp.com/testing/ontology";
        String string2 = string + "#";
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        DAMLClass dAMLClass = dAMLModel.createDAMLClass(string2 + "A");
        DAMLClass dAMLClass2 = dAMLModel.createDAMLClass(string2 + "B");
        DAMLClass dAMLClass3 = dAMLModel.createDAMLClass(string2 + "C");
        DAMLList dAMLList = dAMLModel.createDAMLList(new RDFNode[]{dAMLClass, dAMLClass2, dAMLClass3});
        TestBugReports.assertTrue((boolean)dAMLList.isValid());
        Model model = dAMLModel.getBaseModel();
        RDFWriter rDFWriter = model.getWriter("RDF/XML-ABBREV");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    }

    public void test_hc_01() throws Exception {
        for (int i = 0; i < 5; ++i) {
            OntModel ontModel = ModelFactory.createOntologyModel();
            FileInputStream fileInputStream = new FileInputStream("testing/ontology/relativenames.rdf");
            ontModel.read(fileInputStream, "http://example.org/foo");
            fileInputStream.close();
            ontModel.close();
        }
    }

    public void test_sb_01() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF, null);
        OntResource ontResource = null;
        Resource resource = null;
        ontResource = ontModel.createOntResource(OntResource.class, resource, "http://www.somewhere.com/models#SomeResourceName");
        TestBugReports.assertNotNull((Object)ontResource);
    }

    public void test_der_02() {
        String string = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <owl:ObjectProperty rdf:ID='hasPublications'>    <rdfs:domain>      <owl:Class>        <owl:unionOf rdf:parseType='Collection'>          <owl:Class rdf:about='#Project'/>          <owl:Class rdf:about='#Task'/>        </owl:unionOf>      </owl:Class>    </rdfs:domain>    <rdfs:domain rdf:resource='#Dummy' />    <rdfs:range rdf:resource='#Publications'/>  </owl:ObjectProperty>  <owl:Class rdf:ID='Dummy'>  </owl:Class></rdf:RDF>";
        String string2 = "http://jena.hpl.hp.com/test#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read(new ByteArrayInputStream(string.getBytes()), string2);
        OntClass ontClass = ontModel.getOntClass(string2 + "Dummy");
    }

    public void test_der_03() {
        String string = "http://jena.hpl.hp.com/test#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass ontClass = ontModel.createClass(string + "A");
        OntClass ontClass2 = ontModel.createClass(string + "B");
        OntClass ontClass3 = ontModel.createClass(string + "C");
        ontClass.addSuperClass(ontClass2);
        ontClass.addSuperClass(ontClass3);
        ontClass2.addSuperClass(ontClass3);
        ontClass3.addSuperClass(ontClass2);
        TestUtil.assertIteratorValues(this, ontClass.listSuperClasses(true), new Object[]{ontClass2, ontClass3});
    }

    public void test_pd_01() {
        String string = "<?xml version='1.0'?><rdf:RDF    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl='http://www.w3.org/2002/07/owl#'    xml:base='http://iasi.cnr.it/leks/localSchema1#'    xmlns:test='http://iasi.cnr.it/test/test1#'    xmlns='http://iasi.cnr.it/test/test1#'>    <owl:Ontology rdf:about=''/>    <owl:Class rdf:ID='Hotel'/>    <owl:Class rdf:ID='Hotel5Stars'>        <rdfs:subClassOf>            <owl:Restriction>                <owl:onProperty rdf:resource='#hasCategory'/>                <owl:hasValue rdf:resource='#Category5'/>            </owl:Restriction>        </rdfs:subClassOf>    </owl:Class>    <owl:DatatypeProperty rdf:ID='hasCategory'>        <rdfs:range rdf:resource='http://www.w3.org/2001/XMLSchema#string'/>        <rdfs:domain rdf:resource='#Hotel'/>        <rdf:type rdf:resource='http://www.w3.org/2002/07/owl#FunctionalProperty'/>    </owl:DatatypeProperty>    <owl:Thing rdf:ID='Category5'/></rdf:RDF>";
        String string2 = "http://iasi.cnr.it/leks/localSchema1#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        ontModel.read(new ByteArrayInputStream(string.getBytes()), string2);
        ExtendedIterator extendedIterator = ontModel.listRestrictions();
        while (extendedIterator.hasNext()) {
            Restriction restriction = (Restriction)extendedIterator.next();
            if (!restriction.isHasValueRestriction()) continue;
            HasValueRestriction hasValueRestriction = restriction.asHasValueRestriction();
            String string3 = ((Object)hasValueRestriction.getHasValue()).toString();
        }
    }

    public void xxtest_oh_01() {
        String string = "http://www.idi.ntnu.no/~herje/ja/";
        Resource[] resourceArray = new Resource[]{ResourceFactory.createResource(string + "reiseliv.owl#Reiseliv"), ResourceFactory.createResource(string + "hotell.owl#Hotell"), ResourceFactory.createResource(string + "restaurant.owl#Restaurant"), ResourceFactory.createResource(string + "restaurant.owl#UteRestaurant"), ResourceFactory.createResource(string + "restaurant.owl#UteBadRestaurant"), ResourceFactory.createResource(string + "restaurant.owl#UteDoRestaurant"), ResourceFactory.createResource(string + "restaurant.owl#SkogRestaurant")};
        this.test_oh_01scan(OntModelSpec.OWL_MEM, "No inf", resourceArray);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MINI_RULE_INF, "Mini rule inf", resourceArray);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_RULE_INF, "Full rule inf", resourceArray);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MICRO_RULE_INF, "Micro rule inf", resourceArray);
    }

    private void test_oh_01scan(OntModelSpec ontModelSpec, String string, Resource[] resourceArray) {
        Resource resource;
        String string2 = "http://www.idi.ntnu.no/~herje/ja/reiseliv.owl#";
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/bugs/test_oh_01.owl");
        System.out.println(string);
        OntClass ontClass = ontModel.getOntClass(string2 + "Reiseliv");
        ArrayList<OntClass> arrayList = new ArrayList<OntClass>();
        HashSet<OntClass> hashSet = new HashSet<OntClass>();
        arrayList.add(ontClass);
        while (!arrayList.isEmpty()) {
            OntClass ontClass2 = (OntClass)arrayList.remove(0);
            hashSet.add(ontClass2);
            ExtendedIterator extendedIterator = ontClass2.listSubClasses(true);
            while (extendedIterator.hasNext()) {
                resource = (OntClass)extendedIterator.next();
                if (hashSet.contains(resource)) continue;
                arrayList.add((OntClass)resource);
            }
            System.out.println("  Seen class " + ontClass2);
        }
        int n = (1 << resourceArray.length) - 1;
        for (int i = 0; i < resourceArray.length; ++i) {
            if (hashSet.contains(resourceArray[i])) {
                n &= ~(1 << i);
                continue;
            }
            System.out.println("Expected but did not see " + resourceArray[i]);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            resource = (Resource)iterator.next();
            boolean bl = false;
            for (int i = 0; !bl && i < resourceArray.length; ++i) {
                bl = ((Object)resourceArray[i]).equals(resource);
            }
            if (bl) continue;
            System.out.println("Got unexpected result " + resource);
        }
        TestBugReports.assertEquals((String)"Some expected results were not seen", (int)0, (int)n);
    }

    public void test_sf_927641() {
        String string = "http://example.org/test#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass ontClass = ontModel.createClass(string + "C0");
        OntClass ontClass2 = ontModel.createClass(string + "C1");
        OntClass ontClass3 = ontModel.createClass(string + "C2");
        OntClass ontClass4 = ontModel.createClass(string + "C3");
        ontClass.addSubClass(ontClass2);
        ontClass2.addSubClass(ontClass3);
        ontClass3.addEquivalentClass(ontClass4);
        TestBugReports.assertFalse((String)"pass 1: c0 should not be a direct super of c2", (boolean)ontClass3.hasSuperClass(ontClass, true));
        TestBugReports.assertFalse((String)"pass 1: c3 should not be a direct super of c2", (boolean)ontClass3.hasSuperClass(ontClass4, true));
        TestBugReports.assertFalse((String)"pass 1: c2 should not be a direct super of c2", (boolean)ontClass3.hasSuperClass(ontClass3, true));
        TestBugReports.assertTrue((String)"pass 1: c1 should be a direct super of c2", (boolean)ontClass3.hasSuperClass(ontClass2, true));
        ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF);
        ontClass = ontModel.createClass(string + "C0");
        ontClass2 = ontModel.createClass(string + "C1");
        ontClass3 = ontModel.createClass(string + "C2");
        ontClass4 = ontModel.createClass(string + "C3");
        ontClass.addSubClass(ontClass2);
        ontClass2.addSubClass(ontClass3);
        ontClass3.addEquivalentClass(ontClass4);
        TestBugReports.assertFalse((String)"pass 2: c0 should not be a direct super of c2", (boolean)ontClass3.hasSuperClass(ontClass, true));
        TestBugReports.assertFalse((String)"pass 2: c3 should not be a direct super of c2", (boolean)ontClass3.hasSuperClass(ontClass4, true));
        TestBugReports.assertFalse((String)"pass 2: c2 should not be a direct super of c2", (boolean)ontClass3.hasSuperClass(ontClass3, true));
        TestBugReports.assertTrue((String)"pass 2: c1 should be a direct super of c2", (boolean)ontClass3.hasSuperClass(ontClass2, true));
    }

    public void test_sf_934528() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        Resource resource = (Resource)OWL.Thing.inModel(ontModel);
        OntClass ontClass = (OntClass)resource.as(OntClass.class);
        TestBugReports.assertNotNull((Object)ontClass);
        resource = (Resource)OWL.Nothing.inModel(ontModel);
        OntClass ontClass2 = (OntClass)resource.as(OntClass.class);
        TestBugReports.assertNotNull((Object)ontClass2);
    }

    public void test_sf_937810() throws IllegalAccessException {
        Field[] fieldArray = OntModelSpec.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!Modifier.isPublic(fieldArray[i].getModifiers()) || !Modifier.isStatic(fieldArray[i].getModifiers()) || !fieldArray[i].getType().equals(class$com$hp$hpl$jena$ontology$OntModelSpec == null ? TestBugReports.class$("com.hp.hpl.jena.ontology.OntModelSpec") : class$com$hp$hpl$jena$ontology$OntModelSpec)) continue;
            OntModelSpec ontModelSpec = (OntModelSpec)fieldArray[i].get(null);
            TestBugReports.assertNotNull((Object)ontModelSpec.getDescription());
        }
    }

    public void test_sf_940570() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass ontClass = ontModel.createClass(NS + "C");
        Resource resource = ontModel.createResource(NS + "a", ontClass);
        TestUtil.assertIteratorValues(this, ontModel.listIndividuals(), new Object[]{resource});
        OntModel ontModel2 = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF);
        OntClass ontClass2 = ontModel2.createClass(NS + "D");
        Resource resource2 = ontModel2.createResource(NS + "b", ontClass2);
        TestUtil.assertIteratorValues(this, ontModel2.listIndividuals(), new Object[]{resource2});
    }

    public void test_sf_940570_rdfs() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass ontClass = ontModel.createClass(NS + "C");
        Resource resource = ontModel.createResource(NS + "a", ontClass);
        TestUtil.assertIteratorValues(this, ontModel.listIndividuals(), new Object[]{resource});
    }

    public void test_sf_940570_daml() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RULE_INF);
        OntClass ontClass = ontModel.createClass(NS + "D");
        Resource resource = ontModel.createResource(NS + "b", ontClass);
        TestUtil.assertIteratorValues(this, ontModel.listIndividuals(), new Object[]{resource});
    }

    public void test_sf_945436() {
        String string = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <C rdf:ID='x'>    <rdfs:label xml:lang=''>a_label</rdfs:label>  </C>  <owl:Class rdf:ID='C'>  </owl:Class></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        ontModel.read(new StringReader(string), null);
        Individual individual = ontModel.getIndividual("http://jena.hpl.hp.com/test#x");
        TestBugReports.assertEquals((String)"Label on resource x", (String)"a_label", (String)individual.getLabel(null));
        TestBugReports.assertEquals((String)"Label on resource x", (String)"a_label", (String)individual.getLabel(""));
        TestBugReports.assertSame((String)"fr label on resource x", null, (Object)individual.getLabel("fr"));
    }

    public void test_sf_948995() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty(NS + "dp");
        datatypeProperty.addRDFType(OWL.InverseFunctionalProperty);
        boolean bl = false;
        try {
            datatypeProperty.as(InverseFunctionalProperty.class);
        }
        catch (ConversionException conversionException) {
            bl = true;
        }
        TestBugReports.assertTrue((String)"Should have been a conversion exception", (boolean)bl);
        ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        datatypeProperty = ontModel.createDatatypeProperty(NS + "dp");
        datatypeProperty.addRDFType(OWL.InverseFunctionalProperty);
        bl = false;
        try {
            datatypeProperty.as(InverseFunctionalProperty.class);
        }
        catch (ConversionException conversionException) {
            bl = true;
        }
        TestBugReports.assertFalse((String)"Should not have been a conversion exception", (boolean)bl);
    }

    public void test_sf_969475() {
        String string = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <owl:ObjectProperty rdf:ID='p0'>    <owl:inverseOf>      <owl:ObjectProperty rdf:ID='q0' />    </owl:inverseOf>  </owl:ObjectProperty>  <owl:ObjectProperty rdf:ID='p1'>    <owl:inverseOf>      <owl:ObjectProperty rdf:ID='q1' />    </owl:inverseOf>  </owl:ObjectProperty></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        ontModel.read(new StringReader(string), null);
        ObjectProperty objectProperty = ontModel.getObjectProperty("http://jena.hpl.hp.com/test#p0");
        OntProperty ontProperty = objectProperty.getInverseOf();
        TestBugReports.assertEquals((Object)ontModel.getResource("http://jena.hpl.hp.com/test#q0"), (Object)ontProperty);
        TestBugReports.assertTrue((String)"Should be an ObjectProperty facet", (boolean)(ontProperty instanceof ObjectProperty));
        ObjectProperty objectProperty2 = ontModel.getObjectProperty("http://jena.hpl.hp.com/test#q1");
        OntProperty ontProperty2 = objectProperty2.getInverse();
        TestBugReports.assertEquals((Object)ontModel.getResource("http://jena.hpl.hp.com/test#p1"), (Object)ontProperty2);
        TestBugReports.assertTrue((String)"Should be an ObjectProperty facet", (boolean)(ontProperty2 instanceof ObjectProperty));
    }

    public void test_sf_978259() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM);
        OntModel ontModel2 = ModelFactory.createOntologyModel(OntModelSpec.OWL_LITE_MEM);
        DataRange dataRange = ontModel.createDataRange(ontModel.createList(new Resource[]{OWL.Thing}));
        TestBugReports.assertNotNull((Object)dataRange);
        HasValueRestriction hasValueRestriction = ontModel.createHasValueRestriction(null, RDFS.seeAlso, OWL.Thing);
        TestBugReports.assertNotNull((Object)hasValueRestriction);
    }

    public void test_ijd_01() {
        String string = "<!DOCTYPE rdf:RDF [    <!ENTITY nuin      'http://www.nuin.org'>    <!ENTITY rdf       'http://www.w3.org/1999/02/22-rdf-syntax-ns#'>    <!ENTITY xsd       'http://www.w3.org/2001/XMLSchema#'>    <!ENTITY owl       'http://www.w3.org/2002/07/owl#'>    <!ENTITY jms       'http://jena.hpl.hp.com/2003/08/jms#'>    <!ENTITY reasoner  'http://jena.hpl.hp.com/2003/'>    <!ENTITY base      '&nuin;/demo/kma'>    <!ENTITY kma       '&base;#'>]><rdf:RDF    xmlns:rdf          ='&rdf;'    xmlns:xsd          ='&xsd;'    xmlns:owl          ='&owl;'    xmlns:jms          ='&jms;'    xmlns:kma          ='&kma;'    xml:base           ='&base;'>  <kma:AgentConfiguration rdf:about='&kma;ijdTest'>          <kma:rdfModelSpec>            <jms:OntModelSpec>              <jms:ontLanguage rdf:resource='&owl;' />              <jms:reasonsWith>                <jms:Reasoner>                  <jms:reasoner rdf:resource='&reasoner;OWLFBRuleReasoner' />                </jms:Reasoner>              </jms:reasonsWith>            </jms:OntModelSpec>          </kma:rdfModelSpec>  </kma:AgentConfiguration></rdf:RDF>";
        Model model = ModelFactory.createDefaultModel();
        model.read(new StringReader(string), null);
        Resource resource = model.getResource("http://www.nuin.org/demo/kma#ijdTest");
        Property property = model.getProperty("http://www.nuin.org/demo/kma#rdfModelSpec");
        Resource resource2 = resource.getProperty(property).getResource();
        OntModel ontModel = (OntModel)ModelFactory.createSpec(resource2, model).createModel();
        OntClass ontClass = ontModel.createClass("A");
        OntClass ontClass2 = ontModel.createClass("B");
        OntClass ontClass3 = ontModel.createClass("C");
        ontClass3.addSuperClass(ontClass2);
        ontClass2.addSuperClass(ontClass);
        TestBugReports.assertTrue((boolean)ontClass3.hasSuperClass(ontClass));
    }

    public void test_jt_01() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource();
        resource.addProperty(ReasonerVocabulary.EXT_REASONER_URL, model.createResource("http://localhost:2004"));
        DIGReasonerFactory dIGReasonerFactory = (DIGReasonerFactory)ReasonerRegistry.theRegistry().getFactory("http://jena.hpl.hp.com/2003/DIGReasoner");
        DIGReasoner dIGReasoner = (DIGReasoner)dIGReasonerFactory.create(resource);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        boolean bl = false;
        try {
            ExtendedIterator extendedIterator = ontModel.listIndividuals();
            System.out.println(extendedIterator.hasNext());
        }
        catch (DIGWrappedException dIGWrappedException) {
            bl = true;
        }
        TestBugReports.assertTrue((String)"Should have seen a dig wrapped exception for connection fail", (boolean)bl);
    }

    public void test_dab_01() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass ontClass = ontModel.createClass(NS + "c0");
        ObjectProperty objectProperty = ontModel.createObjectProperty(NS + "p0");
        objectProperty.setDomain(ontClass);
        OntModel ontModel2 = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        OntClass ontClass2 = ontModel2.createClass(NS + "c1");
        ontClass2.addSuperClass(ontClass);
        ontModel2.addSubModel(ontModel);
        OntClass ontClass3 = ontModel2.getOntClass(NS + "c0");
        TestBugReports.assertNotNull((Object)ontClass3);
        TestUtil.assertIteratorValues(this, ontClass2.listDeclaredProperties(), new Object[]{objectProperty});
        TestUtil.assertIteratorValues(this, ontClass.listDeclaredProperties(false), new Object[]{objectProperty});
        TestUtil.assertIteratorValues(this, ontClass3.listDeclaredProperties(false), new Object[]{objectProperty});
    }

    private int getStatementCount(OntModel ontModel) {
        int n = 0;
        StmtIterator stmtIterator = ontModel.listStatements();
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        return n;
    }

    class MockTransactionHandler
    extends SimpleTransactionHandler {
        boolean m_inTransaction = false;
        boolean m_aborted = false;
        boolean m_committed = false;

        MockTransactionHandler() {
        }

        public void begin() {
            this.m_inTransaction = true;
        }

        public void abort() {
            this.m_inTransaction = false;
            this.m_aborted = true;
        }

        public void commit() {
            this.m_inTransaction = false;
            this.m_committed = true;
        }
    }
}

