/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.OWLDLProfile;
import com.hp.hpl.jena.ontology.impl.OWLLiteProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.ontology.impl.test.TestOntDocumentManager;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestOntModel
extends ModelTestBase {
    public static final String BASE = "http://www.hp.com/test";
    public static final String NS = "http://www.hp.com/test#";
    public static final String DOC = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\"   xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\">  <owl:Class rdf:about=\"http://www.hp.com/test#D\">    <rdfs:subClassOf>      <owl:Class rdf:about=\"http://www.hp.com/test#B\"/>    </rdfs:subClassOf>  </owl:Class>  <owl:Class rdf:about=\"http://www.hp.com/test#B\">    <rdfs:subClassOf rdf:resource=\"http://www.hp.com/test#A\"       rdf:type=\"http://www.w3.org/2002/07/owl#Class\"/>  </owl:Class>  <owl:Class rdf:about=\"http://www.hp.com/test#C\">    <rdfs:subClassOf rdf:resource=\"http://www.hp.com/test#B\"/>  </owl:Class>  <owl:ObjectProperty rdf:about=\"http://www.hp.com/test#p\">    <rdfs:domain rdf:resource=\"http://www.hp.com/test#A\"/>    <rdfs:range rdf:resource=\"http://www.hp.com/test#B\"/>    <rdfs:range rdf:resource=\"http://www.hp.com/test#C\"/>  </owl:ObjectProperty></rdf:RDF>";

    public TestOntModel(String string) {
        super(string);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testWriteOutputStream() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://www.hp.com/test#B");
        OntClass ontClass3 = ontModel.createClass("http://www.hp.com/test#C");
        OntClass ontClass4 = ontModel.createClass("http://www.hp.com/test#D");
        ontClass.addSubClass(ontClass2);
        ontClass2.addSubClass(ontClass3);
        ontClass2.addSubClass(ontClass4);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.hp.com/test#p");
        objectProperty.addDomain(ontClass);
        objectProperty.addRange(ontClass2);
        objectProperty.addRange(ontClass3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ontModel.write(byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        Model model = ModelFactory.createDefaultModel();
        model.read(byteArrayInputStream, BASE);
        Model model2 = ModelFactory.createDefaultModel();
        model2.read(new ByteArrayInputStream(DOC.getBytes()), BASE);
        TestOntModel.assertTrue((String)"InputStream write/read cycle failed (1)", (boolean)model.isIsomorphicWith(ontModel.getBaseModel()));
        TestOntModel.assertTrue((String)"InputStream write/read cycle failed (2)", (boolean)model2.isIsomorphicWith(ontModel.getBaseModel()));
    }

    public void testGetBaseModelPrefixes() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.setNsPrefix("bill", "http://bill.and.ben/flowerpot#");
        ontModel.setNsPrefix("grue", "ftp://grue.and.bleen/2000#");
        TestOntModel.assertEquals((Object)ontModel.getNsPrefixMap(), (Object)ontModel.getBaseModel().getNsPrefixMap());
    }

    public void testPrefixDefaulting() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("hedgehog", "http://hedgehog.hog/");
        model.setNsPrefix("daml", "not:the-DAML-URI/");
        model.setNsPrefix("mine", RDF.getURI());
        OntModelImpl ontModelImpl = new OntModelImpl(OntModelSpec.RDFS_MEM, model);
        PrefixMapping prefixMapping = ontModelImpl.getDocumentManager().getDeclaredPrefixMapping();
        TestOntModel.assertEquals((String)"http://hedgehog.hog/", (String)ontModelImpl.getNsPrefixURI("hedgehog"));
        TestOntModel.assertEquals((String)"not:the-DAML-URI/", (String)ontModelImpl.getNsPrefixURI("daml"));
        TestOntModel.assertEquals((String)RDF.getURI(), (String)ontModelImpl.getNsPrefixURI("mine"));
        TestOntModel.assertEquals(null, (String)ontModelImpl.getNsPrefixURI("rdf"));
        TestOntModel.assertEquals((String)prefixMapping.getNsPrefixURI("rdfs"), (String)ontModelImpl.getNsPrefixURI("rdfs"));
    }

    public void testWritesPrefixes() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.setNsPrefix("spoo", "http://spoo.spoo.com/spoo#");
        ontModel.add(TestOntModel.statement(ontModel, "ping http://spoo.spoo.com/spoo#pang pilly"));
        ontModel.add(TestOntModel.statement(ontModel, "gg http://www.daml.org/2001/03/daml+oil#hh ii"));
        StringWriter stringWriter = new StringWriter();
        ontModel.write(stringWriter);
        String string = stringWriter.getBuffer().toString();
        TestOntModel.assertTrue((string.indexOf("xmlns:spoo=\"http://spoo.spoo.com/spoo#\"") > 0 ? 1 : 0) != 0);
        TestOntModel.assertTrue((string.indexOf("xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"") > 0 ? 1 : 0) != 0);
    }

    public void testWriteWriter() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#A");
        OntClass ontClass2 = ontModel.createClass("http://www.hp.com/test#B");
        OntClass ontClass3 = ontModel.createClass("http://www.hp.com/test#C");
        OntClass ontClass4 = ontModel.createClass("http://www.hp.com/test#D");
        ontClass.addSubClass(ontClass2);
        ontClass2.addSubClass(ontClass3);
        ontClass2.addSubClass(ontClass4);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.hp.com/test#p");
        objectProperty.addDomain(ontClass);
        objectProperty.addRange(ontClass2);
        objectProperty.addRange(ontClass3);
        StringWriter stringWriter = new StringWriter();
        ontModel.write(stringWriter);
        String string = stringWriter.toString();
        Model model = ModelFactory.createDefaultModel();
        model.read(new StringReader(string), BASE);
        Model model2 = ModelFactory.createDefaultModel();
        model2.read(new StringReader(DOC), BASE);
        TestOntModel.assertTrue((String)"Writer write/read cycle failed (1)", (boolean)model.isIsomorphicWith(ontModel.getBaseModel()));
        TestOntModel.assertTrue((String)"Writer write/read cycle failed (2)", (boolean)model2.isIsomorphicWith(ontModel.getBaseModel()));
    }

    public void testGetOntology() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        Ontology ontology = ontModel.createOntology("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)ontology, (Object)ontModel.getOntology("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getOntology("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getOntology("http://www.hp.com/test#r"));
    }

    public void testGetIndividual() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        Individual individual = ontModel.createIndividual("http://www.hp.com/test#s", ontClass);
        TestOntModel.assertEquals((String)"Result of get s", (Object)individual, (Object)ontModel.getIndividual("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getIndividual("http://www.hp.com/test#q"));
    }

    public void testGetOntProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        OntProperty ontProperty = ontModel.createOntProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)ontProperty, (Object)ontModel.getOntProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getOntProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getOntProperty("http://www.hp.com/test#r"));
    }

    public void testGetObjectProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        ObjectProperty objectProperty = ontModel.createObjectProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)objectProperty, (Object)ontModel.getObjectProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getObjectProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getObjectProperty("http://www.hp.com/test#r"));
    }

    public void testGetTransitiveProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        TransitiveProperty transitiveProperty = ontModel.createTransitiveProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)transitiveProperty, (Object)ontModel.getTransitiveProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getTransitiveProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getTransitiveProperty("http://www.hp.com/test#r"));
    }

    public void testGetSymmetricProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        SymmetricProperty symmetricProperty = ontModel.createSymmetricProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)symmetricProperty, (Object)ontModel.getSymmetricProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getSymmetricProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getSymmetricProperty("http://www.hp.com/test#r"));
    }

    public void testGetInverseFunctionalProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        InverseFunctionalProperty inverseFunctionalProperty = ontModel.createInverseFunctionalProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)inverseFunctionalProperty, (Object)ontModel.getInverseFunctionalProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getInverseFunctionalProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getInverseFunctionalProperty("http://www.hp.com/test#r"));
    }

    public void testGetDatatypeProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        DatatypeProperty datatypeProperty = ontModel.createDatatypeProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)datatypeProperty, (Object)ontModel.getDatatypeProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getDatatypeProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getDatatypeProperty("http://www.hp.com/test#r"));
    }

    public void testGetAnnotationProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        AnnotationProperty annotationProperty = ontModel.createAnnotationProperty("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)annotationProperty, (Object)ontModel.getAnnotationProperty("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getAnnotationProperty("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getAnnotationProperty("http://www.hp.com/test#r"));
    }

    public void testGetOntResource() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntResource ontResource = ontModel.getOntResource("http://www.hp.com/test#a");
        TestOntModel.assertNull((Object)ontResource);
        OntResource ontResource2 = ontModel.createOntResource("http://www.hp.com/test#aaa");
        TestOntModel.assertTrue((boolean)(ontResource2 instanceof OntResource));
        Resource resource = ontModel.getResource("http://www.hp.com/test#a");
        Resource resource2 = ontModel.getResource("http://www.hp.com/test#b");
        Property property = ontModel.getProperty("http://www.hp.com/test#p");
        ontModel.add(resource, property, resource2);
        ontResource = ontModel.getOntResource("http://www.hp.com/test#a");
        TestOntModel.assertTrue((boolean)(ontResource instanceof OntResource));
        OntResource ontResource3 = ontModel.getOntResource(resource2);
        TestOntModel.assertTrue((boolean)(ontResource3 instanceof OntResource));
    }

    public void testGetOntClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        Resource resource2 = ontModel.getResource("http://www.hp.com/test#r0");
        ontModel.add(resource, RDF.type, resource2);
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#s");
        TestOntModel.assertEquals((String)"Result of get s", (Object)ontClass, (Object)ontModel.getOntClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getOntClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getOntClass("http://www.hp.com/test#r"));
    }

    public void testGetComplementClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        ComplementClass complementClass = ontModel.createComplementClass("http://www.hp.com/test#s", ontClass);
        TestOntModel.assertEquals((String)"Result of get s", (Object)complementClass, (Object)ontModel.getComplementClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getComplementClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getComplementClass("http://www.hp.com/test#r"));
    }

    public void testGetEnumeratedClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        RDFList rDFList = ontModel.createList();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        EnumeratedClass enumeratedClass = ontModel.createEnumeratedClass("http://www.hp.com/test#s", rDFList);
        TestOntModel.assertEquals((String)"Result of get s", (Object)enumeratedClass, (Object)ontModel.getEnumeratedClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getEnumeratedClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getEnumeratedClass("http://www.hp.com/test#r"));
    }

    public void testGetUnionClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        RDFList rDFList = ontModel.createList();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        UnionClass unionClass = ontModel.createUnionClass("http://www.hp.com/test#s", rDFList);
        TestOntModel.assertEquals((String)"Result of get s", (Object)unionClass, (Object)ontModel.getUnionClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getUnionClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getUnionClass("http://www.hp.com/test#r"));
    }

    public void testGetIntersectionClass() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        RDFList rDFList = ontModel.createList();
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        IntersectionClass intersectionClass = ontModel.createIntersectionClass("http://www.hp.com/test#s", rDFList);
        TestOntModel.assertEquals((String)"Result of get s", (Object)intersectionClass, (Object)ontModel.getIntersectionClass("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getIntersectionClass("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getIntersectionClass("http://www.hp.com/test#r"));
    }

    public void testGetRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        Restriction restriction = ontModel.createRestriction("http://www.hp.com/test#s", property);
        TestOntModel.assertEquals((String)"Result of get s", (Object)restriction, (Object)ontModel.getRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getRestriction("http://www.hp.com/test#r"));
    }

    public void testGetHasValueRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        HasValueRestriction hasValueRestriction = ontModel.createHasValueRestriction("http://www.hp.com/test#s", property, ontClass);
        TestOntModel.assertEquals((String)"Result of get s", (Object)hasValueRestriction, (Object)ontModel.getHasValueRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getHasValueRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getHasValueRestriction("http://www.hp.com/test#r"));
    }

    public void testGetSomeValuesFromRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        SomeValuesFromRestriction someValuesFromRestriction = ontModel.createSomeValuesFromRestriction("http://www.hp.com/test#s", property, ontClass);
        TestOntModel.assertEquals((String)"Result of get s", (Object)someValuesFromRestriction, (Object)ontModel.getSomeValuesFromRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getSomeValuesFromRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getSomeValuesFromRestriction("http://www.hp.com/test#r"));
    }

    public void testGetAllValuesFromRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        OntClass ontClass = ontModel.createClass("http://www.hp.com/test#c");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        AllValuesFromRestriction allValuesFromRestriction = ontModel.createAllValuesFromRestriction("http://www.hp.com/test#s", property, ontClass);
        TestOntModel.assertEquals((String)"Result of get s", (Object)allValuesFromRestriction, (Object)ontModel.getAllValuesFromRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getAllValuesFromRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getAllValuesFromRestriction("http://www.hp.com/test#r"));
    }

    public void testGetCardinalityRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        CardinalityRestriction cardinalityRestriction = ontModel.createCardinalityRestriction("http://www.hp.com/test#s", property, 1);
        TestOntModel.assertEquals((String)"Result of get s", (Object)cardinalityRestriction, (Object)ontModel.getCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetMinCardinalityRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        MinCardinalityRestriction minCardinalityRestriction = ontModel.createMinCardinalityRestriction("http://www.hp.com/test#s", property, 1);
        TestOntModel.assertEquals((String)"Result of get s", (Object)minCardinalityRestriction, (Object)ontModel.getMinCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getMinCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getMinCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetMaxCardinalityRestriction() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        Property property = ontModel.createProperty("http://www.hp.com/test#p");
        Resource resource = ontModel.getResource("http://www.hp.com/test#r");
        ontModel.add(resource, RDF.type, resource);
        MaxCardinalityRestriction maxCardinalityRestriction = ontModel.createMaxCardinalityRestriction("http://www.hp.com/test#s", property, 1);
        TestOntModel.assertEquals((String)"Result of get s", (Object)maxCardinalityRestriction, (Object)ontModel.getMaxCardinalityRestriction("http://www.hp.com/test#s"));
        TestOntModel.assertNull((String)"result of get q", (Object)ontModel.getMaxCardinalityRestriction("http://www.hp.com/test#q"));
        TestOntModel.assertNull((String)"result of get r", (Object)ontModel.getMaxCardinalityRestriction("http://www.hp.com/test#r"));
    }

    public void testGetSubgraphs() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals((String)"Marker count not correct", (int)4, (int)TestOntDocumentManager.countMarkers(ontModel));
        List list = ontModel.getSubGraphs();
        TestOntModel.assertEquals((String)"n subgraphs should be ", (int)3, (int)list.size());
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Graph) continue;
            bl = false;
        }
        TestOntModel.assertTrue((String)"All sub-graphs should be graphs", (boolean)bl);
    }

    public void testListImportURIs() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport6/a.owl");
        Set set = ontModel.listImportedOntologyURIs();
        TestOntModel.assertEquals((String)"Should be two non-closed import URI's", (int)2, (int)set.size());
        TestOntModel.assertTrue((String)"b should be imported ", (boolean)set.contains("file:testing/ontology/testImport6/b.owl"));
        TestOntModel.assertFalse((String)"c should not be imported ", (boolean)set.contains("file:testing/ontology/testImport6/c.owl"));
        TestOntModel.assertTrue((String)"d should be imported ", (boolean)set.contains("file:testing/ontology/testImport6/d.owl"));
        set = ontModel.listImportedOntologyURIs(true);
        TestOntModel.assertEquals((String)"Should be two non-closed import URI's", (int)3, (int)set.size());
        TestOntModel.assertTrue((String)"b should be imported ", (boolean)set.contains("file:testing/ontology/testImport6/b.owl"));
        TestOntModel.assertTrue((String)"c should be imported ", (boolean)set.contains("file:testing/ontology/testImport6/c.owl"));
        TestOntModel.assertTrue((String)"d should be imported ", (boolean)set.contains("file:testing/ontology/testImport6/d.owl"));
    }

    public void testListImportedModels() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertEquals((String)"Marker count not correct", (int)4, (int)TestOntDocumentManager.countMarkers(ontModel));
        ArrayList arrayList = new ArrayList();
        ExtendedIterator extendedIterator = ontModel.listImportedModels();
        while (extendedIterator.hasNext()) {
            arrayList.add(extendedIterator.next());
        }
        TestOntModel.assertEquals((String)"n import models should be ", (int)3, (int)arrayList.size());
        boolean bl = true;
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof OntModel)) {
                bl = false;
                continue;
            }
            OntModel ontModel2 = (OntModel)e;
            n += ontModel2.listImportedOntologyURIs().size();
        }
        TestOntModel.assertTrue((String)"All import models should be OntModels", (boolean)bl);
        TestOntModel.assertEquals((String)"Wrong number of sub-model imports", (int)2, (int)n);
    }

    public void testGetImportedModel() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.read("file:testing/ontology/testImport6/a.owl");
        OntModel ontModel2 = ontModel.getImportedModel("file:testing/ontology/testImport6/b.owl");
        OntModel ontModel3 = ontModel.getImportedModel("file:testing/ontology/testImport6/c.owl");
        OntModel ontModel4 = ontModel.getImportedModel("file:testing/ontology/testImport6/d.owl");
        OntModel ontModel5 = ontModel.getImportedModel("file:testing/ontology/testImport6/b.owl").getImportedModel("file:testing/ontology/testImport6/c.owl");
        OntModel ontModel6 = ontModel.getImportedModel("file:testing/ontology/testImport6/a.owl");
        TestOntModel.assertNotNull((String)"Import model b should not be null", (Object)ontModel2);
        TestOntModel.assertNotNull((String)"Import model c should not be null", (Object)ontModel3);
        TestOntModel.assertNotNull((String)"Import model d should not be null", (Object)ontModel4);
        TestOntModel.assertNotNull((String)"Import model b-c should not be null", (Object)ontModel5);
        TestOntModel.assertNull((String)"Import model a should be null", (Object)ontModel6);
    }

    public void testProfiles() {
        List<Class> list = Arrays.asList(new Class[0]);
        List<Class> list2 = Arrays.asList(DataRange.class, HasValueRestriction.class);
        Map map = new OWLProfileExt().getSupportsMap();
        Map map2 = new OWLDLProfileExt().getSupportsMap();
        Map map3 = new OWLLiteProfileExt().getSupportsMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Class clazz = (Class)entry.getKey();
            TestOntModel.assertTrue((String)("Key in OWL DL profile: " + clazz.getName()), (map2.containsKey(clazz) || list.contains(clazz) ? 1 : 0) != 0);
            TestOntModel.assertTrue((String)("Key in OWL lite profile: " + clazz.getName()), (map3.containsKey(clazz) || list2.contains(clazz) ? 1 : 0) != 0);
        }
    }

    public void testBulkAddWorks() {
        OntModel ontModel = ModelFactory.createOntologyModel();
        OntModel ontModel2 = ModelFactory.createOntologyModel();
        ontModel.add(ontModel2);
    }

    public void testRead() {
        String string = "http://example.com/test0";
        String string2 = string + "#";
        String string3 = "http://example.com/test1";
        String string4 = string3 + "#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        ontModel.getDocumentManager().reset();
        ontModel.getDocumentManager().addAltEntry(string, "file:testing/ontology/relativenames.rdf");
        ontModel.read(string, "RDF/XML");
        TestOntModel.assertNotNull((String)"Should be a class ns0:A", (Object)ontModel.getOntClass(string2 + "A"));
        TestOntModel.assertNull((String)"Should not be a class ns1:A", (Object)ontModel.getOntClass(string4 + "A"));
        ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        ontModel.getDocumentManager().reset();
        ontModel.getDocumentManager().addAltEntry(string, "file:testing/ontology/relativenames.rdf");
        ontModel.read(string, string3, "RDF/XML");
        TestOntModel.assertNull((String)"Should not be a class ns0:A", (Object)ontModel.getOntClass(string2 + "A"));
        TestOntModel.assertNotNull((String)"Should be a class ns1:A", (Object)ontModel.getOntClass(string4 + "A"));
    }

    public void testListDataRange() {
        String string = "http://jena.hpl.hp.com/test#";
        String string2 = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF   xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'   xmlns:owl='http://www.w3.org/2002/07/owl#'>  <owl:DataRange>    <owl:oneOf>      <rdf:List>        <rdf:first rdf:datatype='&xsd;integer'>0</rdf:first>        <rdf:rest rdf:resource='&rdf;nil' />      </rdf:List>    </owl:oneOf>  </owl:DataRange></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read(new StringReader(string2), string);
        ExtendedIterator extendedIterator = ontModel.listDataRanges();
        TestOntModel.assertTrue((String)"Should be at least one DataRange", (boolean)extendedIterator.hasNext());
        Object e = extendedIterator.next();
        TestOntModel.assertTrue((boolean)(e instanceof DataRange));
        TestOntModel.assertFalse((String)"Should no more DataRange", (boolean)extendedIterator.hasNext());
    }

    public void testListHierarchyRoots0() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM);
        TestOntModel.assertFalse((boolean)ontModel.listHierarchyRootClasses().hasNext());
        ontModel = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM);
        TestOntModel.assertFalse((boolean)ontModel.listHierarchyRootClasses().hasNext());
    }

    public void testListHierarchyRoots1() {
        String string = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. ";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
        ontModel.read(new StringReader(string), NS, "N3");
        OntClass ontClass = ontModel.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, ontModel.listHierarchyRootClasses(), new Object[]{ontClass});
    }

    public void testListHierarchyRoots2() {
        String string = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. ";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        ontModel.read(new StringReader(string), NS, "N3");
        OntClass ontClass = ontModel.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, ontModel.listHierarchyRootClasses(), new Object[]{ontClass});
    }

    public void testListHierarchyRoots3() {
        String string = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a owl:Class. :B a owl:Class ; rdfs:subClassOf :A . ";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_MINI_RULE_INF, null);
        ontModel.read(new StringReader(string), NS, "N3");
        OntClass ontClass = ontModel.getOntClass("http://www.hp.com/test#A");
        TestUtil.assertIteratorValues(this, ontModel.listHierarchyRootClasses(), new Object[]{ontClass});
    }

    public void testListHierarchyRoots4() {
        String string = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>. @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>. @prefix xsd: <http://www.w3.org/2001/XMLSchema#>. @prefix owl: <http://www.w3.org/2002/07/owl#>. @prefix : <http://www.hp.com/test#>. :A a rdfs:Class. :C a rdfs:Class. :B a rdfs:Class ; rdfs:subClassOf :A . ";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.RDFS_MEM_RDFS_INF, null);
        ontModel.read(new StringReader(string), NS, "N3");
        OntClass ontClass = ontModel.getOntClass("http://www.hp.com/test#A");
        OntClass ontClass2 = ontModel.getOntClass("http://www.hp.com/test#C");
        TestUtil.assertIteratorValues(this, ontModel.listHierarchyRootClasses(), new Object[]{ontClass, ontClass2});
    }

    protected class OWLLiteProfileExt
    extends OWLLiteProfile {
        protected OWLLiteProfileExt() {
        }

        public Map getSupportsMap() {
            return this.getCheckTable();
        }
    }

    protected class OWLDLProfileExt
    extends OWLDLProfile {
        protected OWLDLProfileExt() {
        }

        public Map getSupportsMap() {
            return this.getCheckTable();
        }
    }

    protected class OWLProfileExt
    extends OWLProfile {
        protected OWLProfileExt() {
        }

        public Map getSupportsMap() {
            return this.getCheckTable();
        }
    }
}

