/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ARPRunnable;
import com.hp.hpl.jena.rdf.arp.PushMePullYouPipe;
import com.hp.hpl.jena.rdf.arp.Token;
import java.util.Vector;
import junit.framework.TestCase;

public class PushMePullYouTest
extends TestCase {
    PushMePullYouPipe pipe;

    public void testBuf4() throws Exception {
        this.testBuffer(4);
    }

    public void testBuf5() throws Exception {
        this.testBuffer(5);
    }

    public void testBuf8() throws Exception {
        this.testBuffer(8);
    }

    public void testBuf10() throws Exception {
        this.testBuffer(10);
    }

    public void testBuf11() throws Exception {
        this.testBuffer(11);
    }

    public void testBuf12() throws Exception {
        this.testBuffer(12);
    }

    private void testBuffer(final int n) throws Exception {
        int n2;
        final Vector vector = new Vector();
        ARPRunnable aRPRunnable = new ARPRunnable(){

            public void run() {
                for (int i = 0; i < n; ++i) {
                    Token token = PushMePullYouTest.this.pipe.getNextToken();
                    vector.add(token);
                }
            }
        };
        this.pipe = new PushMePullYouPipe(aRPRunnable);
        this.pipe.start();
        for (n2 = 0; n2 < n; ++n2) {
            this.pipe.putNextToken(new Token(n2, null));
        }
        this.pipe.close();
        for (n2 = 0; n2 < n; ++n2) {
            PushMePullYouTest.assertEquals((String)("pos " + n2), (int)n2, (int)((Token)vector.get((int)n2)).kind);
        }
    }

    public void testInterrupt() {
        Thread thread = Thread.currentThread();
        thread.interrupt();
        PushMePullYouTest.assertTrue((boolean)thread.isInterrupted());
        try {
            Thread.sleep(50L);
            PushMePullYouTest.fail((String)"Wasn't interrupted");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

