/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.DAMLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.HashMap;
import java.util.Map;

public class ReasonerRegistry {
    protected static ReasonerRegistry theRegistry;
    protected Map reasonerFactories = new HashMap();
    protected Model allDescriptions = ModelFactory.createDefaultModel();
    protected static Reasoner theRDFSReasoner;
    protected static Reasoner theRDFSSimpleReasoner;
    protected static Reasoner theTRANSITIVEReasoner;
    protected static Reasoner theOWLReasoner;
    protected static Reasoner theOWLMicroReasoner;
    protected static Reasoner theOWLMiniReasoner;

    private ReasonerRegistry() {
        this.register(TransitiveReasonerFactory.theInstance());
        this.register(RDFSRuleReasonerFactory.theInstance());
        this.register(OWLFBRuleReasonerFactory.theInstance());
        this.register(GenericRuleReasonerFactory.theInstance());
        this.register(DAMLMicroReasonerFactory.theInstance());
        this.register(DIGReasonerFactory.theInstance());
        this.register(OWLMicroReasonerFactory.theInstance());
        this.register(OWLMiniReasonerFactory.theInstance());
    }

    public static ReasonerRegistry theRegistry() {
        if (theRegistry == null) {
            theRegistry = new ReasonerRegistry();
        }
        return theRegistry;
    }

    public void register(ReasonerFactory reasonerFactory) {
        this.reasonerFactories.put(reasonerFactory.getURI(), reasonerFactory);
        Model model = reasonerFactory.getCapabilities();
        if (model != null) {
            this.allDescriptions.add(model);
        }
        this.allDescriptions.createResource(reasonerFactory.getURI()).addProperty(RDF.type, ReasonerVocabulary.ReasonerClass);
    }

    public void register(String string, ReasonerFactory reasonerFactory) {
        this.reasonerFactories.put(string, reasonerFactory);
        this.allDescriptions.createResource(string).addProperty(RDF.type, ReasonerVocabulary.ReasonerClass);
    }

    public Model getAllDescriptions() {
        return this.allDescriptions;
    }

    public Resource getDescription(String string) {
        Resource resource = this.allDescriptions.getResource(string);
        if (this.allDescriptions.contains(resource, RDF.type, ReasonerVocabulary.ReasonerClass)) {
            return resource;
        }
        return null;
    }

    public ReasonerFactory getFactory(String string) {
        return (ReasonerFactory)this.reasonerFactories.get(string);
    }

    public Reasoner create(String string, Resource resource) throws ReasonerException {
        ReasonerFactory reasonerFactory = this.getFactory(string);
        if (reasonerFactory != null) {
            return reasonerFactory.create(resource);
        }
        throw new ReasonerException("Attempted to instantiate an unknown reasoner: " + string);
    }

    public static Node makeDirect(Node node) {
        String string = "urn:x-hp-direct-predicate:" + node.getURI().replace(':', '_');
        return Node.createURI(string);
    }

    public static Reasoner getRDFSReasoner() {
        if (theRDFSReasoner == null) {
            theRDFSReasoner = RDFSRuleReasonerFactory.theInstance().create(null);
        }
        return theRDFSReasoner;
    }

    public static Reasoner getRDFSSimpleReasoner() {
        if (theRDFSSimpleReasoner == null) {
            theRDFSSimpleReasoner = RDFSRuleReasonerFactory.theInstance().create(null);
            theRDFSSimpleReasoner.setParameter(ReasonerVocabulary.PROPsetRDFSLevel, ReasonerVocabulary.RDFS_SIMPLE);
        }
        return theRDFSSimpleReasoner;
    }

    public static Reasoner getTransitiveReasoner() {
        if (theTRANSITIVEReasoner == null) {
            theTRANSITIVEReasoner = TransitiveReasonerFactory.theInstance().create(null);
        }
        return theTRANSITIVEReasoner;
    }

    public static Reasoner getOWLReasoner() {
        if (theOWLReasoner == null) {
            theOWLReasoner = OWLFBRuleReasonerFactory.theInstance().create(null);
        }
        return theOWLReasoner;
    }

    public static Reasoner getOWLMicroReasoner() {
        if (theOWLMicroReasoner == null) {
            theOWLMicroReasoner = OWLMicroReasonerFactory.theInstance().create(null);
        }
        return theOWLMicroReasoner;
    }

    public static Reasoner getOWLMiniReasoner() {
        if (theOWLMiniReasoner == null) {
            theOWLMiniReasoner = OWLMiniReasonerFactory.theInstance().create(null);
        }
        return theOWLMiniReasoner;
    }

    public static DIGReasoner getDIGReasoner() {
        return ReasonerRegistry.getDIGReasoner(OWL.NAMESPACE, null);
    }

    public static DIGReasoner getDIGReasoner(Resource resource, Resource resource2) {
        return ReasonerRegistry.getDIGReasoner(resource, false, resource2);
    }

    public static DIGReasoner getDIGReasoner(Resource resource, boolean bl, Resource resource2) {
        if (!((Object)resource).equals(DAML_OIL.NAMESPACE_DAML) && !((Object)resource).equals(OWL.NAMESPACE)) {
            throw new ReasonerException("Cannot create DIG reasoner for unknown language: " + resource);
        }
        boolean bl2 = ((Object)resource).equals(OWL.NAMESPACE);
        String string = bl ? (bl2 ? "file:etc/dig-owl-axioms.rdf" : "file:etc/dig-daml-axioms.rdf") : null;
        return DIGReasonerFactory.theInstance().create(resource, string, resource2);
    }

    static {
        theRDFSReasoner = null;
        theRDFSSimpleReasoner = null;
    }
}

