/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryAncestorsTranslator
extends DIGQueryTranslator {
    protected boolean m_ancestors;

    public DIGQueryAncestorsTranslator(String string, boolean bl) {
        this(bl ? null : "*", string, bl ? "*" : null, bl);
    }

    protected DIGQueryAncestorsTranslator(String string, String string2, String string3, boolean bl) {
        super(string, string2, string3);
        this.m_ancestors = bl;
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        if (this.m_ancestors) {
            Element element = dIGAdapter.createQueryElement(document, "ancestors");
            dIGAdapter.addClassDescription(element, triplePattern.getSubject());
        } else {
            Element element = dIGAdapter.createQueryElement(document, "descendants");
            dIGAdapter.addClassDescription(element, triplePattern.getObject());
        }
        return document;
    }

    public ExtendedIterator translateResponseHook(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        return this.translateConceptSetResponse(document, triplePattern, this.m_ancestors, dIGAdapter).andThen(new SingletonIterator(new Triple(this.m_ancestors ? triplePattern.getSubject() : triplePattern.getObject(), triplePattern.getPredicate(), this.m_ancestors ? triplePattern.getSubject() : triplePattern.getObject())));
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return null;
    }

    public boolean checkSubject(Node node, DIGAdapter dIGAdapter, Model model) {
        return !this.m_ancestors || dIGAdapter.isConcept(node, model);
    }

    public boolean checkObject(Node node, DIGAdapter dIGAdapter, Model model) {
        return this.m_ancestors || dIGAdapter.isConcept(node, model);
    }
}

