/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryAncestorsTranslator;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.util.iterator.Filter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryParentsTranslator
extends DIGQueryAncestorsTranslator {
    public DIGQueryParentsTranslator(String string, boolean bl) {
        super(string, bl);
    }

    public DIGQueryParentsTranslator(String string, String string2, String string3, boolean bl) {
        super(string, string2, string3, bl);
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        if (this.m_ancestors) {
            Element element = dIGAdapter.createQueryElement(document, "parents");
            dIGAdapter.addClassDescription(element, triplePattern.getSubject());
        } else {
            Element element = dIGAdapter.createQueryElement(document, "children");
            dIGAdapter.addClassDescription(element, triplePattern.getObject());
        }
        return document;
    }

    protected Filter getResultsTripleFilter(TriplePattern triplePattern) {
        return new FilterSubjectAndObject(triplePattern.getSubject(), triplePattern.getObject());
    }

    private class FilterSubjectAndObject
    implements Filter {
        private Node m_subj;
        private Node m_obj;

        private FilterSubjectAndObject(Node node, Node node2) {
            this.m_subj = node;
            this.m_obj = node2;
        }

        public boolean accept(Object object) {
            Triple triple = (Triple)object;
            return !(this.m_subj != null && this.m_subj != Node_RuleVariable.WILD && this.m_subj != Node.ANY && !triple.getSubject().equals(this.m_subj) || this.m_obj != null && this.m_obj != Node_RuleVariable.WILD && this.m_obj != Node.ANY && !triple.getObject().equals(this.m_obj));
        }
    }
}

