/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryRoleAncestorsTranslator
extends DIGQueryTranslator {
    protected boolean m_ancestors;

    public DIGQueryRoleAncestorsTranslator(String string, boolean bl) {
        super(bl ? null : "*", string, bl ? "*" : null);
        this.m_ancestors = bl;
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        if (this.m_ancestors) {
            Element element = dIGAdapter.createQueryElement(document, "rancestors");
            dIGAdapter.addClassDescription(element, triplePattern.getSubject());
        } else {
            Element element = dIGAdapter.createQueryElement(document, "rdescendants");
            dIGAdapter.addClassDescription(element, triplePattern.getObject());
        }
        return document;
    }

    public ExtendedIterator translateResponseHook(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        return this.translateRoleSetResponse(document, triplePattern, this.m_ancestors);
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return null;
    }

    public boolean checkSubject(Node node, DIGAdapter dIGAdapter, Model model) {
        return !this.m_ancestors || dIGAdapter.isRole(node, model);
    }

    public boolean checkObject(Node node, DIGAdapter dIGAdapter, Model model) {
        return this.m_ancestors || dIGAdapter.isRole(node, model);
    }
}

