/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.util.iterator.Map1;
import org.w3c.dom.Element;

public class DIGValueToNodeMapper
implements Map1 {
    public Object map1(Object object) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (element.getNodeName().equals("ival")) {
                return Node.createLiteral(element.getNodeValue(), null, XSDDatatype.XSDint);
            }
            if (element.getNodeName().equals("sval")) {
                return Node.createLiteral(element.getNodeValue(), null, XSDDatatype.XSDstring);
            }
            if (element.hasAttribute("name")) {
                return this.convertNameToNode(element.getAttribute("name"));
            }
        } else if (object instanceof String) {
            return this.convertNameToNode((String)object);
        }
        throw new IllegalArgumentException("Cannot map value " + object + " to an RDF node because it is not a recognised type");
    }

    private Object convertNameToNode(String string) {
        if (string.startsWith("anon:")) {
            String string2 = string.substring("anon:".length());
            return Node.createAnon(new AnonId(string2));
        }
        return Node.createURI(string);
    }
}

