/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RDFSRuleInfGraph
extends FBRuleInfGraph {
    protected HashMap dtRange = null;

    public RDFSRuleInfGraph(Reasoner reasoner, List list, Graph graph) {
        super(reasoner, list, graph);
    }

    public RDFSRuleInfGraph(Reasoner reasoner, List list, Graph graph, Graph graph2) {
        super(reasoner, list, graph, graph2);
    }

    public ValidityReport validate() {
        StandardValidityReport standardValidityReport = (StandardValidityReport)super.validate();
        HashMap hashMap = this.getDTRange();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            ExtendedIterator extendedIterator = this.find(null, node, null);
            while (extendedIterator.hasNext()) {
                Triple triple = (Triple)extendedIterator.next();
                standardValidityReport.add(this.checkLiteral(node, triple.getObject()));
            }
        }
        return standardValidityReport;
    }

    public ValidityReport.Report checkLiteral(Node node, Node node2) {
        List list = (List)this.getDTRange().get(node);
        if (list != null) {
            if (node2.isBlank()) {
                return null;
            }
            if (!node2.isLiteral()) {
                return new ValidityReport.Report(true, "dtRange", "Property " + node + " has a typed range but was given a non literal value " + node2);
            }
            LiteralLabel literalLabel = node2.getLiteral();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RDFDatatype rDFDatatype = (RDFDatatype)iterator.next();
                if (rDFDatatype.isValidLiteral(literalLabel)) continue;
                return new ValidityReport.Report(true, "dtRange", "Property " + node + " has a typed range " + rDFDatatype + "that is not compatible with " + node2);
            }
        }
        return null;
    }

    private HashMap getDTRange() {
        if (this.dtRange == null) {
            this.dtRange = new HashMap();
            ExtendedIterator extendedIterator = this.find(null, RDFS.range.asNode(), null);
            while (extendedIterator.hasNext()) {
                RDFDatatype rDFDatatype;
                Triple triple = (Triple)extendedIterator.next();
                Node node = triple.getSubject();
                Node node2 = triple.getObject();
                if (!node2.isURI() || (rDFDatatype = TypeMapper.getInstance().getTypeByName(node2.getURI())) == null) continue;
                ArrayList<RDFDatatype> arrayList = (ArrayList<RDFDatatype>)this.dtRange.get(node);
                if (arrayList == null) {
                    arrayList = new ArrayList<RDFDatatype>();
                    this.dtRange.put(node, arrayList);
                }
                arrayList.add(rDFDatatype);
            }
        }
        return this.dtRange;
    }
}

