/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import com.hp.hpl.jena.shared.WrappedIOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OWLExptRuleReasoner
extends FBRuleReasoner {
    protected static final String RULE_FILE = "etc/owl-fb.rules";
    protected static List ruleSet;
    protected static FBRuleInfGraph preload;
    private static final boolean USE_LP = true;
    protected static Log logger;

    public OWLExptRuleReasoner(ReasonerFactory reasonerFactory) {
        super(OWLExptRuleReasoner.loadRules(), reasonerFactory);
    }

    private OWLExptRuleReasoner(OWLExptRuleReasoner oWLExptRuleReasoner, InfGraph infGraph) {
        super(oWLExptRuleReasoner.rules, infGraph, oWLExptRuleReasoner.factory);
    }

    public static List loadRules() {
        if (ruleSet == null) {
            try {
                ruleSet = Rule.parseRules(Util.loadRuleParserFromResourceFile(RULE_FILE));
            }
            catch (WrappedIOException wrappedIOException) {
                throw new ReasonerException("Can't load rules file: etc/owl-fb.rules", wrappedIOException);
            }
        }
        return ruleSet;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph fBRuleInfGraph = this.makeInfGraph(this.rules, graph, true);
        fBRuleInfGraph.addPreprocessingHook(new OWLRuleTranslationHook());
        fBRuleInfGraph.prepare();
        return new OWLExptRuleReasoner(this, fBRuleInfGraph);
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        FBRuleInfGraph fBRuleInfGraph = null;
        InfGraph infGraph = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        List list = ((FBRuleInfGraph)infGraph).getRules();
        fBRuleInfGraph = this.makeInfGraph(list, infGraph, false);
        fBRuleInfGraph.addPreprocessingHook(new OWLRuleTranslationHook());
        fBRuleInfGraph.setDerivationLogging(this.recordDerivations);
        fBRuleInfGraph.setTraceOn(this.isTraceOn());
        fBRuleInfGraph.rebind(graph);
        return fBRuleInfGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfGraph getPreload() {
        Class clazz = OWLExptRuleReasoner.class;
        synchronized (clazz) {
            if (preload == null) {
                preload = this.makeInfGraph(this.rules, null, false);
                preload.prepare();
            }
            return preload;
        }
    }

    private FBRuleInfGraph makeInfGraph(List list, Graph graph, boolean bl) {
        if (bl) {
            return new FBRuleInfGraph(this, list, this.getPreload(), graph);
        }
        return new FBRuleInfGraph(this, list, graph);
    }

    static {
        logger = LogFactory.getLog((Class)OWLExptRuleReasoner.class);
    }
}

