/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import java.util.List;

public class DebugRules {
    public static final String ruleFile = "etc/temp.rules";
    public List ruleset;

    public DebugRules(String string) throws IOException {
        this.ruleset = Rule.parseRules(Util.loadRuleParserFromResourceFile(string));
    }

    public void run() {
        BasicForwardRuleReasoner basicForwardRuleReasoner = new BasicForwardRuleReasoner(this.ruleset);
        InfGraph infGraph = basicForwardRuleReasoner.bind(new GraphMem());
        System.out.println("Final graph state");
        ExtendedIterator extendedIterator = infGraph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            System.out.println(PrintUtil.print((Triple)extendedIterator.next()));
        }
    }

    public static void main(String[] stringArray) {
        try {
            DebugRules debugRules = new DebugRules(ruleFile);
            debugRules.run();
        }
        catch (Exception exception) {
            System.out.println("Problem: " + exception);
        }
    }
}

