/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.OWLResults;
import com.hp.hpl.jena.vocabulary.OWLTest;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WebOntTestHarness {
    public static boolean includeModified = false;
    public static boolean approvedOnly = true;
    public static boolean printProfile = false;
    Reasoner reasoner;
    Model testDefinitions = WebOntTestHarness.loadAllTestDefinitions();
    int testCount = 0;
    long lastTestDuration = 0L;
    int passCount = 0;
    Model testResults;
    Resource jena2;
    public static final String BASE_TESTDIR = "testing/wg/";
    public static String BASE_URI = "http://www.w3.org/2002/03owlt/";
    public static String BASE_RESULTS_URI = "http://jena.sourceforge.net/data/owl-results.rdf";
    public static final String[] TEST_DIRS = new String[]{"AllDifferent", "AllDistinct", "AnnotationProperty", "DatatypeProperty", "FunctionalProperty", "I3.2", "I3.4", "I4.1", "I4.5", "I4.6", "I5.1", "I5.2", "I5.21", "I5.24", "I5.26", "I5.3", "I5.5", "I5.8", "InverseFunctionalProperty", "Nothing", "Restriction", "SymmetricProperty", "Thing", "TransitiveProperty", "allValuesFrom", "amp-in-url", "cardinality", "complementOf", "datatypes", "differentFrom", "disjointWith", "distinctMembers", "equivalentClass", "equivalentProperty", "imports", "intersectionOf", "inverseOf", "localtests", "maxCardinality", "miscellaneous", "oneOf", "oneOfDistinct", "sameAs", "sameClassAs", "sameIndividualAs", "samePropertyAs", "someValuesFrom", "statement-entailment", "unionOf", "xmlbase", "description-logic"};
    public static final String[] BLOCKED_TESTS = new String[]{"http://www.w3.org/2002/03owlt/complementOf/Manifest001#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest901#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest903#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest902#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest904#test", "http://www.w3.org/2002/03owlt/oneOf/Manifest004#test", "http://www.w3.org/2002/03owlt/unionOf/Manifest001#test", "http://www.w3.org/2002/03owlt/unionOf/Manifest002#test", "http://www.w3.org/2002/03owlt/unionOf/Manifest003#test", "http://www.w3.org/2002/03owlt/unionOf/Manifest004#test", "http://www.w3.org/2002/03owlt/equivalentClass/Manifest006#test", "http://www.w3.org/2002/03owlt/equivalentClass/Manifest007#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest201#test", "http://www.w3.org/2002/03owlt/I5.8/Manifest004#test", "http://www.w3.org/2002/03owlt/I5.2/Manifest004#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest008#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest011#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest015#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest019#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest023#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest026#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest027#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest029#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest030#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest032#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest033#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest035#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest101#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest102#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest103#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest104#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest105#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest106#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest107#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest108#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest109#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest110#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest111#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest502#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest504#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest202#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest203#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest204#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest205#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest206#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest207#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest208#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest209#test", "http://www.w3.org/2002/03owlt/miscellaneous/Manifest010#test", "http://www.w3.org/2002/03owlt/miscellaneous/Manifest011#test", "http://www.w3.org/2002/03owlt/SymmetricProperty/Manifest002#test", "http://www.w3.org/2002/03owlt/Thing/Manifest005#test", "http://www.w3.org/2002/03owlt/TransitiveProperty/Manifest002#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest661#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest662#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest663#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest608#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest611#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest615#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest623#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest626#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest627#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest630#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest668#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest668#test"};
    public static final String[] STATUS_FLAGS = new String[]{"APPROVED", "PROPOSED"};

    public WebOntTestHarness() {
        this.reasoner = ReasonerRegistry.getOWLReasoner();
        this.initResults();
    }

    public static Model loadAllTestDefinitions() {
        System.out.print("Loading manifests ");
        System.out.flush();
        Model model = ModelFactory.createDefaultModel();
        int n = 0;
        for (int i = 0; i < TEST_DIRS.length; ++i) {
            File file = new File(BASE_TESTDIR + TEST_DIRS[i]);
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    if (string.startsWith("Manifest") && string.endsWith(".rdf")) {
                        return includeModified || !string.endsWith("-mod.rdf");
                    }
                    return false;
                }
            });
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                File file2 = new File(file, string);
                try {
                    model.read(new FileInputStream(file2), "file:" + file2);
                    if (++n % 8 != 0) continue;
                    System.out.print(".");
                    System.out.flush();
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("File not readable - " + fileNotFoundException);
                }
            }
        }
        System.out.println("loaded");
        return model;
    }

    public void initResults() {
        this.testResults = ModelFactory.createDefaultModel();
        this.jena2 = this.testResults.createResource(BASE_RESULTS_URI + "#jena2");
        this.jena2.addProperty(RDFS.comment, this.testResults.createLiteral("<a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://jena.sourceforce.net/\">Jena2</a> includes a rule-based inference engine for RDF processing, supporting both forward and backward chaining rules. Its OWL rule set is designed to provide sound but not complete instance resasoning for that fragment of OWL/Full limited to the OWL/lite vocabulary. Inparticular it does not support unionOf/complementOf.", true));
        this.jena2.addProperty(RDFS.label, "Jena2");
        this.testResults.setNsPrefix("results", "http://www.w3.org/2002/03owlt/resultsOntology#");
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "owl-results.rdf";
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        WebOntTestHarness webOntTestHarness = new WebOntTestHarness();
        webOntTestHarness.runTests();
        RDFWriter rDFWriter = webOntTestHarness.testResults.getWriter("RDF/XML-ABBREV");
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        rDFWriter.setProperty("showXmlDeclaration", "true");
        webOntTestHarness.testResults.setNsPrefix("", "http://www.w3.org/1999/xhtml");
        rDFWriter.write(webOntTestHarness.testResults, fileOutputStream, BASE_RESULTS_URI);
    }

    public void runTests() {
        System.out.println("Testing " + (approvedOnly ? "only APPROVED" : "APPROVED and PROPOSED"));
        System.out.println("Positive entailment: ");
        this.runTests(this.findTestsOfType(OWLTest.PositiveEntailmentTest));
        System.out.println("\nTrue tests: ");
        this.runTests(this.findTestsOfType(OWLTest.TrueTest));
        System.out.println("\nOWL for OWL tests: ");
        this.runTests(this.findTestsOfType(OWLTest.OWLforOWLTest));
        System.out.println("\nImport entailment tests: ");
        this.runTests(this.findTestsOfType(OWLTest.ImportEntailmentTest));
        System.out.println("\nInconsistency tests: ");
        this.runTests(this.findTestsOfType(OWLTest.InconsistencyTest));
        System.out.println("\nPassed " + this.passCount + " out of " + this.testCount);
    }

    public void runTests(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.runTest((Resource)iterator.next());
        }
    }

    public void runTest(String string) {
        this.runTest(this.testDefinitions.getResource(string));
    }

    public void runTest(Resource resource) {
        System.out.println("Running " + resource);
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.doRunTest(resource);
        }
        catch (Exception exception) {
            bl2 = true;
            System.out.print("\nException: " + exception);
            exception.printStackTrace();
        }
        ++this.testCount;
        if (bl) {
            System.out.print(this.testCount % 40 == 0 ? ".\n" : ".");
            System.out.flush();
            ++this.passCount;
        } else {
            System.out.println("\nFAIL: " + resource);
        }
        Resource resource2 = null;
        resource2 = bl2 ? OWLResults.FailingRun : (resource.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest) || resource.hasProperty(RDF.type, OWLTest.ConsistencyTest) ? (bl ? OWLResults.PassingRun : OWLResults.FailingRun) : (bl ? OWLResults.PassingRun : OWLResults.IncompleteRun));
        Resource resource3 = this.testResults.createResource().addProperty(RDF.type, OWLResults.TestRun).addProperty(RDF.type, resource2).addProperty(OWLResults.test, resource).addProperty(OWLResults.system, this.jena2);
    }

    public boolean doRunTest(Resource resource) throws IOException {
        if (resource.hasProperty(RDF.type, OWLTest.PositiveEntailmentTest) || resource.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest) || resource.hasProperty(RDF.type, OWLTest.OWLforOWLTest) || resource.hasProperty(RDF.type, OWLTest.ImportEntailmentTest) || resource.hasProperty(RDF.type, OWLTest.TrueTest)) {
            boolean bl = resource.hasProperty(RDF.type, OWLTest.ImportEntailmentTest);
            Model model = this.getDoc(resource, RDFTest.premiseDocument, bl);
            Model model2 = this.getDoc(resource, RDFTest.conclusionDocument);
            this.comprehensionAxioms(model, model2);
            long l = System.currentTimeMillis();
            InfGraph infGraph = this.reasoner.bind(model.getGraph());
            if (printProfile) {
                ((FBRuleInfGraph)infGraph).resetLPProfile(true);
            }
            Model model3 = ModelFactory.createModelForGraph(infGraph);
            boolean bl2 = this.testEntailment(model2.getGraph(), model3.getGraph());
            long l2 = System.currentTimeMillis();
            this.lastTestDuration = l2 - l;
            if (printProfile) {
                ((FBRuleInfGraph)infGraph).printLPProfile();
            }
            if (resource.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest)) {
                bl2 = !bl2;
            }
            return bl2;
        }
        if (resource.hasProperty(RDF.type, OWLTest.InconsistencyTest)) {
            Model model = this.getDoc(resource, RDFTest.inputDocument);
            long l = System.currentTimeMillis();
            InfGraph infGraph = this.reasoner.bind(model.getGraph());
            boolean bl = !infGraph.validate().isValid();
            long l3 = System.currentTimeMillis();
            this.lastTestDuration = l3 - l;
            return bl;
        }
        if (resource.hasProperty(RDF.type, OWLTest.ConsistencyTest)) {
            Model model = this.getDoc(resource, RDFTest.inputDocument);
            long l = System.currentTimeMillis();
            InfGraph infGraph = this.reasoner.bind(model.getGraph());
            boolean bl = infGraph.validate().isValid();
            long l4 = System.currentTimeMillis();
            this.lastTestDuration = l4 - l;
            return bl;
        }
        StmtIterator stmtIterator = resource.listProperties(RDF.type);
        while (stmtIterator.hasNext()) {
            System.out.println("Test type = " + stmtIterator.nextStatement().getObject());
        }
        throw new ReasonerException("Unknown test type");
    }

    public Model getDoc(Resource resource, Property property, boolean bl) throws IOException {
        if (bl) {
            OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
            StmtIterator stmtIterator = resource.listProperties(property);
            while (stmtIterator.hasNext()) {
                String string = ((Object)stmtIterator.nextStatement().getObject()).toString() + ".rdf";
                WebOntTestHarness.loadFile(string, ontModel);
            }
            return ontModel;
        }
        return this.getDoc(resource, property);
    }

    public Model getDoc(Resource resource, Property property) throws IOException {
        Model model = ModelFactory.createDefaultModel();
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            String string = ((Object)stmtIterator.nextStatement().getObject()).toString() + ".rdf";
            WebOntTestHarness.loadFile(string, model);
        }
        return model;
    }

    public static Model loadFile(String string, Model model) throws IOException {
        String string2 = "RDF/XML";
        if (string.endsWith(".nt")) {
            string2 = "N-TRIPLE";
        } else if (string.endsWith("n3")) {
            string2 = "N3";
        }
        String string3 = string;
        if (string3.startsWith(BASE_URI)) {
            string3 = string3.substring(BASE_URI.length());
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(BASE_TESTDIR + string3));
        model.read(bufferedReader, BASE_URI + string3, string2);
        return model;
    }

    public boolean testEntailment(Graph graph, Graph graph2) {
        QueryHandler queryHandler = graph2.queryHandler();
        Query query = WGReasonerTester.graphToQuery(graph);
        ExtendedIterator extendedIterator = queryHandler.prepareBindings(query, new Node[0]).executeBindings();
        return extendedIterator.hasNext();
    }

    public void comprehensionAxioms(Model model, Model model2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        HashMap<Object, Resource> hashMap = new HashMap<Object, Resource>();
        StmtIterator stmtIterator = model2.listStatements(null, RDF.type, OWL.Restriction);
        while (stmtIterator.hasNext()) {
            object5 = stmtIterator.nextStatement().getSubject();
            object4 = object5.listProperties(OWL.onProperty);
            while (object4.hasNext()) {
                object3 = (Resource)object4.nextStatement().getObject();
                object2 = object5.listProperties();
                while (object2.hasNext()) {
                    object = object2.nextStatement();
                    if (object.getPredicate().equals(OWL.onProperty)) continue;
                    Resource resource = model.createResource().addProperty(RDF.type, OWL.Restriction).addProperty(OWL.onProperty, (RDFNode)object3).addProperty(object.getPredicate(), object.getObject());
                    hashMap.put(object5, resource);
                }
            }
        }
        object5 = model2.listStatements(null, OWL.intersectionOf, (RDFNode)null);
        object4 = new ArrayList();
        while (object5.hasNext()) {
            object4.add(object5.next());
        }
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (Statement)object3.next();
            object = model.createResource().addProperty(RDF.type, OWL.Class).addProperty(OWL.intersectionOf, this.mapList(model, (Resource)object2.getObject(), hashMap));
            model2.remove((Statement)object2);
            model2.add(object2.getSubject(), OWL.equivalentClass, (RDFNode)object);
        }
        object3 = model2.listStatements(null, OWL.oneOf, (RDFNode)null);
        while (object3.hasNext()) {
            object2 = object3.nextStatement();
            object = model.createResource().addProperty(OWL.oneOf, object2.getObject());
        }
    }

    private Resource mapList(Model model, Resource resource, Map map) {
        if (((Object)resource).equals(RDF.nil)) {
            return RDF.nil;
        }
        Resource resource2 = (Resource)resource.getRequiredProperty(RDF.first).getObject();
        Resource resource3 = (Resource)resource.getRequiredProperty(RDF.rest).getObject();
        Resource resource4 = model.createResource();
        Resource resource5 = (Resource)map.get(resource2);
        if (resource5 == null) {
            resource5 = resource2;
        }
        resource4.addProperty(RDF.first, resource5);
        resource4.addProperty(RDF.rest, this.mapList(model, resource3, map));
        return resource4;
    }

    public List findTestsOfType(Resource resource) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        StmtIterator stmtIterator = this.testDefinitions.listStatements(null, RDF.type, resource);
        while (stmtIterator.hasNext()) {
            int n;
            Resource resource2 = stmtIterator.nextStatement().getSubject();
            boolean bl = true;
            Literal literal = (Literal)resource2.getProperty(RDFTest.status).getObject();
            if (approvedOnly) {
                bl = literal.getString().equals(STATUS_FLAGS[0]);
            } else {
                bl = false;
                for (n = 0; n < STATUS_FLAGS.length; ++n) {
                    if (!literal.getString().equals(STATUS_FLAGS[n])) continue;
                    bl = true;
                    break;
                }
            }
            for (n = 0; n < BLOCKED_TESTS.length; ++n) {
                if (!BLOCKED_TESTS[n].equals(((Object)resource2).toString())) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(resource2);
        }
        return arrayList;
    }
}

