/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator;

import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;
import java.util.Random;

public class RandomOrderIterator
extends WrappedIterator {
    private Random rnd = new Random();
    private Object[] buffer;
    int top;

    public RandomOrderIterator(int n, Iterator iterator) {
        super(iterator);
        this.buffer = new Object[n];
        this.top = 0;
        this.fill();
    }

    public boolean hasNext() {
        return this.top > 0;
    }

    public Object next() {
        int n = this.rnd.nextInt(this.top);
        Object object = this.buffer[n];
        --this.top;
        this.buffer[n] = this.buffer[this.top];
        this.fill();
        return object;
    }

    public void remove() {
        throw new UnsupportedOperationException("randomizing does not allow modification");
    }

    private void fill() {
        while (this.top < this.buffer.length && super.hasNext()) {
            this.buffer[this.top++] = super.next();
        }
    }
}

