/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

public class TestIteratorCollection
extends GraphTestBase {
    public TestIteratorCollection(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestIteratorCollection.class);
    }

    public void testEmptyToEmptySet() {
        TestIteratorCollection.assertEquals((Object)CollectionFactory.createHashedSet(), (Object)IteratorCollection.iteratorToSet(NullIterator.instance));
    }

    public void testSingletonToSingleSet() {
        TestIteratorCollection.assertEquals((Object)this.oneSet("single"), (Object)TestIteratorCollection.iteratorToSet(new SingletonIterator("single")));
    }

    public void testLotsToSet() {
        Object[] objectArray = new Object[]{"now", "is", "the", "time"};
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        TestIteratorCollection.assertEquals((Object)this.setLots(objectArray), (Object)IteratorCollection.iteratorToSet(iterator));
    }

    public void testCloseForSet() {
        this.testCloseForSet(new Object[0]);
        this.testCloseForSet(new Object[]{"one"});
        this.testCloseForSet(new Object[]{"to", "free", "for"});
        this.testCloseForSet(new Object[]{"another", "one", "plus", Boolean.FALSE});
        this.testCloseForSet(new Object[]{"the", "king", "is", "in", "his", "counting", "house"});
    }

    protected void testCloseForSet(Object[] objectArray) {
        final boolean[] blArray = new boolean[]{false};
        WrappedIterator wrappedIterator = new WrappedIterator(Arrays.asList(objectArray).iterator()){

            public void close() {
                super.close();
                blArray[0] = true;
            }
        };
        TestIteratorCollection.iteratorToSet(wrappedIterator);
        TestIteratorCollection.assertTrue((boolean)blArray[0]);
    }

    public void testEmptyToEmptyList() {
        TestIteratorCollection.assertEquals(new ArrayList(), (Object)IteratorCollection.iteratorToList(NullIterator.instance));
    }

    public void testSingletonToSingletonList() {
        TestIteratorCollection.assertEquals((Object)this.oneList("just one"), (Object)IteratorCollection.iteratorToList(new SingletonIterator("just one")));
    }

    public void testLotsToList() {
        List<Object> list = Arrays.asList("to", "be", "or", "not", "to", "be");
        TestIteratorCollection.assertEquals(list, (Object)IteratorCollection.iteratorToList(list.iterator()));
    }

    public void testCloseForList() {
        this.testCloseForList(new Object[0]);
        this.testCloseForList(new Object[]{"one"});
        this.testCloseForList(new Object[]{"to", "free", "for"});
        this.testCloseForList(new Object[]{"another", "one", "plus", Boolean.FALSE});
        this.testCloseForList(new Object[]{"the", "king", "is", "in", "his", "counting", "house"});
    }

    protected void testCloseForList(Object[] objectArray) {
        final boolean[] blArray = new boolean[]{false};
        WrappedIterator wrappedIterator = new WrappedIterator(Arrays.asList(objectArray).iterator()){

            public void close() {
                super.close();
                blArray[0] = true;
            }
        };
        TestIteratorCollection.iteratorToList(wrappedIterator);
        TestIteratorCollection.assertTrue((boolean)blArray[0]);
    }

    protected Set oneSet(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        return hashSet;
    }

    protected Set setLots(Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            hashSet.add(objectArray[i]);
        }
        return hashSet;
    }

    protected List oneList(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return arrayList;
    }
}

