/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.arp.test.MoreTests;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.xmloutput.test.TestXMLFeatures;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestMacEncodings
extends ModelTestBase {
    private static Log logger = LogFactory.getLog((Class)TestMacEncodings.class);
    private static boolean InUse = false;

    public TestMacEncodings(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(TestMacEncodings.class);
        testSuite.setName("Encodings (particular MacRoman etc.)");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "MacRoman");
            InUse = true;
        }
        catch (Exception exception) {
            InUse = false;
        }
        if (!InUse) {
            logger.warn((Object)"MacRoman not supported on this Java installation: mac encoding tests suppressed.");
            return testSuite;
        }
        testSuite.addTest((Test)new MoreTests("testARPMacRoman"));
        testSuite.addTest((Test)new MoreTests("testARPMacArabic"));
        return testSuite;
    }

    public void testXMLWriterMacRoman() throws IOException {
        if (!InUse) {
            return;
        }
        TestXMLFeatures.blockLogger();
        Model model = TestMacEncodings.createMemModel();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "MacRoman");
        model.write(outputStreamWriter, "RDF/XML");
        TestMacEncodings.assertTrue((boolean)TestXMLFeatures.unblockLogger());
    }

    public void testXMLWriteMacArabic() throws IOException {
        if (!InUse) {
            return;
        }
        TestXMLFeatures.blockLogger();
        Model model = TestMacEncodings.createMemModel();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "MacRoman");
        model.write(outputStreamWriter, "RDF/XML");
        TestMacEncodings.assertTrue((boolean)TestXMLFeatures.unblockLogger());
    }
}

