/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinRegistry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jena.cmdline.Arg;
import jena.cmdline.CommandLine;

public class RuleMap {
    public static List loadRules(String string, Map map) throws IOException {
        String string2 = string;
        if (string2.startsWith("file:///")) {
            string2 = File.separator + string2.substring(8);
        } else if (string2.startsWith("file:/")) {
            string2 = File.separator + string2.substring(6);
        } else if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        BufferedReader bufferedReader = FileUtils.openResourceFile(string2);
        return RuleMap.loadRules(bufferedReader, map);
    }

    public static List loadRules(BufferedReader bufferedReader, Map map) throws IOException {
        Rule.Parser parser = Rule.rulesParserFromReader(bufferedReader);
        List list = Rule.parseRules(parser);
        map.putAll(parser.getPrefixMap());
        return list;
    }

    public static void main(String[] stringArray) {
        try {
            Arg arg;
            CommandLine commandLine = new CommandLine();
            String string = "Usage:  RuleMap [-il inlang] [-ol outlang] [-d] rulefile infile";
            commandLine.setUsage(string);
            commandLine.add("il", true);
            commandLine.add("ol", true);
            commandLine.add("d", false);
            commandLine.process(stringArray);
            if (commandLine.items().size() != 2) {
                System.err.println(string);
                System.exit(1);
            }
            String string2 = (arg = commandLine.getArg("il")) == null ? null : arg.getValue();
            Model model = FileManager.get().loadModel((String)commandLine.items().get(1), string2);
            Arg arg2 = commandLine.getArg("ol");
            String string3 = arg2 == null ? "N3" : arg2.getValue();
            Arg arg3 = commandLine.getArg("d");
            boolean bl = arg3 != null;
            BuiltinRegistry.theRegistry.register(new Deduce());
            HashMap hashMap = new HashMap();
            List list = RuleMap.loadRules((String)commandLine.items().get(0), hashMap);
            GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(list);
            InfModel infModel = ModelFactory.createInfModel(genericRuleReasoner, model);
            infModel.prepare();
            infModel.setNsPrefixes(hashMap);
            PrintWriter printWriter = new PrintWriter(System.out);
            if (bl) {
                Model model2 = infModel.getDeductionsModel();
                model2.setNsPrefixes(hashMap);
                model2.setNsPrefixes(model);
                model2.write(printWriter, string3);
            } else {
                infModel.write(printWriter, string3);
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            System.err.println("An error occured: \n" + throwable);
            throwable.printStackTrace();
        }
    }

    static class Deduce
    extends BaseBuiltin {
        Deduce() {
        }

        public String getName() {
            return "deduce";
        }

        public int getArgLength() {
            return 3;
        }

        public void headAction(Node[] nodeArray, int n, RuleContext ruleContext) {
            if (!(ruleContext.getGraph() instanceof FBRuleInfGraph)) {
                throw new BuiltinException(this, ruleContext, "Only usable in FBrule graphs");
            }
            Triple triple = new Triple(nodeArray[0], nodeArray[1], nodeArray[2]);
            ((FBRuleInfGraph)ruleContext.getGraph()).addDeduction(triple);
        }
    }
}

