/*
 * Decompiled with CFR 0.152.
 */
package arq.cmd;

import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.DataSetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.parser.Parser;
import com.hp.hpl.jena.query.resultset.ResultSetTextFormatter;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QCmd
implements Serializable {
    static final long serialVersionUID = 7761L;
    private static Log log = LogFactory.getLog((Class)QCmd.class);
    private String queryString = null;
    private String queryFilename = null;
    private String inSyntax = null;
    private String defaultSyntax = null;
    private Query query = null;
    private String baseURI = null;
    private DataSet dataSet = null;
    private FileManager fileManager = null;
    private List graphURLs = null;
    private List namedGraphURLs = null;
    private String dataSyntax = null;
    private String outSyntax = null;
    private boolean lineNumbers = false;
    private String outputFormat = null;
    private int messageLevel = 0;
    public static final String FMT_NONE = "none";
    public static final String FMT_TUPLES = "tuples";
    public static final String FMT_TEXT = "text";
    public static final String FMT_RS_RDF = "rs/graph";
    public static final String FMT_RS_TEXT = "rs/text";
    public static final String FMT_RS_XML = "rs/xml";
    public static final String FMT_RDF_XML = "RDF/XML_ABBREV";
    public static final String FMT_RDF_N3 = "N3";
    public static final String FMT_RDF_NT = "N-TRIPLES";

    public void query() {
        this.queryFixDataSet();
        this.dumpData();
        this.queryFixOutputFormat();
        this.parseQuery();
        if (this.query == null) {
            return;
        }
        this.queryExec();
    }

    public void printQuery() {
        IndentedWriter indentedWriter = new IndentedWriter(System.out, this.lineNumbers);
        this.query.serialize(indentedWriter, this.outSyntax);
        indentedWriter.flush();
    }

    public void checkParse() {
        if (!Parser.canParse(this.outSyntax)) {
            return;
        }
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        this.query.serialize(indentedLineBuffer, this.outSyntax);
        String string = indentedLineBuffer.toString();
        try {
            Query query2 = QueryFactory.create(string, this.outSyntax);
            if (query2 == null) {
                return;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return;
        }
        catch (QueryException queryException) {
            System.out.println();
            System.out.println("**** Check failed : could not parse output query:: ");
            System.out.println("**** " + queryException.getMessage());
        }
    }

    public void doQuery(Query query2, QueryExecution queryExecution, String string) {
        if (query2.isSelectType()) {
            this.doSelectQuery(query2, queryExecution, string);
        }
        if (query2.isDescribeType()) {
            this.doDescribeQuery(query2, queryExecution, string);
        }
        if (query2.isConstructType()) {
            this.doConstructQuery(query2, queryExecution, string);
        }
        if (query2.isAskType()) {
            this.doAskQuery(query2, queryExecution, string);
        }
        queryExecution.close();
    }

    void queryFixDataSet() {
        try {
            if (this.graphURLs != null || this.namedGraphURLs != null) {
                this.dataSet = DataSetFactory.create(this.graphURLs, this.namedGraphURLs, this.fileManager, null);
            }
        }
        catch (Exception exception) {
            System.err.println("Error loading URL " + exception);
            System.exit(1);
        }
    }

    void queryFixOutputFormat() {
        if (this.outputFormat == null) {
            this.outputFormat = FMT_TEXT;
        }
    }

    public void parseQuery() {
        if (this.query != null) {
            return;
        }
        if (this.queryFilename != null && this.queryString != null) {
            System.err.println("Both query string and query file name given");
            return;
        }
        if (this.queryFilename == null && this.queryString == null) {
            System.err.println("No query string and no query file name given");
            return;
        }
        try {
            if (this.queryFilename != null) {
                this.query = QueryFactory.read(this.queryFilename, this.baseURI, this.inSyntax);
            }
            if (this.queryString != null) {
                if (this.inSyntax == null) {
                    this.inSyntax = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
                }
                this.query = QueryFactory.create(this.queryString, this.baseURI, this.inSyntax);
            }
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
            return;
        }
        catch (QueryException queryException) {
            System.err.println(queryException.getMessage());
            return;
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
            return;
        }
    }

    void queryExec() {
        try {
            QueryExecution queryExecution = QueryExecutionFactory.create(this.query, this.dataSet);
            if (this.dataSet == null && !this.query.hasDataSetDescription()) {
                System.err.println("Dataset not specified in query nor provided on command line.");
                return;
            }
            if (this.fileManager != null) {
                queryExecution.setFileManager(this.fileManager);
            }
            queryExecution.init();
            this.doQuery(this.query, queryExecution, this.outputFormat);
            queryExecution.close();
        }
        catch (ARQInternalErrorException aRQInternalErrorException) {
            System.err.println(aRQInternalErrorException.getMessage());
            if (aRQInternalErrorException.getCause() != null) {
                System.err.println("Cause:");
                aRQInternalErrorException.getCause().printStackTrace(System.err);
                System.err.println();
            }
            aRQInternalErrorException.printStackTrace(System.err);
        }
        catch (QueryException queryException) {
            System.err.println("Query Exeception: " + (Object)((Object)queryException));
            System.exit(9);
        }
        catch (Exception exception) {
            System.out.flush();
            exception.printStackTrace(System.err);
        }
    }

    void doSelectQuery(Query query2, QueryExecution queryExecution, String string) {
        Object object;
        Object object2;
        ResultSet resultSet = queryExecution.execSelect();
        resultSet = ResultSetFactory.makeRewindable(resultSet);
        boolean bl = false;
        if (string.equals(FMT_NONE)) {
            object2 = new ResultSetFormatter(resultSet, query2.getPrefixMapping());
            ((ResultSetFormatter)object2).consume();
            bl = true;
        }
        if (string.equals(FMT_RS_RDF)) {
            object2 = new ResultSetFormatter(resultSet, query2.getPrefixMapping());
            object = ((ResultSetFormatter)object2).toModel();
            RDFWriter rDFWriter = object.getWriter("TURTLE");
            object.setNsPrefix("rs", ResultSetVocab.getURI());
            rDFWriter.write((Model)object, (OutputStream)System.out, null);
            bl = true;
        }
        object2 = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        if (string.equals(FMT_RS_XML)) {
            object = new ResultSetFormatter(resultSet, query2.getPrefixMapping());
            ((ResultSetFormatter)object).outputAsXML(System.out);
            bl = true;
        }
        if (string.equals(FMT_RS_TEXT)) {
            object = new ResultSetFormatter(resultSet, query2.getPrefixMapping());
            ((ResultSetFormatter)object).outputAsText(System.out);
            bl = true;
        }
        object = new ResultSetFormatter(resultSet, query2.getPrefixMapping());
        if (string.equals(FMT_TEXT)) {
            ((ResultSetTextFormatter)object).printAll((PrintWriter)object2);
            bl = true;
        }
        if (string.equals(FMT_TUPLES)) {
            ((ResultSetTextFormatter)object).dump((PrintWriter)object2, true);
            bl = true;
        }
        if (!bl) {
            log.warn((Object)("Unknown format request: " + string));
        }
        if (object2 != null) {
            ((PrintWriter)object2).flush();
        }
    }

    void doDescribeQuery(Query query2, QueryExecution queryExecution, String string) {
        Model model = queryExecution.execDescribe();
        this.writeModel(model, string);
    }

    void doConstructQuery(Query query2, QueryExecution queryExecution, String string) {
        Model model = queryExecution.execConstruct();
        this.writeModel(model, string);
    }

    void writeModel(Model model, String string) {
        if (string.equals(FMT_NONE)) {
            return;
        }
        if (string.equals(FMT_TEXT)) {
            System.out.println("======== CONSTRUCT results ");
            model.write((OutputStream)System.out, FMT_RDF_N3, null);
            System.out.println("======== ");
            return;
        }
        if (string.equals(FMT_RDF_XML)) {
            model.write((OutputStream)System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (string.equals(FMT_RDF_N3)) {
            model.write((OutputStream)System.out, FMT_RDF_N3, null);
            return;
        }
        if (string.equals(FMT_RDF_NT)) {
            model.write((OutputStream)System.out, "N_TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + string);
    }

    void doAskQuery(Query query2, QueryExecution queryExecution, String string) {
        boolean bl = queryExecution.execAsk();
        if (!string.equals(FMT_NONE)) {
            System.out.println("Ask => " + (bl ? "Yes" : "No"));
        }
    }

    void dumpData() {
        boolean bl = false;
        if (bl) {
            if (this.dataSet == null) {
                System.out.println("Dataset is null");
            } else {
                System.out.println("DataSet: " + this.dataSet);
            }
        }
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public String getDataSyntax() {
        return this.dataSyntax;
    }

    public void setDataSyntax(String string) {
        this.dataSyntax = string;
    }

    public String getDefaultSyntax() {
        return this.defaultSyntax;
    }

    public void setDefaultSyntax(String string) {
        this.defaultSyntax = string;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public List getGraphURLs() {
        return this.graphURLs;
    }

    public void setGraphURLs(List list) {
        this.graphURLs = list;
    }

    public String getInSyntax() {
        return this.inSyntax;
    }

    public void setInSyntax(String string) {
        this.inSyntax = string;
    }

    public boolean isLineNumbers() {
        return this.lineNumbers;
    }

    public void setLineNumbers(boolean bl) {
        this.lineNumbers = bl;
    }

    public int getMessageLevel() {
        return this.messageLevel;
    }

    public void setMessageLevel(int n) {
        this.messageLevel = n;
    }

    public List getNamedGraphURLs() {
        return this.namedGraphURLs;
    }

    public void setNamedGraphURLs(List list) {
        this.namedGraphURLs = list;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String string) {
        this.outputFormat = string;
    }

    public String getOutSyntax() {
        return this.outSyntax;
    }

    public void setOutSyntax(String string) {
        this.outSyntax = string;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query2) {
        this.query = query2;
    }

    public String getQueryFilename() {
        return this.queryFilename;
    }

    public void setQueryFilename(String string) {
        this.queryFilename = string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }
}

