/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.core.DataSource1;
import com.hp.hpl.jena.query.core.QueryEngine;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryExecutionFactory {
    private static Log log = LogFactory.getLog((Class)QueryExecutionFactory.class);

    private QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query2) {
        return QueryExecutionFactory.create(query2, (QuerySolution)null);
    }

    public static QueryExecution create(Query query2, DataSet dataSet) {
        QueryEngine queryEngine = new QueryEngine(query2);
        if (dataSet != null) {
            queryEngine.setDataSet(dataSet);
        }
        return queryEngine;
    }

    public static QueryExecution create(Query query2, FileManager fileManager) {
        QueryEngine queryEngine = new QueryEngine(query2);
        if (fileManager != null) {
            queryEngine.setFileManager(fileManager);
        }
        return queryEngine;
    }

    public static QueryExecution create(Query query2, Model model) {
        return QueryExecutionFactory.create(query2, new DataSource1(model));
    }

    public static QueryExecution create(Query query2, Model model, QuerySolution querySolution) {
        return QueryExecutionFactory.create(query2, new DataSource1(model), querySolution);
    }

    public static QueryExecution create(Query query2, Graph graph) {
        return QueryExecutionFactory.create(query2, new DataSource1(graph));
    }

    public static QueryExecution create(Query query2, Graph graph, QuerySolution querySolution) {
        return QueryExecutionFactory.create(query2, new DataSource1(graph), querySolution);
    }

    public static QueryExecution create(Query query2, QuerySolution querySolution) {
        QueryEngine queryEngine = new QueryEngine(query2);
        if (querySolution != null) {
            queryEngine.setInitialBinding(querySolution);
        }
        return queryEngine;
    }

    public static QueryExecution create(Query query2, DataSet dataSet, QuerySolution querySolution) {
        QueryEngine queryEngine = new QueryEngine(query2);
        if (dataSet != null) {
            queryEngine.setDataSet(dataSet);
        }
        if (querySolution != null) {
            queryEngine.setInitialBinding(querySolution);
        }
        return queryEngine;
    }
}

