/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Binding0;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Binding {
    static Log log = LogFactory.getLog((Class)Binding.class);
    static Binding START = new Binding0();
    static boolean CHECKING = true;
    static boolean UNIQUE_NAMES_CHECK = true;
    Binding parent;
    List children = new ArrayList();

    protected Binding(Binding binding) {
        this.parent = binding;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public Iterator getChildren() {
        return this.children.listIterator();
    }

    public Binding getParent() {
        return this.parent;
    }

    private void addChild(Binding binding) {
        this.children.add(binding);
    }

    public void add(String string, Node node) {
        this.checkAdd(string, node);
        this.add1(string, node);
    }

    protected abstract void add1(String var1, Node var2);

    public Iterator names() {
        Iterator iterator = this.names1();
        if (this.parent != null) {
            iterator = new ConcatenatedIterator(this.parent.names(), iterator);
        }
        return iterator;
    }

    protected abstract Iterator names1();

    public boolean contains(String string) {
        if (this.contains1(string)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(string);
    }

    protected abstract boolean contains1(String var1);

    public Node get(String string) {
        Node node = this.get1(string);
        if (node != null) {
            return node;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.get(string);
    }

    protected abstract Node get1(String var1);

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        this.format1(stringBuffer);
        if (this.parent != null && (string = this.parent.toString()) != null && string.length() != 0) {
            stringBuffer.append(" -> ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void format1(StringBuffer stringBuffer) {
        if (this == START) {
            stringBuffer.append("Root");
            return;
        }
        boolean bl = true;
        Iterator iterator = this.names1();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!bl) {
                stringBuffer.append(" ");
            }
            Node node = this.get(string);
            String string2 = QueryPrintUtils.stringForObject(node);
            stringBuffer.append("( ?" + string + " = " + string2 + " )");
            bl = false;
        }
    }

    public String toString1() {
        StringBuffer stringBuffer = new StringBuffer();
        this.format1(stringBuffer);
        return stringBuffer.toString();
    }

    private void checkAdd(String string, Node node) {
        if (!CHECKING) {
            return;
        }
        if (node == null) {
            log.warn((Object)("check(" + string + ", " + node + "): null node value"));
        }
        if (UNIQUE_NAMES_CHECK && this.get(string) != null) {
            log.warn((Object)("check(" + string + ", " + node + "): Duplicate variable: " + string));
        }
        this.checkAdd1(string, node);
    }

    protected abstract void checkAdd1(String var1, Node var2);
}

