/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Binding0;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryIterNamedGraph;
import com.hp.hpl.jena.query.core.QueryIterRepeatApply;
import com.hp.hpl.jena.query.core.QueryIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementNamedGraph
extends Element
implements QueryIterRepeatApply.GeneratorBinding {
    static Log log = LogFactory.getLog((Class)ElementNamedGraph.class);
    Element element;
    Node sourceNode;

    public ElementNamedGraph(Element element) {
        this.element = element;
        this.sourceNode = null;
    }

    public ElementNamedGraph(Node node, Element element) {
        this.element = element;
        this.sourceNode = node;
    }

    public Element getElement() {
        return this.element;
    }

    public Node getSourceNode() {
        return this.sourceNode;
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, DataSet dataSet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Source: " + this.element));
        }
        Mark mark2 = new Mark(mark);
        mark2.incDepth();
        if (queryIterator == null) {
            return new QueryIterNamedGraph(mark2, new Binding0(), dataSet, this);
        }
        return new QueryIterRepeatApply(mark2, dataSet, queryIterator, this);
    }

    public QueryIterator makeIterator(Mark mark, Binding binding, DataSet dataSet) {
        return new QueryIterNamedGraph(mark, binding, dataSet, this);
    }

    protected void varsRequired(Set set) {
        this.element.varsRequired(set);
    }

    protected void varsBound(Set set) {
        if (this.sourceNode != null && this.sourceNode.isVariable()) {
            set.add(this.sourceNode.getName());
        }
        this.element.varsBound(set);
    }

    public void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2(Query query2) {
        this.sourceNode = ElementTriplePattern.fixUpNode(query2, this.sourceNode);
        if (this.element != null) {
            this.element.phase2(query2);
        }
    }
}

