/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.ReturnNumeric;
import com.hp.hpl.jena.query.junit.TestExpr;

public class TestExprNumeric
extends TestExpr {
    boolean isDouble = false;
    long rightAnswerLong;
    double rightAnswerDouble;

    public TestExprNumeric(String string, long l) {
        this(string, l, null, null);
    }

    public TestExprNumeric(String string, long l, Query query2, Binding binding) {
        super("Numeric test : " + string + " ", string, query2, binding, 100);
        this.rightAnswerLong = l;
        this.isDouble = false;
    }

    public TestExprNumeric(String string, double d) {
        this(string, d, null, null, 100);
    }

    public TestExprNumeric(String string, double d, Query query2, Binding binding, int n) {
        super("Numeric test : " + string + " ", string, query2, binding, n);
        this.rightAnswerDouble = d;
        this.isDouble = true;
    }

    void checkExpr(Expr expr) {
        TestExprNumeric.assertTrue((String)("Expression is not numeric: " + expr), (expr instanceof ReturnNumeric || expr instanceof NodeValue && ((NodeValue)expr).isNumber() ? 1 : 0) != 0);
    }

    void checkValue(Expr expr, NodeValue nodeValue) {
        if (!this.evalCorrect()) {
            TestExprNumeric.fail((String)(this.exprString + " => " + expr + " :: Expected eval exception but got: " + nodeValue));
        }
        if (!this.isDouble) {
            TestExprNumeric.assertEquals((String)("Parse " + this.exprString + " ==> " + expr + " "), (long)this.rightAnswerLong, (long)nodeValue.getInteger());
        } else {
            TestExprNumeric.assertEquals((String)("Parse " + this.exprString + " => " + expr + " "), (double)this.rightAnswerDouble, (double)nodeValue.getDouble(), (double)1.0E-4);
        }
    }

    void checkException(Expr expr, Exception exception) {
        if (!this.failureCorrect()) {
            TestExprNumeric.fail((String)(this.exprString + " => " + expr + " :: Exception: " + exception));
        }
    }
}

