/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.TemplateBase;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterARQ
extends FormatterBase {
    static final int INDENT = 2;
    static final boolean allowDoubles = true;
    public static boolean PATTERN_MARKERS = false;
    public static boolean PATTERN_FINAL_DOT = false;
    public static boolean GROUP_SEP_DOT = false;
    public static boolean UNION_MARKERS = true;
    public static boolean GROUP_UNNEST_ONE = false;
    public static boolean GRAPH_FIXED_INDENT = true;
    public static boolean UNSAID_FIXED_INDENT = true;

    public FormatterARQ(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        super(indentedWriter, serializationContext);
    }

    public static void format(IndentedWriter indentedWriter, SerializationContext serializationContext, Element element) {
        FormatterARQ formatterARQ = new FormatterARQ(indentedWriter, serializationContext);
        formatterARQ.startVisit();
        element.visit(formatterARQ);
        formatterARQ.finishVisit();
    }

    public static String asString(Element element) {
        SerializationContext serializationContext = new SerializationContext(null, null, null);
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterARQ.format(indentedLineBuffer.getIndentedWriter(), serializationContext, element);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.formatTriple(elementTriplePattern.getTriple());
        this.out.print(" # $$");
        this.out.newline();
    }

    public void visit(ElementBasePattern elementBasePattern) {
        boolean bl = true;
        if (PATTERN_MARKERS) {
            this.out.print("{ ");
            this.out.incIndent(2);
        }
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.out.print(" .");
                this.out.newline();
            }
            Triple triple = (Triple)listIterator.next();
            this.formatTriple(triple);
            bl = false;
        }
        if (PATTERN_MARKERS) {
            this.out.decIndent(2);
            this.out.print(" }");
        }
    }

    public void visit(ElementBlock elementBlock) {
        if (elementBlock.getDataSet() != null) {
            DataSet dataSet = elementBlock.getDataSet();
            this.out.print("DATASET ");
            this.out.incIndent(2);
            Iterator iterator = dataSet.listNames();
            if (iterator.hasNext()) {
                boolean bl = false;
                while (iterator.hasNext()) {
                    if (!bl) {
                        this.out.newline();
                    }
                    this.out.print("FROM <");
                    String string = (String)iterator.next();
                    this.out.print(string);
                    this.out.print(">");
                }
            }
            this.out.decIndent(2);
            this.out.newline();
        }
        if (elementBlock.getQueryElement() != null) {
            this.visitAsGroup((Element)elementBlock.getQueryElement());
        }
    }

    public void visit(ElementConstraints elementConstraints) {
        boolean bl = true;
        Iterator iterator = elementConstraints.constraints();
        while (iterator.hasNext()) {
            if (!bl) {
                this.out.print(" . ");
            }
            this.out.print("FILTER ");
            Constraint constraint = (Constraint)iterator.next();
            if (constraint instanceof Expr) {
                Expr expr = (Expr)constraint;
                FmtExprARQ fmtExprARQ = new FmtExprARQ(this.out, this.context);
                expr.visit(fmtExprARQ);
            } else {
                this.out.print(constraint.toString());
            }
            bl = false;
        }
    }

    public void visit(ElementUnion elementUnion) {
        if (elementUnion.getElements().size() == 1) {
            Element element = (Element)elementUnion.getElements().get(0);
            this.visitAsGroup(element);
            return;
        }
        if (UNION_MARKERS) {
            this.out.print("{");
            this.out.newline();
            this.out.pad();
        }
        this.out.incIndent(2);
        boolean bl = true;
        ListIterator listIterator = elementUnion.getElements().listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.out.decIndent(2);
                this.out.newline();
                this.out.print("UNION");
                this.out.newline();
                this.out.incIndent(2);
            }
            Element element = (Element)listIterator.next();
            this.visitAsGroup(element);
            bl = false;
        }
        this.out.decIndent(2);
        if (UNION_MARKERS) {
            this.out.newline();
            this.out.print("}");
        }
    }

    public void visit(ElementGroup elementGroup) {
        if (GROUP_UNNEST_ONE && elementGroup.getElements().size() == 1) {
            Element element = (Element)elementGroup.getElements().get(0);
            element.visit(this);
            return;
        }
        this.out.print("{");
        this.out.incIndent(2);
        int n = this.out.getRow();
        this.out.pad();
        boolean bl = true;
        ListIterator listIterator = elementGroup.getElements().listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                if (GROUP_SEP_DOT) {
                    this.out.print(" . ");
                }
                this.out.newline();
            }
            Element element = (Element)listIterator.next();
            element.visit(this);
            bl = false;
        }
        this.out.decIndent(2);
        int n2 = this.out.getRow();
        if (n != n2) {
            if (GROUP_SEP_DOT && !PATTERN_FINAL_DOT) {
                this.out.print(" .");
            }
            this.out.newline();
            this.out.print("}");
        } else {
            this.out.print(" }");
        }
    }

    public void visit(ElementOptional elementOptional) {
        this.out.print("OPTIONAL");
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(elementOptional.getElement());
        this.out.decIndent(2);
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        String string = "GRAPH ";
        int n = string.length();
        this.out.print(string);
        string = elementNamedGraph.getSourceNode() == null ? "*" : this.slotToString(this.context, elementNamedGraph.getSourceNode());
        this.out.print(string);
        n += string.length();
        if (GRAPH_FIXED_INDENT) {
            this.out.incIndent(2);
            this.out.newline();
        } else {
            this.out.print(" ");
            this.out.incIndent(++n);
        }
        this.visitAsGroup(elementNamedGraph.getElement());
        if (GRAPH_FIXED_INDENT) {
            this.out.decIndent(2);
        } else {
            this.out.decIndent(n);
        }
    }

    public void visit(ElementUnsaid elementUnsaid) {
        String string = "UNSAID ";
        int n = string.length();
        this.out.print(string);
        n += string.length();
        if (UNSAID_FIXED_INDENT) {
            this.out.incIndent(2);
            this.out.newline();
        } else {
            this.out.print(" ");
            this.out.incIndent(++n);
        }
        this.visitAsGroup(elementUnsaid.getElement());
        if (UNSAID_FIXED_INDENT) {
            this.out.decIndent(2);
        } else {
            this.out.decIndent(n);
        }
    }

    private void visitAsGroup(Element element) {
        boolean bl = element instanceof ElementGroup;
        if (!bl) {
            this.out.print("{ ");
            this.out.incIndent(2);
        }
        element.visit(this);
        if (!bl) {
            this.out.print(" }");
            this.out.incIndent(2);
        }
    }

    public void visit(TemplateGroup templateGroup) {
        this.out.print("{");
        this.out.incIndent(2);
        this.out.pad();
        boolean bl = true;
        Iterator iterator = templateGroup.templates();
        while (iterator.hasNext()) {
            TemplateBase templateBase = (TemplateBase)iterator.next();
            templateBase.visit(this);
            this.out.print(" .");
            this.out.newline();
            bl = false;
        }
        this.out.decIndent(2);
        this.out.print("}");
        this.out.newline();
    }

    public void visit(TemplateTriple templateTriple) {
        this.formatTriple(templateTriple.getTriple());
    }

    private void formatTriple(Triple triple) {
        this.out.print(this.slotToString(this.context, triple.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getObject()));
    }

    private String slotToString(SerializationContext serializationContext, Node node) {
        return QueryPrintUtils.stringForNode(node, serializationContext.getPrefixMap());
    }
}

