/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.junit.TestExprBoolean;
import com.hp.hpl.jena.query.junit.TestExprNumeric;
import com.hp.hpl.jena.query.junit.TestExprRDFTerm;
import com.hp.hpl.jena.query.junit.TestExprString;
import com.hp.hpl.jena.query.junit.TestExprURI;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestExpressionsARQ
extends TestSuite {
    static final String testSetName = "ARQ - Expressions";

    public static TestSuite suite() {
        TestExpressionsARQ testExpressionsARQ = new TestExpressionsARQ(testSetName);
        testExpressionsARQ.addStdTests(testExpressionsARQ);
        return testExpressionsARQ;
    }

    public TestExpressionsARQ(String string) {
        super(string);
    }

    public void addStdTests(TestSuite testSuite) {
        testSuite.addTest((Test)TestExpressionsARQ.numericValues());
        testSuite.addTest((Test)TestExpressionsARQ.numericExpr());
        testSuite.addTest((Test)TestExpressionsARQ.booleanValues());
        testSuite.addTest((Test)TestExpressionsARQ.booleanExpr());
        testSuite.addTest((Test)TestExpressionsARQ.DateTime());
        testSuite.addTest((Test)TestExpressionsARQ.rdfTermsURIs());
        testSuite.addTest((Test)TestExpressionsARQ.rdfTerms());
        testSuite.addTest((Test)TestExpressionsARQ.typedLiterals());
        testSuite.addTest((Test)TestExpressionsARQ.stringExpr());
        testSuite.addTest((Test)TestExpressionsARQ.builtinOps());
    }

    public static TestSuite numericValues() {
        TestSuite testSuite = new TestSuite("Numeric Values");
        testSuite.addTest((Test)new TestExprNumeric("7", 7L));
        testSuite.addTest((Test)new TestExprNumeric("-3", -3L));
        testSuite.addTest((Test)new TestExprNumeric("+2", 2L));
        return testSuite;
    }

    public static TestSuite numericExpr() {
        TestSuite testSuite = new TestSuite("Numeric Expressions");
        testSuite.addTest((Test)new TestExprNumeric("3+-4", -1L));
        testSuite.addTest((Test)new TestExprNumeric("3-+4", -1L));
        testSuite.addTest((Test)new TestExprNumeric("3+-4", -1L));
        testSuite.addTest((Test)new TestExprNumeric("3-(-4)", 7L));
        testSuite.addTest((Test)new TestExprNumeric("3+4+5", 12L));
        testSuite.addTest((Test)new TestExprNumeric("(3+4)+5", 12L));
        testSuite.addTest((Test)new TestExprNumeric("3+(4+5)", 12L));
        testSuite.addTest((Test)new TestExprNumeric("3*4+5", 17L));
        testSuite.addTest((Test)new TestExprNumeric("3*(4+5)", 27L));
        testSuite.addTest((Test)new TestExprNumeric("10-3-5", 2L));
        testSuite.addTest((Test)new TestExprNumeric("(10-3)-5", 2L));
        testSuite.addTest((Test)new TestExprNumeric("10-(3-5)", 12L));
        testSuite.addTest((Test)new TestExprNumeric("10-3+5", 12L));
        testSuite.addTest((Test)new TestExprNumeric("10-(3+5)", 2L));
        testSuite.addTest((Test)new TestExprNumeric("1.5 + 2.5", 4.0));
        testSuite.addTest((Test)new TestExprNumeric("1.5 + 2", 3.5));
        testSuite.addTest((Test)new TestExprNumeric("4111222333444", 4111222333444L));
        testSuite.addTest((Test)new TestExprNumeric("1234 + 4111222333444", 4111222334678L));
        testSuite.addTest((Test)new TestExprBoolean("4111222333444 > 1234", true));
        testSuite.addTest((Test)new TestExprBoolean("4111222333444 < 1234", false));
        testSuite.addTest((Test)new TestExprBoolean("1.5 < 2", true));
        testSuite.addTest((Test)new TestExprBoolean("1.5 > 2", false));
        testSuite.addTest((Test)new TestExprBoolean("1.5 < 2.3", true));
        testSuite.addTest((Test)new TestExprBoolean("1.5 > 2.3", false));
        return testSuite;
    }

    public static TestSuite booleanValues() {
        TestSuite testSuite = new TestSuite("Boolean Values");
        testSuite.addTest((Test)new TestExprBoolean("'true'^^<" + XSDDatatype.XSDboolean.getURI() + ">", true));
        testSuite.addTest((Test)new TestExprBoolean("'1'^^<" + XSDDatatype.XSDboolean.getURI() + ">", true));
        testSuite.addTest((Test)new TestExprBoolean("'false'^^<" + XSDDatatype.XSDboolean.getURI() + ">", false));
        testSuite.addTest((Test)new TestExprBoolean("'0'^^<" + XSDDatatype.XSDboolean.getURI() + ">", false));
        testSuite.addTest((Test)new TestExprBoolean("1", true));
        testSuite.addTest((Test)new TestExprBoolean("'foo'", true));
        testSuite.addTest((Test)new TestExprBoolean("0", false));
        testSuite.addTest((Test)new TestExprBoolean("''", false));
        testSuite.addTest((Test)new TestExprBoolean("!'junk'^^<urn:unknown>", 200));
        return testSuite;
    }

    public static TestSuite booleanExpr() {
        TestSuite testSuite = new TestSuite("Boolean Expressions");
        testSuite.addTest((Test)new TestExprBoolean("2 < 3", true));
        testSuite.addTest((Test)new TestExprBoolean("2 < 3", true));
        testSuite.addTest((Test)new TestExprBoolean("2 > 3", false));
        testSuite.addTest((Test)new TestExprBoolean("(2 < 3) && (3<4)", true));
        testSuite.addTest((Test)new TestExprBoolean("(2 < 3) && (3>=4)", false));
        testSuite.addTest((Test)new TestExprBoolean("(2 < 3) || (3>=4)", true));
        testSuite.addTest((Test)new TestExprBoolean("(2 < 3) || ?x > 2", true));
        testSuite.addTest((Test)new TestExprBoolean("(2 > 3) && ?x > 2", false));
        testSuite.addTest((Test)new TestExprBoolean("?x > 2 || (2 < 3)", 200));
        testSuite.addTest((Test)new TestExprBoolean("?x > 2 && (2 > 3)", 200));
        testSuite.addTest((Test)new TestExprBoolean("2 = 3", false));
        testSuite.addTest((Test)new TestExprBoolean("!(2 = 3)", true));
        testSuite.addTest((Test)new TestExprBoolean("'2' = 2", true, 200));
        testSuite.addTest((Test)new TestExprBoolean("2 = '2'", true, 200));
        testSuite.addTest((Test)new TestExprBoolean("2 < '3'", true, 200));
        testSuite.addTest((Test)new TestExprBoolean("'2' < 3", true, 200));
        testSuite.addTest((Test)new TestExprBoolean("\"fred\" != \"joe\"", true));
        testSuite.addTest((Test)new TestExprBoolean("\"fred\" = \"joe\"", false));
        testSuite.addTest((Test)new TestExprBoolean("\"fred\" = \"fred\"", true));
        testSuite.addTest((Test)new TestExprBoolean("\"fred\" = 'fred'", true));
        testSuite.addTest((Test)new TestExprBoolean("\"fred\" = 'fr\\ed'", true));
        testSuite.addTest((Test)new TestExprBoolean("\"fred\" != \"fred\"", false));
        return testSuite;
    }

    public static TestSuite DateTime() {
        TestSuite testSuite = new TestSuite("DateTime Expressions");
        String string = "'2005-02-25T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String string2 = "'2005-02-25T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String string3 = "'2005-01-01T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String string4 = "'2005-02-25T13:00:00Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        testSuite.addTest((Test)new TestExprBoolean(string + " = " + string2, true));
        testSuite.addTest((Test)new TestExprBoolean(string + " <= " + string2, true));
        testSuite.addTest((Test)new TestExprBoolean(string + " >= " + string2, true));
        testSuite.addTest((Test)new TestExprBoolean(string3 + " < " + string, true));
        testSuite.addTest((Test)new TestExprBoolean(string3 + " > " + string, false));
        testSuite.addTest((Test)new TestExprBoolean(string4 + " < " + string, false));
        testSuite.addTest((Test)new TestExprBoolean(string4 + " > " + string, true));
        return testSuite;
    }

    public static TestSuite rdfTermsURIs() {
        TestSuite testSuite = new TestSuite("RDF terms: QNames, URIs");
        Query query2 = QueryFactory.make();
        String string = "http://example.org/";
        String string2 = "http://example.org/dot#";
        String string3 = "http://select/";
        String string4 = "http://default/";
        String string5 = RDF.getURI();
        query2.setPrefix("ex", string);
        query2.setPrefix("rdf", RDF.getURI());
        query2.setPrefix("x.", string2);
        query2.setPrefix("", string4);
        query2.setPrefix("select", string3);
        testSuite.addTest((Test)new TestExprURI("ex:b", string + "b", query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("ex:b_", string + "b_", query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("ex:a_b", string + "a_b", query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("ex:", string, query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("x.:", string2, query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("rdf:_2", string5 + "_2", query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("rdf:__2", string5 + "__2", query2, null, 100));
        testSuite.addTest((Test)new TestExprURI(":b", string4 + "b", query2, null, 100));
        testSuite.addTest((Test)new TestExprURI(":", string4, query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("select:a", string3 + "a", query2, null, 100));
        testSuite.addTest((Test)new TestExprRDFTerm("_:", 200));
        testSuite.addTest((Test)new TestExprURI("ex:a.", string + "a.", query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("ex:a.a", string + "a.a", query2, null, 100));
        testSuite.addTest((Test)new TestExprURI("x.:a.a", string2 + "a.a", query2, null, 100));
        testSuite.addTest((Test)new TestExprNumeric("1:b", 1L));
        testSuite.addTest((Test)new TestExprURI("ex:2", string, query2, null, 100));
        return testSuite;
    }

    public static TestSuite rdfTerms() {
        TestSuite testSuite = new TestSuite("RDF terms: general");
        testSuite.addTest((Test)new TestExprBoolean("'fred'@en = 'fred'", false));
        testSuite.addTest((Test)new TestExprBoolean("'fred'@en != 'fred'", true));
        testSuite.addTest((Test)new TestExprBoolean("'chat'@en = 'chat'@fr", false));
        testSuite.addTest((Test)new TestExprBoolean("'chat'@en != 'chat'@fr", true));
        return testSuite;
    }

    public static TestSuite typedLiterals() {
        TestSuite testSuite = new TestSuite("Type Literals");
        testSuite.addTest((Test)new TestExprBoolean("'fred'^^<type1> = 'fred'^^<type1>", true));
        testSuite.addTest((Test)new TestExprBoolean("'fred'^^<type1> != 'joe'^^<type1>", false));
        testSuite.addTest((Test)new TestExprBoolean("'fred'^^<type1> = 'fred'^^<type2>", false));
        testSuite.addTest((Test)new TestExprBoolean("'fred'^^<type1> != 'fred'^^<type2>", false));
        testSuite.addTest((Test)new TestExprBoolean("'fred'^^<" + XSDDatatype.XSDstring.getURI() + "> = 'fred'", true));
        testSuite.addTest((Test)new TestExprBoolean("'fred'^^<type1> = 'fred'", false));
        testSuite.addTest((Test)new TestExprBoolean("'fred'^^<type1> != 'fred'", true));
        testSuite.addTest((Test)new TestExprNumeric("'21'^^<" + XSDDatatype.XSDinteger.getURI() + ">", 21L));
        testSuite.addTest((Test)new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> = 21", true));
        testSuite.addTest((Test)new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> = 22", false));
        testSuite.addTest((Test)new TestExprNumeric("'21'^^<" + XSDDatatype.XSDbyte.getURI() + ">", 21L));
        return testSuite;
    }

    public static TestSuite stringExpr() {
        TestSuite testSuite = new TestSuite("String Expressions");
        testSuite.addTest((Test)new TestExprBoolean("\"fred\\1\" = 'fred1'", true));
        testSuite.addTest((Test)new TestExprBoolean("\"fred2\" = 'fred\\2'", true));
        testSuite.addTest((Test)new TestExprBoolean("'fred\\\\3' != \"fred3\"", true));
        testSuite.addTest((Test)new TestExprBoolean("'urn:fred' = <urn:fred>", false));
        testSuite.addTest((Test)new TestExprBoolean("'urn:fred' != <urn:fred>", true));
        testSuite.addTest((Test)new TestExprBoolean("REGEX('aabbcc', 'abbc')", true));
        testSuite.addTest((Test)new TestExprBoolean("REGEX('aabbcc' , 'a..c')", true));
        testSuite.addTest((Test)new TestExprBoolean("REGEX('aabbcc' , '^aabb')", true));
        testSuite.addTest((Test)new TestExprBoolean("REGEX('aabbcc' , 'cc$')", true));
        testSuite.addTest((Test)new TestExprBoolean("! REGEX('aabbcc' , 'abbc')", false));
        testSuite.addTest((Test)new TestExprBoolean("REGEX('aa\\\\cc', '\\\\\\\\')", true));
        testSuite.addTest((Test)new TestExprBoolean("REGEX('aab*bcc', 'ab\\\\*bc')", true));
        testSuite.addTest((Test)new TestExprBoolean("REGEX('aabbcc',  'ab\\\\\\\\*bc')", true));
        testSuite.addTest((Test)new TestExprBoolean("REGEX('aabbcc', 'B.*B', 'i')", true));
        testSuite.addTest((Test)new TestExprBoolean("2 < 'fred'", 200));
        return testSuite;
    }

    public static TestSuite builtinOps() {
        TestSuite testSuite = new TestSuite("Builtin Operators");
        Query query2 = QueryFactory.make();
        BindingMap bindingMap = new BindingMap();
        bindingMap.add("a", Node.createLiteral((String)"A"));
        bindingMap.add("b", Node.createAnon());
        bindingMap.add("x", Node.createURI((String)"urn:x"));
        testSuite.addTest((Test)new TestExprString("datatype('fred')", 200));
        testSuite.addTest((Test)new TestExprBoolean("datatype('fred'^^<urn:foo>) = <urn:foo>", true));
        testSuite.addTest((Test)new TestExprBoolean("datatype('fred'^^<foo>) = <Foo>", false));
        testSuite.addTest((Test)new TestExprString("lang('fred'@en)", "en"));
        testSuite.addTest((Test)new TestExprString("lang('fred'@en-uk)", "en-uk"));
        testSuite.addTest((Test)new TestExprString("lang('fred')", ""));
        testSuite.addTest((Test)new TestExprBoolean("isURI(?x)", true, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isURI(?a)", false, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isURI(?b)", false, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isURI(?y)", false, bindingMap, 200));
        testSuite.addTest((Test)new TestExprBoolean("isURI(<urn:foo>)", true, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isURI('bar')", false, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isLiteral(?x)", false, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isLiteral(?a)", true, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isLiteral(?b)", false, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isLiteral(?y)", false, bindingMap, 200));
        testSuite.addTest((Test)new TestExprBoolean("isBlank(?x)", false, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isBlank(?a)", false, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isBlank(?b)", true, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("isBlank(?y)", false, bindingMap, 200));
        testSuite.addTest((Test)new TestExprBoolean("bound(?a)", true, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("bound(?b)", true, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("bound(?x)", true, bindingMap));
        testSuite.addTest((Test)new TestExprBoolean("bound(?y)", false, bindingMap));
        testSuite.addTest((Test)new TestExprString("str(<urn:x>)", "urn:x"));
        testSuite.addTest((Test)new TestExprString("str('')", ""));
        testSuite.addTest((Test)new TestExprString("str(15)", "15"));
        testSuite.addTest((Test)new TestExprString("str('15.20'^^<" + XSDDatatype.XSDdouble.getURI() + ">)", "15.20"));
        testSuite.addTest((Test)new TestExprString("str('lex'^^<x:unknown>)", "lex"));
        return testSuite;
    }
}

