/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.model.i;

import com.lastmileservices.rdf.util.Cache;
import edu.stanford.db.rdf.model.i.LiteralImpl;
import edu.stanford.db.rdf.model.i.ResourceImpl;
import edu.stanford.db.rdf.model.i.StatementImpl;
import edu.stanford.db.xml.util.QName;
import org.w3c.rdf.implementation.model.NodeFactoryImpl;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class Registry
implements NodeFactory {
    Cache rmap = new Cache(0, false);
    Cache lmap = new Cache(0, false);
    Cache smap = new Cache(0, false);
    int lastNodeID;
    String uniqueNS;

    public String create(String string) {
        String string2 = (String)this.smap.get(string);
        if (string2 == null) {
            string2 = string;
            this.smap.put(string2, string2);
        }
        return string2;
    }

    public Literal createLiteral(byte by) throws ModelException {
        return this.createLiteral(String.valueOf(by));
    }

    public Literal createLiteral(char c) throws ModelException {
        return this.createLiteral(String.valueOf(c));
    }

    public Literal createLiteral(double d) throws ModelException {
        return this.createLiteral(String.valueOf(d));
    }

    public Literal createLiteral(float f) throws ModelException {
        return this.createLiteral(String.valueOf(f));
    }

    public Literal createLiteral(int n) throws ModelException {
        return this.createLiteral(String.valueOf(n));
    }

    public Literal createLiteral(long l) throws ModelException {
        return this.createLiteral(String.valueOf(l));
    }

    public Literal createLiteral(String string) {
        Literal literal = (Literal)this.lmap.get(string);
        if (literal == null) {
            literal = new LiteralImpl(this.getUnusedNodeID(), string);
            this.lmap.put(string, literal);
        }
        return literal;
    }

    public Literal createLiteral(short s) throws ModelException {
        return this.createLiteral(String.valueOf(s));
    }

    public Literal createLiteral(boolean bl) throws ModelException {
        return this.createLiteral(String.valueOf(bl));
    }

    public Resource createOrdinal(int n) throws ModelException {
        if (n < 1) {
            throw new IllegalArgumentException("Attempt to construct invalid ordinal resource");
        }
        return this.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "_" + n);
    }

    public synchronized Resource createResource(QName qName) throws ModelException {
        Resource resource = (Resource)this.rmap.get(qName);
        if (resource == null) {
            resource = new ResourceImpl(this.getUnusedNodeID(), qName);
            this.rmap.put(qName, resource);
        }
        return resource;
    }

    public Resource createResource(String string) throws ModelException {
        string = this.create(string);
        return this.createResource(new QName(string));
    }

    public Resource createResource(String string, String string2) throws ModelException {
        string = this.create(string);
        string2 = this.create(string2);
        return this.createResource(new QName(string, string2));
    }

    public Statement createStatement(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        Resource resource3;
        if (resource instanceof Statement) {
            if (!(resource instanceof StatementImpl)) {
                resource3 = (Statement)resource;
                resource = this.createStatement(resource3.subject(), resource3.predicate(), resource3.object());
            }
        } else if (!(resource instanceof ResourceImpl)) {
            resource = this.createResource(resource.getNamespace(), resource.getLocalName());
        }
        if (!(resource2 instanceof ResourceImpl)) {
            resource2 = this.createResource(resource2.getNamespace(), resource2.getLocalName());
        }
        if (rDFNode instanceof Statement) {
            if (!(rDFNode instanceof StatementImpl)) {
                resource3 = (Statement)rDFNode;
                rDFNode = this.createStatement(resource3.subject(), resource3.predicate(), resource3.object());
            }
        } else if (rDFNode instanceof Resource) {
            if (!(rDFNode instanceof ResourceImpl)) {
                resource3 = (Resource)rDFNode;
                rDFNode = this.createResource(resource3.getNamespace(), resource3.getLocalName());
            }
        } else if (rDFNode instanceof Literal && !(rDFNode instanceof LiteralImpl)) {
            rDFNode = this.createLiteral(rDFNode.getLabel());
        }
        return resource != null && resource2 != null && rDFNode != null ? new StatementImpl(resource, resource2, rDFNode) : null;
    }

    public synchronized Resource createUniqueResource() throws ModelException {
        if (this.uniqueNS == null) {
            this.uniqueNS = String.valueOf(new NodeFactoryImpl().createUniqueResource().getLabel()) + "-";
            this.uniqueNS = this.create(this.uniqueNS);
        }
        int n = this.getUnusedNodeID();
        String string = this.create(String.valueOf(n));
        QName qName = new QName(this.uniqueNS, string);
        ResourceImpl resourceImpl = new ResourceImpl(n, qName);
        this.rmap.put(qName, resourceImpl);
        return resourceImpl;
    }

    public int getUnusedNodeID() {
        return this.lastNodeID++;
    }
}

