/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.model.i;

import org.w3c.rdf.digest.DigestException;
import org.w3c.rdf.digest.RDFDigestUtil;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class StatementImpl
implements Statement {
    static boolean DEBUG = false;
    Resource s;
    Resource p;
    RDFNode o;

    protected StatementImpl() {
    }

    public StatementImpl(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        this.s = resource;
        this.p = resource2;
        this.o = rDFNode;
        if (resource == null || resource2 == null || rDFNode == null) {
            throw new ModelException("Cannot create statement for " + resource + ", " + resource2 + ", " + rDFNode);
        }
    }

    public boolean equals(Object object) {
        if (DEBUG) {
            System.err.println("Testing equality of " + this + " vs " + object);
        }
        if (!(object instanceof Statement)) {
            return false;
        }
        try {
            Statement statement = (Statement)object;
            return this.s.equals(statement.subject()) && this.p.equals(statement.predicate()) && this.o.equals(statement.object());
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    public String getLabel() throws ModelException {
        try {
            return RDFDigestUtil.statementDigestToURI(RDFDigestUtil.computeStatementDigest(this));
        }
        catch (DigestException digestException) {
            throw new ModelException("Cannot compute statement URI: " + digestException);
        }
    }

    public String getLocalName() throws ModelException {
        return this.getLabel();
    }

    public String getNamespace() {
        return null;
    }

    public String getURI() throws ModelException {
        return this.getLabel();
    }

    public int hashCode() {
        return (this.s.hashCode() * 7 + this.p.hashCode()) * 7 + this.o.hashCode();
    }

    public String node2string(RDFNode rDFNode) {
        try {
            if (rDFNode instanceof Literal) {
                return "literal(\"" + rDFNode.getLabel() + "\")";
            }
            if (rDFNode instanceof Statement) {
                return rDFNode.toString();
            }
            if (rDFNode instanceof Resource) {
                return "\"" + rDFNode.getLabel() + "\"";
            }
            return String.valueOf(rDFNode);
        }
        catch (ModelException modelException) {
            return "<EXC: " + modelException + ">";
        }
    }

    public RDFNode object() {
        return this.o;
    }

    public Resource predicate() {
        return this.p;
    }

    public Resource subject() {
        return this.s;
    }

    public String toString() {
        return "triple(" + this.node2string(this.s) + ", " + this.node2string(this.p) + ", " + this.node2string(this.o) + ")";
    }
}

