/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.XSPNames;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatype;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Map;

public class DefaultRDFSDatatypeTestCase
extends AbstractJenaTestCase {
    public void testIsNumericDatatype() {
        DefaultRDFSDatatypeTestCase.assertTrue((boolean)this.owlModel.getXSDfloat().isNumericDatatype());
        DefaultRDFSDatatypeTestCase.assertTrue((boolean)this.owlModel.getXSDint().isNumericDatatype());
        DefaultRDFSDatatypeTestCase.assertTrue((boolean)this.owlModel.getXSDinteger().isNumericDatatype());
        DefaultRDFSDatatypeTestCase.assertTrue((boolean)this.owlModel.getXSDdecimal().isNumericDatatype());
        DefaultRDFSDatatypeTestCase.assertTrue((boolean)this.owlModel.getXSDdouble().isNumericDatatype());
        DefaultRDFSDatatypeTestCase.assertTrue((boolean)this.owlModel.getXSDlong().isNumericDatatype());
        DefaultRDFSDatatypeTestCase.assertTrue((boolean)this.owlModel.getXSDshort().isNumericDatatype());
        DefaultRDFSDatatypeTestCase.assertFalse((boolean)this.owlModel.getXSDboolean().isNumericDatatype());
        DefaultRDFSDatatypeTestCase.assertFalse((boolean)this.owlModel.getXSDstring().isNumericDatatype());
    }

    public void testGetBaseDatatype() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        RDFSDatatype datatype = this.owlModel.createRDFSDatatype("intOver18");
        RDFProperty subDatatypeOfProperty = XSPNames.getRDFProperty(this.owlModel, 0);
        datatype.setPropertyValue(subDatatypeOfProperty, this.owlModel.getXSDint());
        DefaultRDFSDatatypeTestCase.assertEquals((Object)this.owlModel.getXSDint(), (Object)datatype.getBaseDatatype());
    }

    public void testUserDefinedIntType() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        String name = this.owlModel.getNextAnonymousResourceName();
        RDFSDatatype datatype = this.owlModel.createRDFSDatatype(name);
        RDFProperty subDatatypeOfProperty = XSPNames.getRDFProperty(this.owlModel, 0);
        datatype.setPropertyValue(subDatatypeOfProperty, this.owlModel.getXSDint());
        RDFProperty minInclusiveProperty = XSPNames.getRDFProperty(this.owlModel, 4);
        datatype.setPropertyValue(minInclusiveProperty, new Integer(18));
        RDFProperty maxInclusiveProperty = XSPNames.getRDFProperty(this.owlModel, 6);
        datatype.setPropertyValue(maxInclusiveProperty, new Integer(24));
        DefaultRDFSDatatypeTestCase.assertEquals((Object)this.owlModel.createRDFSLiteral("24", this.owlModel.getXSDint()), (Object)datatype.getMaxInclusive());
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        property.setRange(datatype);
        DefaultRDFSDatatypeTestCase.assertEquals((String)"int[18,24]", (String)datatype.getBrowserText());
    }

    public void testParseClosedInterval() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        RDFProperty subDatatypeOfProperty = XSPNames.getRDFProperty(this.owlModel, 0);
        RDFProperty minInclusiveProperty = XSPNames.getRDFProperty(this.owlModel, 4);
        RDFProperty maxInclusiveProperty = XSPNames.getRDFProperty(this.owlModel, 6);
        String expression = "xsd:int[18,24]";
        Map map = DefaultRDFSDatatype.parse(this.owlModel, expression);
        DefaultRDFSDatatypeTestCase.assertEquals((int)3, (int)map.size());
        DefaultRDFSDatatypeTestCase.assertEquals((Object)this.owlModel.getXSDint(), map.get(subDatatypeOfProperty));
        DefaultRDFSDatatypeTestCase.assertEquals((Object)this.owlModel.createRDFSLiteral("18", this.owlModel.getXSDint()), map.get(minInclusiveProperty));
        DefaultRDFSDatatypeTestCase.assertEquals((Object)this.owlModel.createRDFSLiteral("24", this.owlModel.getXSDint()), map.get(maxInclusiveProperty));
    }

    public void testParseOpenedInterval() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        RDFProperty subDatatypeOfProperty = XSPNames.getRDFProperty(this.owlModel, 0);
        RDFProperty maxExclusiveProperty = XSPNames.getRDFProperty(this.owlModel, 5);
        String expression = "xsd:int(..,24)";
        Map map = DefaultRDFSDatatype.parse(this.owlModel, expression);
        DefaultRDFSDatatypeTestCase.assertEquals((int)2, (int)map.size());
        DefaultRDFSDatatypeTestCase.assertEquals((Object)this.owlModel.getXSDint(), map.get(subDatatypeOfProperty));
        DefaultRDFSDatatypeTestCase.assertEquals((Object)this.owlModel.createRDFSLiteral("24", this.owlModel.getXSDint()), map.get(maxExclusiveProperty));
    }
}

