/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions.triple;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.ui.actions.triple.TripleAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TripleActionManager {
    private static Map map = new HashMap();

    public static void addTripleActionsToMenu(Triple triple, Adder adder) {
        List actions = TripleActionManager.getTripleActions();
        ArrayList<TripleAction> menubarActions = new ArrayList<TripleAction>();
        for (TripleAction action : actions) {
            if (!action.isSuitable(triple)) continue;
            menubarActions.add(action);
        }
        Collections.sort(menubarActions, new Comparator(){

            public int compare(Object o, Object o1) {
                TripleAction actionA = (TripleAction)o;
                TripleAction actionB = (TripleAction)o1;
                String a = actionA.getName();
                String b = actionB.getName();
                return a.compareTo(b);
            }
        });
        for (TripleAction action : menubarActions) {
            adder.addTripleAction(action);
        }
    }

    private static List getTripleActions() {
        ArrayList<TripleAction> actions = new ArrayList<TripleAction>();
        Class[] classes = TripleActionManager.getTripleActionClasses();
        int i = 0;
        while (i < classes.length) {
            Class aClass = classes[i];
            TripleAction action = TripleActionManager.getTripleAction(aClass);
            actions.add(action);
            ++i;
        }
        return actions;
    }

    public static TripleAction getTripleAction(Class clazz) {
        TripleAction action = (TripleAction)map.get(clazz);
        if (action == null) {
            try {
                action = (TripleAction)clazz.newInstance();
                map.put(clazz, action);
            }
            catch (Exception ex) {
                System.err.println("[TripleActionManager] Fatal Error: Could not create TripleAction for " + clazz);
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
        return action;
    }

    public static Class[] getTripleActionClasses() {
        ArrayList clses = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"TripleAction", (String)"True"));
        return clses.toArray(new Class[0]);
    }

    public static interface Adder {
        public void addTripleAction(TripleAction var1);
    }
}

