/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.rdflist.tests;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.components.rdflist.RDFListComponent;

public class RDFListComponentTestCase
extends AbstractJenaTestCase {
    public void testRDFListEmpty() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setRange(this.owlModel.getRDFListClass());
        OWLIndividual individual = cls.createOWLIndividual("Individual");
        RDFListComponent comp = new RDFListComponent(property);
        comp.setSubject(individual);
        RDFListComponentTestCase.assertEquals((int)0, (int)comp.getRowCount());
        RDFListComponentTestCase.assertSize(0, comp.getSelection());
        RDFListComponentTestCase.assertTrue((boolean)comp.isAddEnabled());
        RDFListComponentTestCase.assertTrue((boolean)comp.isCreateEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isDeleteEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isRemoveEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isMoveDownEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isMoveUpEnabled());
    }

    public void testRDFListSingleEntry() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setRange(this.owlModel.getRDFListClass());
        OWLIndividual individual = cls.createOWLIndividual("Individual");
        RDFListComponent comp = new RDFListComponent(property);
        comp.setSubject(individual);
        RDFListComponentTestCase.assertEquals((int)0, (int)comp.getRowCount());
        RDFList list = this.owlModel.createRDFList();
        individual.setPropertyValue(property, list);
        comp.valuesChanged();
        RDFListComponentTestCase.assertEquals((int)0, (int)comp.getRowCount());
        list.append(individual);
        RDFListComponentTestCase.assertEquals((int)1, (int)comp.getRowCount());
        RDFListComponentTestCase.assertTrue((boolean)comp.isAddEnabled());
        RDFListComponentTestCase.assertTrue((boolean)comp.isCreateEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isDeleteEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isRemoveEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isMoveDownEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isMoveUpEnabled());
        comp.setSelectedRow(0);
        RDFListComponentTestCase.assertTrue((boolean)comp.isAddEnabled());
        RDFListComponentTestCase.assertTrue((boolean)comp.isCreateEnabled());
        RDFListComponentTestCase.assertTrue((boolean)comp.isDeleteEnabled());
        RDFListComponentTestCase.assertTrue((boolean)comp.isRemoveEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isMoveDownEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isMoveUpEnabled());
    }

    public void testImportedRDFList() throws Exception {
        this.loadRemoteOntology("importListProperty.owl");
        OWLIndividual individual = this.owlModel.getOWLIndividual("imp:Individual");
        RDFListComponentTestCase.assertNotNull((Object)individual);
        RDFProperty property = this.owlModel.getRDFProperty("imp:property");
        RDFListComponentTestCase.assertNotNull((Object)property);
        RDFListComponent comp = new RDFListComponent(property);
        comp.setSubject(individual);
        RDFListComponentTestCase.assertEquals((int)0, (int)comp.getRowCount());
        RDFListComponentTestCase.assertSize(0, comp.getSelection());
        RDFListComponentTestCase.assertFalse((boolean)comp.isAddEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isCreateEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isDeleteEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isRemoveEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isMoveDownEnabled());
        RDFListComponentTestCase.assertFalse((boolean)comp.isMoveUpEnabled());
    }
}

