/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.jena;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.OWLFilesPlugin;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractOWLFilesWizardPage
extends WizardPage {
    private boolean callback = false;
    public static final String EXTENSION = "owl";
    private URIField owlFileURIField;
    private OWLFilesPlugin plugin;
    private static String HELP_TEXT = "<P>Please specify either a local file or the URL of an online ontology which you want to load.  You can search for a <B>file</B> using the Browse button in the upper right corner.  For <B>online ontologies</B>, you could copy and paste the URL from an internet browser.</P>";

    public AbstractOWLFilesWizardPage(Wizard wizard, OWLFilesPlugin aPlugin, String name) {
        super(name, wizard);
        this.plugin = aPlugin;
        this.owlFileURIField = new URIField("OWL file name or URL", null, EXTENSION, "Web Ontology Language (OWL) files");
        this.owlFileURIField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                AbstractOWLFilesWizardPage.this.updateSetPageComplete();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(8, 8));
        panel.add("North", (Component)this.owlFileURIField);
        panel.add("South", OWLUI.createHelpPanel(HELP_TEXT, "How to load an OWL Ontology?", 160));
        this.add(panel);
        this.updateSetPageComplete();
    }

    protected OWLFilesPlugin getPlugin() {
        return this.plugin;
    }

    public String getProjectPath() {
        String path = "";
        if (path == null) {
            if (this.owlFileURIField != null) {
                URI absoluteURI = this.owlFileURIField.getAbsoluteURI();
                if (absoluteURI != null) {
                    path = absoluteURI.toString();
                    path = FileUtilities.replaceExtension((String)path, (String)".pprj");
                } else {
                    path = "";
                }
            } else {
                path = "";
            }
        }
        return path;
    }

    private URI getURI(String str) {
        try {
            return new URI(str);
        }
        catch (Exception ex) {
            return URIUtilities.createURI((String)str);
        }
    }

    public void onFinish() {
        this.plugin.setLanguage("RDF/XML-ABBREV");
        URI uri = this.owlFileURIField.getAbsoluteURI();
        String owlFileURI = uri != null ? uri.toString() : "";
        this.plugin.setFile(owlFileURI);
    }

    protected void onProjectPathChange(String oldPath, String newPath) {
        if (newPath != null) {
            this.updatePath(newPath);
        }
    }

    private void updatePath(String newPath) {
        if (this.getProjectPath() != null && !this.callback) {
            String language = "RDF/XML-ABBREV";
            String ext = "." + JenaKnowledgeBaseFactory.getExtension(language);
            int index = newPath.lastIndexOf(47);
            if (index >= 0) {
                newPath = newPath.substring(index + 1);
            }
            String name = new File(newPath).getName();
            String fieldText = FileUtilities.replaceExtension((String)name, (String)ext);
            this.owlFileURIField.setURI(this.getURI(fieldText));
        }
    }

    public boolean validateContents() {
        if (this.owlFileURIField.getRelativeURI() == null) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog((Component)((Object)this), "You need to enter a valid URI for an OWL/RDF file.\nCurrently, these URIs should not contain spaces.");
            return false;
        }
        return true;
    }

    private void updateSetPageComplete() {
        this.setPageComplete(this.owlFileURIField.getRelativeURI() != null);
    }
}

