/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport;

import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.EmptyImportWizard;
import edu.stanford.smi.protegex.owl.ui.wizard.OWLWizard;
import edu.stanford.smi.protegex.owl.ui.wizard.OWLWizardPage;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LocalFileWizardPage
extends OWLWizardPage {
    private File localFile;
    private OWLModel owlModel;
    private static final String HELP_TEXT = "<p>Please specify a local file where the new empty ontology will be stored.</p><p>(This local file will be added to the project ontology repository so that the import is redirected to it)</p>";

    public LocalFileWizardPage(OWLWizard wizard, OWLModel owlModel) {
        super("Local File", wizard);
        this.owlModel = owlModel;
        this.createUI();
        this.setPageComplete(this.validateData());
    }

    private String getSuggestedPath() {
        URI uri;
        String path = "";
        if (this.owlModel.getProject() != null && (uri = this.owlModel.getProject().getProjectURI()) != null) {
            File f = new File(new File(uri).getParentFile(), "Import" + System.currentTimeMillis() / 1000L + ".owl");
            path = f.toString();
        }
        return path;
    }

    private boolean validateData() {
        return this.localFile != null;
    }

    private void createUI() {
        final FileField fileField = new FileField("Local file", this.getSuggestedPath(), "owl", "OWL Files");
        fileField.setDialogType(1);
        fileField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LocalFileWizardPage.this.localFile = fileField.getFilePath();
                LocalFileWizardPage.this.setPageComplete(LocalFileWizardPage.this.validateData());
            }
        });
        this.localFile = fileField.getFilePath();
        this.getContentComponent().add((Component)fileField, "North");
        this.setHelpText("Specifying a local file", HELP_TEXT);
    }

    public void onFinish() {
        super.onFinish();
        ((EmptyImportWizard)this.getWizard()).setLocalFile(this.localFile);
    }
}

