/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainWidget;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class AddClassToDomainAction
extends ResourceSelectionAction {
    private OWLDomainWidget widget;

    public AddClassToDomainAction(OWLDomainWidget widget) {
        super("Specialise Domain", OWLIcons.getAddIcon("PrimitiveClass"), true);
        this.widget = widget;
    }

    public static boolean canAdd(RDFProperty property) {
        OWLModel owlModel;
        if (!(property instanceof OWLProperty) && !ProfilesManager.isFeatureSupported(owlModel = property.getOWLModel(), OWLProfiles.Union_Classes)) {
            ArrayList dd = new ArrayList(property.getUnionDomain());
            dd.remove(owlModel.getOWLThingClass());
            if (dd.size() > 0) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "In pure RDF, rdf:Properties can only have one class in their\n(union) domain.  You need to select a different language profile.");
                return false;
            }
        }
        return true;
    }

    private String checkCls(Cls cls) {
        RDFProperty property;
        if (cls instanceof RDFSNamedClass && (property = (RDFProperty)this.widget.getEditedResource()).getUnionDomain().contains(cls)) {
            return "The class " + cls.getBrowserText() + " is already in the domain.";
        }
        return null;
    }

    public void resourceSelected(RDFResource resource) {
        RDFSClass cls = (RDFSClass)resource;
        RDFProperty property = (RDFProperty)this.widget.getEditedResource();
        OWLModel owlModel = cls.getOWLModel();
        if (!AddClassToDomainAction.canAdd(property)) {
            return;
        }
        String msg = this.checkCls(cls);
        if (msg == null) {
            try {
                try {
                    owlModel.beginTransaction("Add " + resource.getBrowserText() + " to the domain of " + property.getBrowserText());
                    if (property.getDirectOwnSlotValue(owlModel.getSlot(":DIRECT-DOMAIN")) == null) {
                        property.addUnionDomainClass(cls);
                        for (RDFProperty superSlot : property.getSuperproperties(true)) {
                            for (RDFSClass domainCls : superSlot.getUnionDomain()) {
                                if (cls.getSuperclasses(true).contains(domainCls) || property.getUnionDomain().contains(domainCls)) continue;
                                property.addUnionDomainClass(domainCls);
                            }
                        }
                    } else {
                        if (owlModel.getOWLThingClass().getUnionDomainProperties().contains(property)) {
                            property.removeUnionDomainClass(owlModel.getOWLThingClass());
                        }
                        property.addUnionDomainClass(cls);
                    }
                    property.synchronizeDomainAndRangeOfInverse();
                }
                catch (Exception ex) {
                    OWLUI.handleError(owlModel, ex);
                }
            }
            finally {
                owlModel.endTransaction();
            }
        } else {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, msg, "Invalid domain");
        }
    }

    public Collection getSelectableResources() {
        OWLModel owlModel = (OWLModel)this.widget.getKnowledgeBase();
        RDFProperty property = (RDFProperty)this.widget.getEditedResource();
        HashSet<Cls> clses = null;
        if (property.getSuperpropertyCount() > 0) {
            clses = new HashSet<Cls>();
            for (Slot superSlot : property.getSuperproperties(true)) {
                for (Cls domainCls : superSlot.getDirectDomain()) {
                    if (!(domainCls instanceof RDFSNamedClass)) continue;
                    clses.add(domainCls);
                    for (Cls subCls : domainCls.getSubclasses()) {
                        if (!(subCls instanceof RDFSNamedClass)) continue;
                        clses.add(subCls);
                    }
                }
            }
            clses.removeAll(property.getUnionDomain());
        } else {
            clses = owlModel.getUserDefinedRDFSNamedClasses();
            clses.add(owlModel.getOWLThingClass());
            clses.removeAll(property.getUnionDomain());
        }
        Object[] cs = clses.toArray();
        Arrays.sort(cs, new FrameComparator());
        return clses;
    }

    public Collection pickResources() {
        OWLModel owlModel = (OWLModel)this.widget.getKnowledgeBase();
        RDFProperty property = (RDFProperty)this.widget.getEditedResource();
        HashSet<OWLNamedClass> rootClasses = new HashSet<OWLNamedClass>();
        rootClasses.add(owlModel.getOWLThingClass());
        if (property.getSuperpropertyCount() > 0) {
            for (RDFProperty superProp : property.getSuperproperties(true)) {
                rootClasses.addAll(superProp.getUnionDomain());
            }
            if (rootClasses.size() > 1) {
                rootClasses.remove(owlModel.getOWLThingClass());
            }
        }
        return ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)this.widget), owlModel, rootClasses, "Select named class(es) to add");
    }
}

