/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.widget.FormsTab;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLFormsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;

public class EditTypeFormAction
extends AbstractAction {
    private RDFResource resource;

    public EditTypeFormAction(RDFResource resource) {
        super("Edit form of type...", OWLIcons.getImageIcon("EditTypeForm"));
        this.resource = resource;
    }

    public void actionPerformed(ActionEvent e) {
        if (EditTypeFormAction.ensureMetaClsVisible(this.resource)) {
            RDFSClass directType = this.resource.getProtegeType();
            ProjectView currentProjectView = ProtegeUI.getProjectView(directType.getProject());
            JTabbedPane tabbedPane = new JTabbedPane();
            Component[] comps = currentProjectView.getComponents();
            int i = 0;
            while (i < comps.length) {
                Component c = comps[i];
                if (c instanceof JTabbedPane) {
                    tabbedPane = (JTabbedPane)c;
                }
                ++i;
            }
            FormsTab formsTab = (FormsTab)currentProjectView.getTabByClassName(OWLFormsTab.class.getName());
            if (formsTab == null) {
                formsTab = (FormsTab)currentProjectView.getTabByClassName(FormsTab.class.getName());
            }
            if (formsTab != null) {
                tabbedPane.setSelectedComponent((Component)formsTab);
                formsTab.setSelectedCls((Cls)directType);
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.resource.getOWLModel(), "The Forms tab is not visible.\nPlease use Project/Configure...");
            }
        }
    }

    static boolean ensureMetaClsVisible(RDFResource instance) {
        RDFSClass directType = instance.getProtegeType();
        RDFSNamedClass propertyMetaclass = instance.getOWLModel().getRDFPropertyClass();
        OWLModel owlModel = instance.getOWLModel();
        if (!directType.isVisible() || directType.isSubclassOf(propertyMetaclass) && !propertyMetaclass.isVisible()) {
            String message = "The class " + directType.getBrowserText() + " is not visible.\nShould it be made visible now?";
            if (ProtegeUI.getModalDialogFactory().showConfirmDialog(owlModel, message, "Confirm")) {
                if (directType.getName().equals("owl:Class")) {
                    owlModel.getRDFSNamedClassClass().setVisible(true);
                }
                if (directType.isSubclassOf(owlModel.getRDFSNamedClass("rdf:Property"))) {
                    owlModel.getRDFPropertyClass().setVisible(true);
                    owlModel.getOWLObjectPropertyClass().setVisible(true);
                    owlModel.getOWLDatatypePropertyClass().setVisible(true);
                }
                directType.setVisible(true);
                ProtegeUI.reloadUI(owlModel.getProject());
                return true;
            }
            return false;
        }
        return true;
    }
}

