/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter;
import java.io.PrintWriter;

public class Basic
extends BaseXMLWriter {
    static String RDFNS = RDF.getURI();
    private String space;
    private boolean blockLiterals = false;

    void writeBody(Model model, PrintWriter printWriter, String string, boolean bl) {
        this.space = "";
        for (int i = 0; i < this.tab; ++i) {
            this.space = this.space + " ";
        }
        this.writeRDFHeader(model, printWriter);
        this.writeRDFStatements(model, printWriter);
        this.writeRDFTrailer(printWriter, string);
        printWriter.flush();
    }

    protected void writeSpace(PrintWriter printWriter) {
        printWriter.print(this.space);
    }

    private void writeRDFHeader(Model model, PrintWriter printWriter) {
        String string = this.xmlnsDecl();
        NsIterator nsIterator = model.listNameSpaces();
        printWriter.print("<" + this.rdfEl("RDF") + string);
        if (null != this.xmlBase && this.xmlBase.length() > 0) {
            printWriter.print("\n  xml:base=" + this.qq(this.xmlBase));
        }
        printWriter.println(" >");
    }

    protected void writeRDFStatements(Model model, PrintWriter printWriter) {
        ResIterator resIterator = model.listSubjects();
        while (resIterator.hasNext()) {
            this.writeRDFStatements(model, resIterator.nextResource(), printWriter);
        }
    }

    protected void writeRDFTrailer(PrintWriter printWriter, String string) {
        printWriter.println("</" + this.rdfEl("RDF") + ">");
    }

    protected void writeRDFStatements(Model model, Resource resource, PrintWriter printWriter) {
        StmtIterator stmtIterator = model.listStatements(resource, null, (RDFNode)null);
        this.writeDescriptionHeader(resource, printWriter);
        while (stmtIterator.hasNext()) {
            this.writePredicate(stmtIterator.nextStatement(), printWriter);
        }
        this.writeDescriptionTrailer(resource, printWriter);
    }

    protected void writeDescriptionHeader(Resource resource, PrintWriter printWriter) {
        printWriter.print(this.space + "<" + this.rdfEl("Description") + " ");
        this.writeResourceId(resource, printWriter);
        printWriter.println(">");
    }

    protected void writePredicate(Statement statement, PrintWriter printWriter) {
        Property property = statement.getPredicate();
        RDFNode rDFNode = statement.getObject();
        printWriter.print(this.space + this.space + "<" + this.startElementTag(property.getNameSpace(), property.getLocalName()));
        if (rDFNode instanceof Resource) {
            printWriter.print(" ");
            this.writeResourceReference((Resource)rDFNode, printWriter);
            printWriter.println("/>");
        } else {
            this.writeLiteral((Literal)rDFNode, printWriter);
            printWriter.println("</" + this.endElementTag(property.getNameSpace(), property.getLocalName()) + ">");
        }
    }

    void unblockAll() {
        this.blockLiterals = false;
    }

    void blockRule(Resource resource) {
        if (((Object)resource).equals(RDFSyntax.parseTypeLiteralPropertyElt)) {
            this.blockLiterals = true;
        } else {
            logger.warn("Cannot block rule <" + resource.getURI() + ">");
        }
    }

    protected void writeDescriptionTrailer(Resource resource, PrintWriter printWriter) {
        printWriter.println(this.space + "</" + this.rdfEl("Description") + ">");
    }

    protected void writeDescriptionTrailer(PrintWriter printWriter) {
        this.writeDescriptionTrailer(null, printWriter);
    }

    protected void writeResourceId(Resource resource, PrintWriter printWriter) {
        if (resource.isAnon()) {
            printWriter.print(this.rdfAt("nodeID") + "=" + this.q(this.anonId(resource)));
        } else {
            printWriter.print(this.rdfAt("about") + "=" + this.qq(this.relativize(resource.getURI())));
        }
    }

    protected void writeResourceReference(Resource resource, PrintWriter printWriter) {
        if (resource.isAnon()) {
            printWriter.print(this.rdfAt("nodeID") + "=" + this.q(this.anonId(resource)));
        } else {
            printWriter.print(this.rdfAt("resource") + "=" + this.qq(this.relativize(resource.getURI())));
        }
    }

    protected void writeLiteral(Literal literal, PrintWriter printWriter) {
        String string = literal.getLanguage();
        String string2 = literal.getLexicalForm();
        if (!string.equals("")) {
            printWriter.print(" xml:lang=" + this.q(string));
        }
        if (literal.getWellFormed() && !this.blockLiterals) {
            printWriter.print(" " + this.rdfAt("parseType") + "=" + this.q("Literal") + ">");
            printWriter.print(string2);
        } else {
            String string3 = literal.getDatatypeURI();
            if (string3 != null) {
                printWriter.print(" " + this.rdfAt("datatype") + "=" + this.qq(string3));
            }
            printWriter.print(">");
            printWriter.print(Util.substituteEntitiesInElementContent(string2));
        }
    }
}

