/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslatorFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public abstract class AbstractReasonerTask
implements ReasonerTask {
    private static transient Logger log = Log.getLogger(AbstractReasonerTask.class);
    private ArrayList listeners;
    private int progress;
    private boolean progressIndeterminate;
    private String description;
    private String message;
    private ReasonerTaskEvent evt = new ReasonerTaskEvent(this);
    private boolean abortTask = false;
    private DIGTranslator translator;

    public AbstractReasonerTask(ProtegeOWLReasoner protegeOWLReasoner) {
        this.listeners = new ArrayList();
        this.translator = DIGTranslatorFactory.getInstance().createTranslator();
        try {
            DIGReasonerIdentity id = protegeOWLReasoner.getDIGReasoner().getIdentity();
            this.translator.setReasonerIdentity(id);
        }
        catch (DIGReasonerException e) {
            Log.emptyCatchBlock((Throwable)e);
        }
    }

    protected DIGTranslator getTranslator() {
        return this.translator;
    }

    protected void setProgress(int progress) {
        this.progress = progress;
        this.fireProgressChangedEvent();
    }

    protected void setProgressIndeterminate(boolean b) {
        this.progressIndeterminate = b;
        this.fireProgressIndeterminateChnaged();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isProgressIndeterminate() {
        return this.progressIndeterminate;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
        this.fireDescriptionChangedEvent();
    }

    protected void setMessage(String message) {
        this.message = message;
        this.fireMessageChangedEvent();
    }

    public String getMessage() {
        return this.message;
    }

    protected void setTaskCompleted() {
        this.fireTaskCompletedEvent();
    }

    protected void setTaskFailed() {
        this.fireTaskFailedEvent();
    }

    public void addTaskListener(ReasonerTaskListener lsnr) {
        for (WeakReference wr : this.listeners) {
            if (!wr.get().equals(lsnr)) continue;
            return;
        }
        lsnr.addedToTask(new ReasonerTaskEvent(this));
        this.listeners.add(new WeakReference<ReasonerTaskListener>(lsnr));
    }

    public void removeTaskListener(ReasonerTaskListener lsnr) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            WeakReference wr = (WeakReference)it.next();
            if (wr.get() == null || !wr.get().equals(lsnr)) continue;
            wr.clear();
            it.remove();
        }
    }

    protected void fireProgressChangedEvent() {
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ReasonerTaskListener lsnr = (ReasonerTaskListener)((WeakReference)it.next()).get();
            if (lsnr == null) continue;
            lsnr.progressChanged(this.evt);
        }
    }

    protected void fireProgressIndeterminateChnaged() {
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ReasonerTaskListener lsnr = (ReasonerTaskListener)((WeakReference)it.next()).get();
            if (lsnr == null) continue;
            lsnr.progressIndeterminateChanged(this.evt);
        }
    }

    protected void fireDescriptionChangedEvent() {
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ReasonerTaskListener lsnr = (ReasonerTaskListener)((WeakReference)it.next()).get();
            if (lsnr == null) continue;
            lsnr.descriptionChanged(this.evt);
        }
    }

    protected void fireMessageChangedEvent() {
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ReasonerTaskListener lsnr = (ReasonerTaskListener)((WeakReference)it.next()).get();
            if (lsnr == null) continue;
            lsnr.messageChanged(this.evt);
        }
    }

    protected void fireTaskFailedEvent() {
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ReasonerTaskListener lsnr = (ReasonerTaskListener)((WeakReference)it.next()).get();
            if (lsnr == null) continue;
            lsnr.taskFailed(this.evt);
        }
    }

    protected void fireTaskCompletedEvent() {
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            ReasonerTaskListener lsnr = (ReasonerTaskListener)((WeakReference)it.next()).get();
            if (lsnr == null) continue;
            lsnr.taskCompleted(this.evt);
        }
    }

    protected void postLogRecord(ReasonerLogRecord logRecord) {
        ReasonerLogger.getInstance().postLogRecord(logRecord);
    }

    public void setRequestAbort() {
        this.abortTask = true;
    }

    public boolean isRequestAbort() {
        return this.abortTask;
    }

    protected void doAbortCheck() throws DIGReasonerException {
        if (this.isRequestAbort()) {
            this.setProgressIndeterminate(false);
            this.setTaskFailed();
            throw new DIGReasonerException("Task aborted");
        }
    }
}

