/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.BooleanResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import org.w3c.dom.Document;

public class IsDisjointToTask
extends AbstractReasonerTask
implements BooleanResultReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;
    private OWLClass cls1;
    private OWLClass cls2;
    private boolean result = false;

    public IsDisjointToTask(ProtegeOWLReasoner protegeOWLReasoner, OWLClass cls1, OWLClass cls2) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.cls1 = cls1;
        this.cls2 = cls2;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        Document asksDoc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().createDisjointQuery(asksDoc, "q0", this.cls1, this.cls2);
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(asksDoc);
        DIGQueryResponse response = (DIGQueryResponse)this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc).next();
        this.result = response.getBoolean();
        this.setProgress(1);
        this.setTaskCompleted();
    }

    public boolean getResult() {
        return this.result;
    }
}

