/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;

public class UpdateInconsistentClassesTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public UpdateInconsistentClassesTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeOWLReasoner.getKnowledgeBase()).size();
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecord parentRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Check concept consistency", null);
        this.postLogRecord(parentRecord);
        this.setProgress(0);
        TimeDifference td = new TimeDifference();
        this.setDescription("Computing inconsistent concepts");
        this.setMessage("Building reasoner query...");
        td.markStart();
        Document asksDoc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        Collection namedClses = ReasonerUtil.getInstance().getNamedClses(kb);
        for (OWLNamedClass curNamedCls : namedClses) {
            this.getTranslator().createSatisfiableQuery(asksDoc, curNamedCls.getName(), curNamedCls);
            this.doAbortCheck();
        }
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to build query = " + td, parentRecord));
        td.markStart();
        this.setMessage("Querying reasoner for inconsistent concepts...");
        this.setProgressIndeterminate(true);
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(asksDoc);
        this.setProgressIndeterminate(false);
        this.doAbortCheck();
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to send and receive from reasoner = " + td, parentRecord));
        this.setMessage("Updating Protege-OWL...");
        td.markStart();
        kb.setGenerateEventsEnabled(false);
        kb.beginTransaction("Compute and mark inconsistent classes");
        Iterator responseIt = this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc);
        ReasonerLogRecord icParentRecord = null;
        while (responseIt.hasNext()) {
            this.doAbortCheck();
            DIGQueryResponse response = (DIGQueryResponse)responseIt.next();
            String queryID = response.getID();
            OWLNamedClass curNamedCls = kb.getOWLNamedClass(queryID);
            if (curNamedCls != null) {
                if (response.getBoolean()) {
                    curNamedCls.setClassificationStatus(1);
                    curNamedCls.removeInferredSuperclass(curNamedCls.getOWLModel().getOWLNamedClass("owl:Nothing"));
                } else {
                    if (icParentRecord == null) {
                        icParentRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Inconsistent concepts", parentRecord);
                        this.postLogRecord(icParentRecord);
                    }
                    this.postLogRecord(ReasonerLogRecordFactory.getInstance().createConceptConsistencyLogRecord(curNamedCls, false, icParentRecord));
                    curNamedCls.setClassificationStatus(2);
                    curNamedCls.addInferredSuperclass(curNamedCls.getOWLModel().getOWLNamedClass("owl:Nothing"));
                }
            }
            this.setProgress(this.getProgress() + 1);
        }
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + td, parentRecord));
        this.setTaskCompleted();
        kb.endTransaction();
        kb.setGenerateEventsEnabled(true);
    }
}

