/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.tests;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.logging.Level;

public class SatisfiabilityTests
extends AbstractJenaTestCase {
    public void testOWLThingSatisfiableQuery() {
        try {
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            SatisfiabilityTests.assertTrue((boolean)reasoner.isSatisfiable(this.owlModel.getOWLThingClass(), null));
        }
        catch (DIGReasonerException e) {
            SatisfiabilityTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void testOWLNothingSatisfiableQuery() {
        try {
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            SatisfiabilityTests.assertFalse((boolean)reasoner.isSatisfiable(this.owlModel.getOWLNothing(), null));
        }
        catch (DIGReasonerException e) {
            SatisfiabilityTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void testConceptSatisfiabilityQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
            clsC.addSuperclass(clsA);
            clsC.addSuperclass(clsB);
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            SatisfiabilityTests.assertTrue((boolean)reasoner.isSatisfiable(clsC, null));
            clsA.addDisjointClass(clsB);
            SatisfiabilityTests.assertFalse((boolean)reasoner.isSatisfiable(clsC, null));
        }
        catch (DIGReasonerException e) {
            SatisfiabilityTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void testIntersectionSatisfiableQuery() {
        try {
            OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
            OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
            OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
            ProtegeOWLReasoner reasoner = ReasonerManager.getInstance().createReasoner(this.owlModel);
            OWLClass[] clses = new OWLClass[]{clsA, clsB, clsC};
            SatisfiabilityTests.assertTrue((boolean)reasoner.isIntersectionSatisfiable(clses, null));
            clsA.addDisjointClass(clsB);
            SatisfiabilityTests.assertFalse((boolean)reasoner.isIntersectionSatisfiable(clses, null));
        }
        catch (DIGReasonerException e) {
            SatisfiabilityTests.fail((String)e.getMessage());
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }
}

