/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.ui.inspector;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.inference.ui.icons.InferenceIcons;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerPreferences;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ReasonerInspectorPanel
extends JPanel {
    private DIGReasonerIdentity reasonerIdentity;
    private OWLModel kb;
    private JLabel reasonerDesc;
    private JTree tree;
    private DefaultMutableTreeNode languageNode;
    private DefaultMutableTreeNode tellNode;
    private DefaultMutableTreeNode askNode;
    private DefaultMutableTreeNode rootNode;
    private Action refreshAction = new AbstractAction("Refresh"){

        public void actionPerformed(ActionEvent e) {
            ReasonerInspectorPanel.this.refreshReasonerIdentity();
        }
    };

    public ReasonerInspectorPanel(OWLModel kb) {
        this.kb = kb;
        this.reasonerDesc = new JLabel("Press refresh to collect information.");
        this.rootNode = new DefaultMutableTreeNode("Supported Elements");
        this.languageNode = new DefaultMutableTreeNode("Language");
        this.rootNode.add(this.languageNode);
        this.tellNode = new DefaultMutableTreeNode("Tell");
        this.rootNode.add(this.tellNode);
        this.askNode = new DefaultMutableTreeNode("Ask");
        this.rootNode.add(this.askNode);
        this.tree = new JTree(this.rootNode);
        this.tree.setRowHeight(0);
        this.tree.setCellRenderer(new Renderer());
        JScrollPane sp = new JScrollPane(this.tree);
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.reasonerDesc, "North");
        this.add((Component)sp, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)new JButton(this.refreshAction), "East");
        this.add((Component)buttonPanel, "South");
        this.setPreferredSize(new Dimension(400, 400));
    }

    protected void refreshReasonerIdentity() {
        try {
            ProtegeOWLReasoner protegeOWLReasoner = ReasonerManager.getInstance().getReasoner(this.kb);
            protegeOWLReasoner.setURL(ReasonerPreferences.getInstance().getReasonerURL());
            this.languageNode.removeAllChildren();
            this.tellNode.removeAllChildren();
            this.askNode.removeAllChildren();
            boolean connected = protegeOWLReasoner.isConnected();
            if (connected) {
                this.reasonerIdentity = protegeOWLReasoner.getDIGReasoner().getIdentity();
                this.reasonerDesc.setText(String.valueOf(this.reasonerIdentity.getName()) + " " + this.reasonerIdentity.getVersion() + " (" + this.reasonerIdentity.getMessage() + ")");
                Iterator it = this.reasonerIdentity.getSupportedLanguageElements().iterator();
                while (it.hasNext()) {
                    this.languageNode.add(new DefaultMutableTreeNode(it.next()));
                }
                it = this.reasonerIdentity.getSupportedTellElements().iterator();
                while (it.hasNext()) {
                    this.tellNode.add(new DefaultMutableTreeNode(it.next()));
                }
                it = this.reasonerIdentity.getSupportedAskElements().iterator();
                while (it.hasNext()) {
                    this.askNode.add(new DefaultMutableTreeNode(it.next()));
                }
                this.repaint();
            } else {
                this.reasonerDesc.setText("No reasoner detected");
            }
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private Icon icon = InferenceIcons.getReasonerInspectorTreeIcon();

        private Renderer() {
        }

        public Icon getDefaultOpenIcon() {
            return this.icon;
        }

        public Icon getDefaultClosedIcon() {
            return this.icon;
        }

        public Icon getDefaultLeafIcon() {
            return this.icon;
        }

        public Icon getOpenIcon() {
            return this.icon;
        }

        public Icon getClosedIcon() {
            return this.icon;
        }

        public Icon getLeafIcon() {
            return this.icon;
        }
    }
}

