/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.importer.tests.AbstractOWLImporterTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;

public class ImportFacetOverloadsTestCase
extends AbstractOWLImporterTestCase {
    public void testImportAllRestrictionAtDatatypeSlot() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty oldSlot = this.owlModel.createOWLDatatypeProperty("hasValue");
        oldSlot.setDomain(oldCls);
        oldCls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)oldSlot, this.owlModel.getXSDint()));
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportFacetOverloadsTestCase.assertEquals((Object)ValueType.ANY, (Object)newSlot.getValueType());
        ImportFacetOverloadsTestCase.assertEquals((Object)ValueType.INTEGER, (Object)newCls.getTemplateSlotValueType(newSlot));
    }

    public void testImportAllRestrictionAtObjectSlot() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty oldSlot = this.owlModel.createOWLObjectProperty("hasValue");
        oldSlot.setDomain(oldCls);
        oldCls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)oldSlot, oldCls));
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportFacetOverloadsTestCase.assertSize(1, newCls.getTemplateSlotAllowedClses(newSlot));
        ImportFacetOverloadsTestCase.assertEquals((Object)newCls, newCls.getTemplateSlotAllowedClses(newSlot).iterator().next());
    }

    public void testImportHasRestrictionAtStringSlot() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        RDFResource oldInstance = oldCls.createInstance("Instance");
        OWLDatatypeProperty oldSlot = this.owlModel.createOWLDatatypeProperty("hasValue", this.owlModel.getXSDstring());
        oldSlot.setDomain(oldCls);
        oldCls.addSuperclass(this.owlModel.createOWLHasValue(oldSlot, "Value"));
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportFacetOverloadsTestCase.assertSize(1, newCls.getTemplateSlotValues(newSlot));
        ImportFacetOverloadsTestCase.assertEquals((Object)"Value", newCls.getTemplateSlotValues(newSlot).iterator().next());
    }

    public void testImportHasRestrictionAtObjectSlot() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        RDFResource oldInstance = oldCls.createInstance("Instance");
        OWLObjectProperty oldSlot = this.owlModel.createOWLObjectProperty("hasValue");
        oldSlot.setDomain(oldCls);
        oldCls.addSuperclass(this.owlModel.createOWLHasValue(oldSlot, oldInstance));
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        Instance newInstance = kb.getInstance(oldInstance.getName());
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportFacetOverloadsTestCase.assertSize(1, newCls.getTemplateSlotValues(newSlot));
        ImportFacetOverloadsTestCase.assertEquals((Object)newInstance, newCls.getTemplateSlotValues(newSlot).iterator().next());
    }

    public void testImportMaxCardiRestriction() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty oldSlot = this.owlModel.createOWLObjectProperty("hasChildren");
        oldSlot.setDomain(oldCls);
        oldCls.addSuperclass(this.owlModel.createOWLMaxCardinality(oldSlot, 1));
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportFacetOverloadsTestCase.assertEquals((int)1, (int)newCls.getTemplateSlotMaximumCardinality(newSlot));
    }

    public void testImportMinCardiRestriction() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty oldSlot = this.owlModel.createOWLObjectProperty("hasChildren");
        oldSlot.setDomain(oldCls);
        oldCls.addSuperclass(this.owlModel.createOWLMinCardinality(oldSlot, 1));
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportFacetOverloadsTestCase.assertEquals((int)1, (int)newCls.getTemplateSlotMinimumCardinality(newSlot));
    }
}

