/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.importer.tests.AbstractOWLImporterTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import java.util.Collections;

public class ImportSlotsTestCase
extends AbstractOWLImporterTestCase {
    public void testImportIntegerSlot() {
        OWLNamedClass dummyCls = this.owlModel.createOWLNamedClass("Dummy");
        OWLDatatypeProperty oldSlot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDint());
        oldSlot.setDomain(dummyCls);
        oldSlot.setFunctional(true);
        KnowledgeBase kb = this.runOWLImporter();
        Slot slot = kb.getSlot(oldSlot.getName());
        ImportSlotsTestCase.assertNotNull((Object)slot);
        ImportSlotsTestCase.assertEquals((Object)ValueType.INTEGER, (Object)slot.getValueType());
        ImportSlotsTestCase.assertFalse((boolean)slot.getAllowsMultipleValues());
        ImportSlotsTestCase.assertSize(1, slot.getDirectDomain());
    }

    public void testImportSymbolSlot() {
        OWLNamedClass dummyCls = this.owlModel.createOWLNamedClass("Dummy");
        OWLDatatypeProperty oldSlot = this.owlModel.createOWLDatatypeProperty("slot", new RDFSLiteral[]{this.owlModel.createRDFSLiteral("value")});
        oldSlot.setDomain(dummyCls);
        KnowledgeBase kb = this.runOWLImporter();
        Slot slot = kb.getSlot(oldSlot.getName());
        ImportSlotsTestCase.assertNotNull((Object)slot);
        ImportSlotsTestCase.assertEquals((Object)ValueType.SYMBOL, (Object)slot.getValueType());
        ImportSlotsTestCase.assertSize(1, slot.getAllowedValues());
        ImportSlotsTestCase.assertEquals((Object)"value", slot.getAllowedValues().iterator().next());
    }

    public void testImportObjectSlot() {
        OWLNamedClass dummyCls = this.owlModel.createOWLNamedClass("Dummy");
        OWLObjectProperty oldSlot = this.owlModel.createOWLObjectProperty("slot");
        OWLObjectProperty oldInverseSlot = this.owlModel.createOWLObjectProperty("inverse");
        oldSlot.setInverseProperty(oldInverseSlot);
        oldSlot.setDomain(dummyCls);
        oldSlot.setFunctional(false);
        oldSlot.setUnionRangeClasses(Collections.singleton(dummyCls));
        KnowledgeBase kb = this.runOWLImporter();
        Slot slot = kb.getSlot(oldSlot.getName());
        ImportSlotsTestCase.assertNotNull((Object)slot);
        ImportSlotsTestCase.assertTrue((boolean)oldSlot.hasObjectRange());
        ImportSlotsTestCase.assertTrue((boolean)slot.getAllowsMultipleValues());
        ImportSlotsTestCase.assertSize(1, slot.getAllowedClses());
        ImportSlotsTestCase.assertEquals((Object)kb.getCls(dummyCls.getName()), slot.getAllowedClses().iterator().next());
        Slot newInverseSlot = kb.getSlot(oldInverseSlot.getName());
        ImportSlotsTestCase.assertNotNull((Object)newInverseSlot);
        ImportSlotsTestCase.assertEquals((Object)newInverseSlot, (Object)slot.getInverseSlot());
    }

    public void testImportDomainlessSlotWithRestriction() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty oldSlot = this.owlModel.createOWLObjectProperty("oldSlot");
        oldSlot.setDomainDefined(false);
        oldCls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)oldSlot, oldCls));
        KnowledgeBase kb = this.runOWLImporter();
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportSlotsTestCase.assertSize(1, newSlot.getDirectDomain());
        Cls newCls = kb.getCls(oldCls.getName());
        ImportSlotsTestCase.assertContains((Object)newCls, newSlot.getDirectDomain());
        ImportSlotsTestCase.assertContains((Object)newCls, newCls.getTemplateSlotAllowedClses(newSlot));
    }

    public void testImportDomainlessSlotWithoutRestriction() {
        OWLObjectProperty oldSlot = this.owlModel.createOWLObjectProperty("oldSlot");
        oldSlot.setDomainDefined(false);
        KnowledgeBase kb = this.runOWLImporter();
        Slot newSlot = kb.getSlot(oldSlot.getName());
        ImportSlotsTestCase.assertSize(1, newSlot.getDirectDomain());
        ImportSlotsTestCase.assertContains((Object)kb.getRootCls(), newSlot.getDirectDomain());
        ImportSlotsTestCase.assertSize(1, kb.getRootCls().getDirectTemplateSlots());
    }
}

