/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;
import java.util.List;

public class LoadProtegeFeaturesTestCase
extends AbstractJenaTestCase {
    public void testLoadAbstractFlag() throws Exception {
        this.loadRemoteOntology("abstractClass.owl");
        RDFProperty abstractProperty = this.owlModel.getRDFProperty("protege:abstract");
        LoadProtegeFeaturesTestCase.assertNotNull((Object)abstractProperty);
        TripleStore homeTripleStore = this.owlModel.getTripleStoreModel().getHomeTripleStore(abstractProperty);
        Object protegeTripleStore = this.owlModel.getTripleStoreModel().getTripleStores().get(2);
        LoadProtegeFeaturesTestCase.assertEquals(protegeTripleStore, (Object)homeTripleStore);
        OWLNamedClass cls = this.owlModel.getOWLNamedClass("Cls");
        Object propertyValue = cls.getPropertyValue(abstractProperty);
        LoadProtegeFeaturesTestCase.assertEquals((Object)Boolean.TRUE, (Object)propertyValue);
        LoadProtegeFeaturesTestCase.assertTrue((boolean)cls.isAbstract());
        OWLOntology ontology = this.owlModel.getDefaultOWLOntology();
        Collection imps = ontology.getImports();
        LoadProtegeFeaturesTestCase.assertSize(1, imps);
        Collection irs = ontology.getImportResources();
        LoadProtegeFeaturesTestCase.assertSize(1, irs);
    }

    public void testLoadFromTo() throws Exception {
        this.loadRemoteOntology("ProtegeFromTo.owl");
        RDFProperty fromProperty = this.owlModel.getRDFProperty(":FROM");
        LoadProtegeFeaturesTestCase.assertNotNull((Object)fromProperty);
        RDFProperty toProperty = this.owlModel.getRDFProperty(":TO");
        LoadProtegeFeaturesTestCase.assertNotNull((Object)toProperty);
        RDFResource relation = this.owlModel.getRDFResource("relation");
        LoadProtegeFeaturesTestCase.assertNotNull((Object)relation);
        LoadProtegeFeaturesTestCase.assertSize(1, relation.getPropertyValues(fromProperty));
        LoadProtegeFeaturesTestCase.assertSize(1, relation.getPropertyValues(toProperty));
    }

    public void testDomainOfFromAndTo() throws Exception {
        Slot directDomainSlot = this.owlModel.getSlot(":DIRECT-DOMAIN");
        RDFSNamedClass dbrClass = this.owlModel.getRDFSNamedClass(":DIRECTED-BINARY-RELATION");
        RDFProperty fromProperty = this.owlModel.getRDFProperty(":FROM");
        RDFProperty toProperty = this.owlModel.getRDFProperty(":TO");
        List directDomains = fromProperty.getDirectOwnSlotValues(directDomainSlot);
        LoadProtegeFeaturesTestCase.assertSize(1, directDomains);
        LoadProtegeFeaturesTestCase.assertContains((Object)dbrClass, directDomains);
        this.loadRemoteOntology("ProtegeFromTo.owl");
        LoadProtegeFeaturesTestCase.assertNotNull((Object)dbrClass);
        LoadProtegeFeaturesTestCase.assertNotNull((Object)fromProperty);
        LoadProtegeFeaturesTestCase.assertNotNull((Object)toProperty);
        LoadProtegeFeaturesTestCase.assertSize(1, fromProperty.getDomains(false));
        LoadProtegeFeaturesTestCase.assertEquals((Object)dbrClass, (Object)fromProperty.getDomain(false));
        directDomains = fromProperty.getDirectOwnSlotValues(directDomainSlot);
        LoadProtegeFeaturesTestCase.assertSize(1, directDomains);
        LoadProtegeFeaturesTestCase.assertContains((Object)dbrClass, directDomains);
    }
}

