/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Protege2Jena {
    private Model dummyModel = ModelFactory.createDefaultModel();
    private Collection fillTripleStores;
    private OWLModel owlModel;
    private OntModel ontModel;
    private Map tripleStore2Model;
    private TripleStoreModel tripleStoreModel;
    private static final String TEMP_SUFFIX = ".temp";

    private Protege2Jena(OWLModel owlModel, OntModel ontModel, Collection fillTripleStores, Map tripleStore2Model) {
        this.fillTripleStores = fillTripleStores;
        this.owlModel = owlModel;
        this.ontModel = ontModel;
        this.tripleStoreModel = owlModel.getTripleStoreModel();
        this.tripleStore2Model = tripleStore2Model;
        this.createSubModels();
        this.fillModels();
    }

    private void copyTriples(TripleStore tripleStore, Model model) {
        Iterator it = tripleStore.listTriples();
        while (it.hasNext()) {
            Triple triple = (Triple)it.next();
            Statement stmt = this.createStatement(triple, model);
            model.add(stmt);
        }
    }

    public static OntModel createOntModel(OWLModel owlModel) {
        return Protege2Jena.createOntModel(owlModel, OntModelSpec.OWL_MEM, owlModel.getTripleStoreModel().getTripleStores());
    }

    public static OntModel createOntModel(OWLModel owlModel, Collection fillTripleStores) {
        return Protege2Jena.createOntModel(owlModel, OntModelSpec.OWL_MEM, fillTripleStores);
    }

    public static OntModel createOntModel(OWLModel owlModel, Collection fillTripleStores, Map tripleStores2Model) {
        return Protege2Jena.createOntModel(owlModel, OntModelSpec.OWL_MEM, fillTripleStores, tripleStores2Model);
    }

    public static OntModel createOntModel(OWLModel owlModel, OntModelSpec spec, Collection fillTripleStores) {
        HashMap map = new HashMap();
        return Protege2Jena.createOntModel(owlModel, spec, fillTripleStores, map);
    }

    public static OntModel createOntModel(OWLModel owlModel, OntModelSpec spec, Collection fillTripleStores, Map tripleStore2Model) {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)spec);
        new Protege2Jena(owlModel, ontModel, fillTripleStores, tripleStore2Model);
        return ontModel;
    }

    private void createSubModels() {
        Iterator it = this.tripleStoreModel.listUserTripleStores();
        TripleStore baseTripleStore = (TripleStore)it.next();
        Model baseModel = this.ontModel.getBaseModel();
        this.tripleStore2Model.put(baseTripleStore, baseModel);
        while (it.hasNext()) {
            TripleStore tripleStore = (TripleStore)it.next();
            Model subModel = this.createSubModel(tripleStore);
            this.ontModel.addSubModel(subModel);
            this.tripleStore2Model.put(tripleStore, subModel);
        }
    }

    private Model createSubModel(TripleStore tripleStore) {
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    }

    private void createNamespacePrefixes(TripleStore tripleStore, Model model) {
        for (String prefix : model.getNsPrefixMap().keySet()) {
            model.removeNsPrefix(prefix);
        }
        for (String prefix : tripleStore.getPrefixes()) {
            String namespace = tripleStore.getNamespaceForPrefix(prefix);
            model.setNsPrefix(prefix, namespace);
        }
    }

    private Statement createStatement(Triple triple, Model model) {
        Resource subject = this.getResource(triple.getSubject(), model);
        Property predicate = this.getProperty(triple.getPredicate(), model);
        RDFNode object = this.getRDFNode(triple.getObject(), model);
        return model.createStatement(subject, predicate, object);
    }

    private void fillModels() {
        for (TripleStore tripleStore : this.tripleStore2Model.keySet()) {
            if (!this.fillTripleStores.contains(tripleStore)) continue;
            Model model = this.getModel(tripleStore);
            this.createNamespacePrefixes(tripleStore, model);
            this.copyTriples(tripleStore, model);
            this.removeRedundantRDFSDomains(model);
            this.removeRedundantRDFSSubClassOfOWLThings(model);
            this.removeRedundantRDFSSubClassOfEquivalentClasses(model);
            Protege2Jena.removeRedundantRDFLists(model);
        }
    }

    private Model getModel(TripleStore tripleStore) {
        return (Model)this.tripleStore2Model.get(tripleStore);
    }

    protected static Set getParseTypeCollectionProperties() {
        HashSet<Property> set = new HashSet<Property>();
        set.add(OWL.unionOf);
        set.add(OWL.intersectionOf);
        set.add(OWL.distinctMembers);
        set.add(OWL.oneOf);
        return set;
    }

    private Property getProperty(RDFProperty rdfProperty, Model model) {
        String uri = rdfProperty.getURI();
        Property property = this.dummyModel.getProperty(uri);
        if (property != null) {
            return property;
        }
        return this.dummyModel.createProperty(uri);
    }

    private RDFNode getRDFNode(Object object, Model model) {
        if (object instanceof RDFResource) {
            return this.getResource((RDFResource)object, model);
        }
        if (object instanceof RDFSLiteral) {
            RDFSLiteral literal = (RDFSLiteral)object;
            String language = literal.getLanguage();
            if (language != null) {
                String value = literal.getString();
                return model.createLiteral(value, language);
            }
            XSDDatatype datatype = XMLSchemaDatatypes.getXSDDatatype(literal.getDatatype());
            if (datatype == null && this.owlModel.getRDFXMLLiteralType().equals(literal.getDatatype())) {
                datatype = XMLLiteralType.theXMLLiteralType;
            }
            return model.createTypedLiteral(literal.getString(), (RDFDatatype)datatype);
        }
        return model.createTypedLiteral(object);
    }

    private Resource getResource(RDFResource rdfResource, Model model) {
        if (rdfResource.isAnonymous()) {
            AnonId anonId = new AnonId("_:" + rdfResource.getName());
            return model.createResource(anonId);
        }
        return model.getResource(rdfResource.getURI());
    }

    public static void removeRedundantRDFLists(Model model) {
        Set properties = Protege2Jena.getParseTypeCollectionProperties();
        for (Property property : properties) {
            NodeIterator objects = model.listObjectsOfProperty(property);
            while (objects.hasNext()) {
                Object object = objects.next();
                if (!(object instanceof Resource) || !((Resource)object).hasProperty(RDF.type, (RDFNode)RDF.List)) continue;
                Protege2Jena.removeRedundantRDFListsRecursively((Resource)object);
            }
        }
    }

    private static void removeRedundantRDFListsRecursively(Resource list) {
        if (!list.equals((Object)RDF.nil)) {
            Statement statement;
            if (list.hasProperty(RDF.type, (RDFNode)RDF.List)) {
                list.removeAll(RDF.type);
            }
            if ((statement = list.getProperty(RDF.rest)) != null) {
                Protege2Jena.removeRedundantRDFListsRecursively((Resource)statement.getObject());
            }
        }
    }

    private void removeRedundantRDFSDomains(Model model) {
        Set subjects = Jena.set((Iterator)model.listSubjectsWithProperty(RDFS.domain, (RDFNode)OWL.Thing));
        for (Resource resource : subjects) {
            StmtIterator vit = resource.listProperties(RDFS.domain);
            vit.next();
            if (vit.hasNext()) continue;
            resource.removeAll(RDFS.domain);
        }
    }

    private void removeRedundantRDFSSubClassOfOWLThings(Model model) {
        Set subjects = Jena.set((Iterator)model.listSubjectsWithProperty(RDFS.subClassOf, (RDFNode)OWL.Thing));
        for (Resource resource : subjects) {
            StmtIterator vit = resource.listProperties(RDFS.subClassOf);
            vit.next();
            if (vit.hasNext()) continue;
            resource.removeAll(RDFS.subClassOf);
        }
    }

    private void removeRedundantRDFSSubClassOfEquivalentClasses(Model model) {
        ResIterator classes = model.listSubjectsWithProperty(OWL.equivalentClass);
        while (classes.hasNext()) {
            Resource ontClass = (Resource)classes.next();
            Iterator equis = Jena.cloneIt((Iterator)ontClass.listProperties(OWL.equivalentClass));
            while (equis.hasNext()) {
                Resource equi = (Resource)((Statement)equis.next()).getObject();
                if (model.contains(equi, OWL.intersectionOf)) {
                    RDFNode operandsListNode = model.listObjectsOfProperty(equi, OWL.intersectionOf).nextNode();
                    if (!operandsListNode.canAs(RDFList.class)) continue;
                    RDFList operandsList = (RDFList)operandsListNode.as(RDFList.class);
                    for (Resource operand : operandsList) {
                        if (operand.isAnon()) continue;
                        model.removeAll(ontClass, RDFS.subClassOf, (RDFNode)operand);
                    }
                    continue;
                }
                if (equi.isAnon()) continue;
                model.removeAll(ontClass, RDFS.subClassOf, (RDFNode)equi);
                model.removeAll(equi, RDFS.subClassOf, (RDFNode)ontClass);
            }
        }
    }

    public static void saveAll(OWLModel owlModel, URI uri) throws Exception {
        String language = "RDF/XML-ABBREV";
        Protege2Jena.saveAll(owlModel, uri, "RDF/XML-ABBREV");
    }

    public static void saveAll(OWLModel owlModel, URI uri, String language) throws Exception {
        ArrayList fillTripleStores = new ArrayList();
        Iterator ts = owlModel.getTripleStoreModel().listUserTripleStores();
        fillTripleStores.add(ts.next());
        while (ts.hasNext()) {
            TripleStore tripleStore = (TripleStore)ts.next();
            String name = tripleStore.getName();
            URI ontologyName = new URI(name);
            Repository rep = owlModel.getRepositoryManager().getRepository(ontologyName);
            if (rep == null || !rep.isWritable(ontologyName)) continue;
            fillTripleStores.add(tripleStore);
        }
        HashMap tripleStore2Model = new HashMap();
        OntModel ontModel = Protege2Jena.createOntModel(owlModel, fillTripleStores, tripleStore2Model);
        File file = new File(uri);
        String namespace = owlModel.getNamespaceManager().getDefaultNamespace();
        JenaOWLModel.save(file, ontModel, language, namespace);
        Iterator tripleStores = owlModel.getTripleStoreModel().listUserTripleStores();
        tripleStores.next();
        while (tripleStores.hasNext()) {
            TripleStore tripleStore = (TripleStore)tripleStores.next();
            if (!fillTripleStores.contains(tripleStore)) continue;
            Model model = (Model)tripleStore2Model.get(tripleStore);
            String name = tripleStore.getName();
            URI ontologyName = new URI(name);
            Repository rep = owlModel.getRepositoryManager().getRepository(ontologyName);
            System.out.println("Saving import " + ontologyName + " to " + rep.getOntologyLocationDescription(ontologyName));
            OutputStream os = rep.getOutputStream(ontologyName);
            JenaOWLModel.saveModel(os, model, language, ontologyName + "#");
        }
        RepositoryFileManager fm = new RepositoryFileManager(owlModel);
        fm.saveGlobalRepositories();
        fm.saveProjectRepositories(uri);
        System.out.println("... saving successful.");
    }
}

