/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;

public class CreateAnnotationsTestCase
extends AbstractProtege2JenaTestCase {
    public void testCreateAnnotationProperty() {
        OWLDatatypeProperty slot = this.owlModel.createAnnotationOWLDatatypeProperty("slot");
        OntModel newModel = this.createOntModel();
        OntProperty property = newModel.getOntProperty(slot.getURI());
        CreateAnnotationsTestCase.assertTrue((boolean)property.hasRDFType(OWL.DatatypeProperty));
        CreateAnnotationsTestCase.assertTrue((boolean)property.hasRDFType(OWL.AnnotationProperty));
    }

    public void testAnonymousClassAnnotations() {
        OWLNamedClass namedCls = this.owlModel.createOWLNamedClass("Cls");
        OWLComplementClass anonymousCls = this.owlModel.createOWLComplementClass(namedCls);
        namedCls.addSuperclass(anonymousCls);
        OWLProperty annotationOWLProperty = (OWLProperty)this.owlModel.getSlot("rdfs:comment");
        anonymousCls.setPropertyValue(annotationOWLProperty, "A");
        OntModel newModel = this.createOntModel();
        ComplementClass anonClass = (ComplementClass)newModel.listComplementClasses().next();
        OntProperty annotationOntProperty = newModel.getOntProperty(annotationOWLProperty.getURI());
        CreateAnnotationsTestCase.assertHasValue((OntResource)anonClass, annotationOntProperty, ValueType.STRING, "A");
    }

    public void testLabels() {
        OWLNamedClass namedCls = this.owlModel.createOWLNamedClass("Cls");
        namedCls.addLabel("D", "de");
        namedCls.addLabel("E", "en");
        CreateAnnotationsTestCase.assertContains((Object)this.owlModel.createRDFSLiteral("D", "de"), namedCls.getPropertyValues(this.owlModel.getRDFSLabelProperty()));
        String uri = namedCls.getURI();
        OntModel newModel = this.createOntModel();
        OntClass ontClass = newModel.getOntClass(uri);
        CreateAnnotationsTestCase.assertEquals((String)"D", (String)ontClass.getLabel("de"));
        CreateAnnotationsTestCase.assertEquals((String)"E", (String)ontClass.getLabel("en"));
    }

    public void testNamedClassAnnotations() {
        OWLNamedClass namedCls = this.owlModel.createOWLNamedClass("Cls");
        OWLProperty annotationProperty = (OWLProperty)this.owlModel.getSlot("rdfs:comment");
        namedCls.setPropertyValue(annotationProperty, "A");
        String uri = namedCls.getURI();
        OntModel newModel = this.createOntModel();
        OntClass ontClass = newModel.getOntClass(uri);
        OntProperty annotationOntProperty = newModel.getOntProperty(annotationProperty.getURI());
        CreateAnnotationsTestCase.assertHasValue((OntResource)ontClass, annotationOntProperty, ValueType.STRING, "A");
    }

    public void testPropertyAnnotations() {
        OWLDatatypeProperty owlProperty = this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDstring());
        OWLProperty annotationProperty = (OWLProperty)this.owlModel.getSlot("rdfs:comment");
        owlProperty.setPropertyValue(annotationProperty, "A");
        String uri = owlProperty.getURI();
        OntModel newModel = this.createOntModel();
        DatatypeProperty ontProperty = newModel.getDatatypeProperty(uri);
        OntProperty annotationOntProperty = newModel.getOntProperty(annotationProperty.getURI());
        CreateAnnotationsTestCase.assertHasValue((OntResource)ontProperty, annotationOntProperty, ValueType.STRING, "A");
    }
}

